/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.prettierjs;

import com.intellij.codeStyle.AbstractConvertLineSeparatorsAction;
import com.intellij.diff.comparison.iterables.FairDiffIterable;
import com.intellij.diff.tools.util.text.LineOffsets;
import com.intellij.diff.tools.util.text.LineOffsetsUtil;
import com.intellij.diff.util.DiffRangeUtil;
import com.intellij.diff.util.Range;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.ex.RangesBuilder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.prettierjs.FormattingDiff;
import com.intellij.util.LineSeparator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a(\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0001H\u0000\u001a\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0001H\u0000\u001a\"\u0010\u0013\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0000\u00a8\u0006\u0016"}, d2={"computeFormattingDiff", "Lcom/intellij/prettierjs/FormattingDiff;", "originalContent", "", "formattedContent", "", "cursorOffset", "", "applyFormattingDiff", "", "project", "Lcom/intellij/openapi/project/Project;", "document", "Lcom/intellij/openapi/editor/Document;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "formattingDiff", "applyTextDifferencesToDocument", "", "updateLineSeparatorIfNeeded", "newSeparator", "Lcom/intellij/util/LineSeparator;", "intellij.prettierJS"})
public final class PrettierFormatUtilKt {
    @NotNull
    public static final FormattingDiff computeFormattingDiff(@NotNull CharSequence originalContent, @NotNull String formattedContent, int cursorOffset) {
        Intrinsics.checkNotNullParameter((Object)originalContent, (String)"originalContent");
        Intrinsics.checkNotNullParameter((Object)formattedContent, (String)"formattedContent");
        LineSeparator detectedLineSeparator = StringUtil.detectSeparators((CharSequence)formattedContent);
        int[] nArray = new int[]{cursorOffset};
        int[] offsetsToKeep = nArray;
        String string = StringUtil.convertLineSeparators((String)formattedContent, (String)"\n", (int[])offsetsToKeep);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"convertLineSeparators(...)");
        String normalizedFormattedContent = string;
        LineOffsets lineOffsets = LineOffsetsUtil.create((CharSequence)originalContent);
        Intrinsics.checkNotNullExpressionValue((Object)lineOffsets, (String)"create(...)");
        LineOffsets originalLineOffsets = lineOffsets;
        LineOffsets lineOffsets2 = LineOffsetsUtil.create((CharSequence)normalizedFormattedContent);
        Intrinsics.checkNotNullExpressionValue((Object)lineOffsets2, (String)"create(...)");
        LineOffsets formattedLineOffsets = lineOffsets2;
        FairDiffIterable textDifferences = RangesBuilder.compareLines((CharSequence)originalContent, (CharSequence)normalizedFormattedContent, (LineOffsets)originalLineOffsets, (LineOffsets)formattedLineOffsets);
        int contentLengthDelta = normalizedFormattedContent.length() - originalContent.length();
        return new FormattingDiff(textDifferences, originalLineOffsets, formattedLineOffsets, normalizedFormattedContent, contentLengthDelta, detectedLineSeparator, offsetsToKeep[0]);
    }

    public static final boolean applyFormattingDiff(@NotNull Project project, @NotNull Document document, @NotNull VirtualFile virtualFile, @NotNull FormattingDiff formattingDiff) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        Intrinsics.checkNotNullParameter((Object)formattingDiff, (String)"formattingDiff");
        PrettierFormatUtilKt.applyTextDifferencesToDocument(document, formattingDiff);
        return PrettierFormatUtilKt.updateLineSeparatorIfNeeded(project, virtualFile, formattingDiff.getDetectedLineSeparator());
    }

    public static final void applyTextDifferencesToDocument(@NotNull Document document, @NotNull FormattingDiff formattingDiff) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)formattingDiff, (String)"formattingDiff");
        FairDiffIterable textDifferences = formattingDiff.getTextDifferences();
        LineOffsets originalLineOffsets = formattingDiff.getOriginalLineOffsets();
        LineOffsets formattedLineOffsets = formattingDiff.getFormattedLineOffsets();
        String formattedContent = formattingDiff.getNormalizedFormattedContent();
        Iterable iterable = textDifferences.iterateChanges();
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"iterateChanges(...)");
        for (Range change : CollectionsKt.reversed((Iterable)iterable)) {
            CharSequence replacementText;
            TextRange range;
            if (change.isEmpty()) continue;
            int originalStartLine = change.start1;
            int originalEndLine = change.end1;
            int formattedStartLine = change.start2;
            int formattedEndLine = change.end2;
            if (originalStartLine == originalEndLine) {
                CharSequence insertionText;
                Intrinsics.checkNotNullExpressionValue((Object)DiffRangeUtil.getLinesRange((LineOffsets)formattedLineOffsets, (int)formattedStartLine, (int)formattedEndLine, (boolean)false).subSequence((CharSequence)formattedContent), (String)"subSequence(...)");
                int offset = originalStartLine == document.getLineCount() ? document.getTextLength() : document.getLineStartOffset(originalStartLine);
                document.insertString(offset, (CharSequence)(insertionText + "\n"));
                continue;
            }
            if (formattedStartLine == formattedEndLine) {
                TextRange range2;
                Intrinsics.checkNotNullExpressionValue((Object)DiffRangeUtil.getLinesRange((LineOffsets)originalLineOffsets, (int)originalStartLine, (int)originalEndLine, (boolean)false), (String)"getLinesRange(...)");
                int startOffset = range2.getStartOffset();
                int endOffset = range2.getEndOffset();
                if (startOffset > 0) {
                    --startOffset;
                } else if (endOffset < document.getTextLength()) {
                    ++endOffset;
                }
                document.deleteString(startOffset, endOffset);
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)DiffRangeUtil.getLinesRange((LineOffsets)formattedLineOffsets, (int)formattedStartLine, (int)formattedEndLine, (boolean)false).subSequence((CharSequence)formattedContent), (String)"subSequence(...)");
            Intrinsics.checkNotNullExpressionValue((Object)DiffRangeUtil.getLinesRange((LineOffsets)originalLineOffsets, (int)originalStartLine, (int)originalEndLine, (boolean)false), (String)"getLinesRange(...)");
            document.replaceString(range.getStartOffset(), range.getEndOffset(), replacementText);
        }
    }

    public static final boolean updateLineSeparatorIfNeeded(@NotNull Project project, @NotNull VirtualFile virtualFile, @Nullable LineSeparator newSeparator) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        if (newSeparator != null && !Intrinsics.areEqual((Object)virtualFile.getDetectedLineSeparator(), (Object)newSeparator.getSeparatorString())) {
            AbstractConvertLineSeparatorsAction.changeLineSeparators((Project)project, (VirtualFile)virtualFile, (String)newSeparator.getSeparatorString());
            return true;
        }
        return false;
    }
}

