/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.prettierjs;

import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.lang.javascript.linter.MultiRootJSLinterLanguageServiceManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.prettierjs.PrettierConfiguration;
import com.intellij.prettierjs.PrettierLanguageServiceImpl;
import com.intellij.prettierjs.PrettierUtil;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0018\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014R\u0014\u0010\u0005\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0010"}, d2={"Lcom/intellij/prettierjs/PrettierLanguageServiceManager;", "Lcom/intellij/lang/javascript/linter/MultiRootJSLinterLanguageServiceManager;", "Lcom/intellij/prettierjs/PrettierLanguageServiceImpl;", "project", "Lcom/intellij/openapi/project/Project;", "cs", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "getCs$intellij_prettierJS", "()Lkotlinx/coroutines/CoroutineScope;", "createServiceInstance", "resolvedPackage", "Lcom/intellij/javascript/nodejs/util/NodePackage;", "workingDirectory", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.prettierJS"})
public final class PrettierLanguageServiceManager
extends MultiRootJSLinterLanguageServiceManager<PrettierLanguageServiceImpl> {
    @NotNull
    private final CoroutineScope cs;

    public PrettierLanguageServiceManager(final @NotNull Project project, @NotNull CoroutineScope cs) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        super(project, "prettier");
        this.cs = cs;
        MessageBusConnection messageBusConnection = project.getMessageBus().connect((Disposable)this);
        Topic topic = VirtualFileManager.VFS_CHANGES;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"VFS_CHANGES");
        messageBusConnection.subscribe(topic, (Object)new BulkFileListener(){

            public void after(List<? extends VFileEvent> events) {
                VFileEvent it;
                boolean bl;
                boolean $i$f$any;
                Iterable $this$any$iv;
                block9: {
                    Intrinsics.checkNotNullParameter(events, (String)"events");
                    $this$any$iv = events;
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            it = (VFileEvent)element$iv;
                            boolean bl2 = false;
                            if (!(!(it instanceof VFileContentChangeEvent) || PrettierUtil.isConfigFileOrPackageJson(((VFileContentChangeEvent)it).getFile()) || Intrinsics.areEqual((Object)".editorconfig", (Object)((VFileContentChangeEvent)it).getFile().getName()))) continue;
                            bl = true;
                            break block9;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    this.terminateServices();
                    if (PrettierConfiguration.getInstance(project).getCodeStyleSettingsModifierEnabled()) {
                        boolean bl3;
                        block10: {
                            $this$any$iv = events;
                            $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                bl3 = false;
                            } else {
                                for (Object element$iv : $this$any$iv) {
                                    it = (VFileEvent)element$iv;
                                    boolean bl4 = false;
                                    if (!it.isFromSave()) continue;
                                    bl3 = true;
                                    break block10;
                                }
                                bl3 = false;
                            }
                        }
                        if (bl3) {
                            CodeStyleSettingsManager.getInstance((Project)project).notifyCodeStyleSettingsChanged();
                        }
                    }
                }
            }
        });
    }

    @NotNull
    public final CoroutineScope getCs$intellij_prettierJS() {
        return this.cs;
    }

    @NotNull
    protected PrettierLanguageServiceImpl createServiceInstance(@NotNull NodePackage resolvedPackage, @NotNull VirtualFile workingDirectory) {
        Intrinsics.checkNotNullParameter((Object)resolvedPackage, (String)"resolvedPackage");
        Intrinsics.checkNotNullParameter((Object)workingDirectory, (String)"workingDirectory");
        Project project = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
        return new PrettierLanguageServiceImpl(project, workingDirectory);
    }
}

