/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.mocha.execution;

import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.intellij.javascript.testFramework.AbstractTestFileStructure;
import com.intellij.javascript.testFramework.JsTestSelector;
import com.intellij.javascript.testFramework.util.EscapeUtils;
import com.intellij.javascript.testing.detection.JsTestFrameworkDetectionUtilsKt;
import com.intellij.javascript.testing.detection.JsTestFrameworkDetector;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.nodejs.mocha.execution.MochaDetector;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MochaTestLocationProvider
implements SMTestLocator {
    private static final String SUITE_PROTOCOL_ID = "suite";
    private static final String TEST_PROTOCOL_ID = "test";
    private static final char SPLIT_CHAR = '.';
    private final String myUi;

    public MochaTestLocationProvider(@NotNull String ui) {
        if (ui == null) {
            MochaTestLocationProvider.$$$reportNull$$$0(0);
        }
        this.myUi = ui;
    }

    @NotNull
    public List<Location> getLocation(@NotNull String protocol, @NotNull String path, @Nullable String metaInfo, @NotNull Project project, @NotNull GlobalSearchScope scope) {
        boolean suite;
        if (protocol == null) {
            MochaTestLocationProvider.$$$reportNull$$$0(1);
        }
        if (path == null) {
            MochaTestLocationProvider.$$$reportNull$$$0(2);
        }
        if (project == null) {
            MochaTestLocationProvider.$$$reportNull$$$0(3);
        }
        if (scope == null) {
            MochaTestLocationProvider.$$$reportNull$$$0(4);
        }
        if ((suite = SUITE_PROTOCOL_ID.equals(protocol)) || TEST_PROTOCOL_ID.equals(protocol)) {
            Location location = this.getTestLocation(project, path, metaInfo, suite);
            List list = ContainerUtil.createMaybeSingletonList((Object)location);
            if (list == null) {
                MochaTestLocationProvider.$$$reportNull$$$0(5);
            }
            return list;
        }
        List<Location> list = Collections.emptyList();
        if (list == null) {
            MochaTestLocationProvider.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NotNull
    public List<Location> getLocation(@NotNull String protocol, @NotNull String path, @NotNull Project project, @NotNull GlobalSearchScope scope) {
        if (protocol == null) {
            MochaTestLocationProvider.$$$reportNull$$$0(7);
        }
        if (path == null) {
            MochaTestLocationProvider.$$$reportNull$$$0(8);
        }
        if (project == null) {
            MochaTestLocationProvider.$$$reportNull$$$0(9);
        }
        if (scope == null) {
            MochaTestLocationProvider.$$$reportNull$$$0(10);
        }
        throw new IllegalStateException("Should not be called");
    }

    @Nullable
    private Location getTestLocation(@NotNull Project project, @NotNull String locationData, @Nullable String testFilePath, boolean isSuite) {
        List path;
        if (project == null) {
            MochaTestLocationProvider.$$$reportNull$$$0(11);
        }
        if (locationData == null) {
            MochaTestLocationProvider.$$$reportNull$$$0(12);
        }
        if ((path = EscapeUtils.split((String)locationData, (char)'.')).isEmpty()) {
            return null;
        }
        PsiElement psiElement = null;
        JsTestSelector testSelector = new JsTestSelector(path, isSuite);
        JSFile jsFile = MochaTestLocationProvider.findJSFile(project, testFilePath);
        if (jsFile != null) {
            AbstractTestFileStructure testFileStructure = MochaTestLocationProvider.getMochaDetector().findTestStructureForNavigation(jsFile, this.myUi);
            if (testFileStructure != null) {
                psiElement = testFileStructure.findPsiElement(testSelector);
            }
            if (psiElement == null) {
                psiElement = MochaTestLocationProvider.getMochaDetector().findPsiElementByProbableInterface(jsFile, this.myUi, testSelector);
            }
        }
        if (psiElement == null) {
            psiElement = JsTestFrameworkDetectionUtilsKt.findPsiElementInJsTestNamesIndexes((Project)project, (JsTestFrameworkDetector)MochaTestLocationProvider.getMochaDetector(), (JsTestSelector)testSelector);
        }
        if (psiElement != null) {
            return PsiLocation.fromPsiElement(psiElement);
        }
        return null;
    }

    @NotNull
    private static MochaDetector getMochaDetector() {
        MochaDetector mochaDetector = MochaDetector.Companion.getInstance();
        if (mochaDetector == null) {
            MochaTestLocationProvider.$$$reportNull$$$0(13);
        }
        return mochaDetector;
    }

    @Nullable
    private static VirtualFile findFile(@Nullable String filePath) {
        if (StringUtil.isEmptyOrSpaces((String)filePath)) {
            return null;
        }
        return LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)filePath));
    }

    @Nullable
    private static JSFile findJSFile(@NotNull Project project, @Nullable String testFilePath) {
        VirtualFile file;
        if (project == null) {
            MochaTestLocationProvider.$$$reportNull$$$0(14);
        }
        if ((file = MochaTestLocationProvider.findFile(testFilePath)) == null || !file.isValid()) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        return (JSFile)ObjectUtils.tryCast((Object)psiFile, JSFile.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ui";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "protocol";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 3: 
            case 9: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 5: 
            case 6: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/nodejs/mocha/execution/MochaTestLocationProvider";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locationData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/nodejs/mocha/execution/MochaTestLocationProvider";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocation";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getMochaDetector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getLocation";
                break;
            }
            case 5: 
            case 6: 
            case 13: {
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getTestLocation";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findJSFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 13 -> new IllegalStateException(string);
        };
    }
}

