/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.block.session;

import com.intellij.openapi.Disposable;
import com.intellij.terminal.session.StyleRange;
import com.jediterm.terminal.model.TerminalTextBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.TerminalUtil;
import org.jetbrains.plugins.terminal.block.session.BlockTerminalSession;
import org.jetbrains.plugins.terminal.block.session.ShellCommandOutputListener;
import org.jetbrains.plugins.terminal.block.session.ShellCommandOutputScraper;
import org.jetbrains.plugins.terminal.block.session.ShellCommandOutputScraperImplKt;
import org.jetbrains.plugins.terminal.block.session.StyledCommandOutput;
import org.jetbrains.plugins.terminal.block.session.scraper.CommandEndMarkerListeningStringCollector;
import org.jetbrains.plugins.terminal.block.session.scraper.DropTrailingNewLinesStringCollector;
import org.jetbrains.plugins.terminal.block.session.scraper.SimpleStringCollector;
import org.jetbrains.plugins.terminal.block.session.scraper.StringCollector;
import org.jetbrains.plugins.terminal.block.session.scraper.StylesCollectingTerminalLinesCollector;
import org.jetbrains.plugins.terminal.block.session.scraper.TerminalLinesCollector;
import org.jetbrains.plugins.terminal.block.session.util.Debouncer;
import org.jetbrains.plugins.terminal.util.TerminalUtilKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bB\u0011\b\u0016\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\n\u0010\u000eJ \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0015H\u0002J\b\u0010\u001a\u001a\u00020\u0015H\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/plugins/terminal/block/session/ShellCommandOutputScraperImpl;", "Lorg/jetbrains/plugins/terminal/block/session/ShellCommandOutputScraper;", "textBuffer", "Lcom/jediterm/terminal/model/TerminalTextBuffer;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "commandEndMarker", "", "debounceTimeout", "", "<init>", "(Lcom/jediterm/terminal/model/TerminalTextBuffer;Lcom/intellij/openapi/Disposable;Ljava/lang/String;I)V", "session", "Lorg/jetbrains/plugins/terminal/block/session/BlockTerminalSession;", "(Lorg/jetbrains/plugins/terminal/block/session/BlockTerminalSession;)V", "listeners", "", "Lorg/jetbrains/plugins/terminal/block/session/ShellCommandOutputListener;", "debouncer", "Lorg/jetbrains/plugins/terminal/block/session/util/Debouncer;", "addListener", "", "listener", "useExtendedDelayOnce", "", "onContentChanged", "doOnContentChanged", "scrapeOutput", "Lorg/jetbrains/plugins/terminal/block/session/StyledCommandOutput;", "Companion", "intellij.terminal"})
@SourceDebugExtension(value={"SMAP\nShellCommandOutputScraperImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShellCommandOutputScraperImpl.kt\norg/jetbrains/plugins/terminal/block/session/ShellCommandOutputScraperImpl\n+ 2 TerminalUiUtils.kt\norg/jetbrains/plugins/terminal/block/ui/TerminalUiUtilsKt\n*L\n1#1,124:1\n515#2,7:125\n*S KotlinDebug\n*F\n+ 1 ShellCommandOutputScraperImpl.kt\norg/jetbrains/plugins/terminal/block/session/ShellCommandOutputScraperImpl\n*L\n62#1:125,7\n*E\n"})
public final class ShellCommandOutputScraperImpl
implements ShellCommandOutputScraper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TerminalTextBuffer textBuffer;
    @Nullable
    private final String commandEndMarker;
    private final int debounceTimeout;
    @NotNull
    private final List<ShellCommandOutputListener> listeners;
    @NotNull
    private final Debouncer debouncer;

    public ShellCommandOutputScraperImpl(@NotNull TerminalTextBuffer textBuffer, @NotNull Disposable parentDisposable, @Nullable String commandEndMarker, int debounceTimeout) {
        Intrinsics.checkNotNullParameter((Object)textBuffer, (String)"textBuffer");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.textBuffer = textBuffer;
        this.commandEndMarker = commandEndMarker;
        this.debounceTimeout = debounceTimeout;
        this.listeners = new CopyOnWriteArrayList();
        this.debouncer = new Debouncer(this.debounceTimeout, parentDisposable);
        TerminalUtilKt.addModelListener(this.textBuffer, parentDisposable, () -> ShellCommandOutputScraperImpl._init_$lambda$0(this));
    }

    public /* synthetic */ ShellCommandOutputScraperImpl(TerminalTextBuffer terminalTextBuffer, Disposable disposable, String string, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            n = 50;
        }
        this(terminalTextBuffer, disposable, string, n);
    }

    public ShellCommandOutputScraperImpl(@NotNull BlockTerminalSession session2) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        this(session2.getModel().getTextBuffer$intellij_terminal(), session2, session2.getCommandBlockIntegration().getCommandEndMarker(), 0, 8, null);
    }

    @Override
    public void addListener(@NotNull ShellCommandOutputListener listener2, @NotNull Disposable parentDisposable, boolean useExtendedDelayOnce) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        TerminalUtil.addItem(this.listeners, listener2, parentDisposable);
        this.debouncer.setExtendedDelayOnce();
    }

    private final void onContentChanged() {
        if (!((Collection)this.listeners).isEmpty()) {
            this.debouncer.execute((Function0<Unit>)((Function0)new Function0<Unit>((Object)this){

                public final void invoke() {
                    ShellCommandOutputScraperImpl.access$doOnContentChanged((ShellCommandOutputScraperImpl)this.receiver);
                }
            }));
        }
    }

    private final void doOnContentChanged() {
        if (!((Collection)this.listeners).isEmpty()) {
            StyledCommandOutput output = this.scrapeOutput();
            for (ShellCommandOutputListener listener2 : this.listeners) {
                listener2.commandOutputChanged(output);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public StyledCommandOutput scrapeOutput() {
        StyledCommandOutput styledCommandOutput;
        TerminalTextBuffer $this$withLock$iv = this.textBuffer;
        boolean $i$f$withLock = false;
        $this$withLock$iv.lock();
        try {
            TerminalTextBuffer it = $this$withLock$iv;
            boolean bl = false;
            styledCommandOutput = org.jetbrains.plugins.terminal.block.session.ShellCommandOutputScraperImpl$Companion.scrapeOutput$default(Companion, this.textBuffer, this.commandEndMarker, 0, 4, null);
        }
        finally {
            $this$withLock$iv.unlock();
        }
        return styledCommandOutput;
    }

    private static final void _init_$lambda$0(ShellCommandOutputScraperImpl this$0) {
        this$0.onContentChanged();
    }

    public static final /* synthetic */ void access$doOnContentChanged(ShellCommandOutputScraperImpl $this) {
        $this.doOnContentChanged();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J$\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\b\u0002\u0010\f\u001a\u00020\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/plugins/terminal/block/session/ShellCommandOutputScraperImpl$Companion;", "", "<init>", "()V", "scrapeOutput", "Lorg/jetbrains/plugins/terminal/block/session/StyledCommandOutput;", "session", "Lorg/jetbrains/plugins/terminal/block/session/BlockTerminalSession;", "textBuffer", "Lcom/jediterm/terminal/model/TerminalTextBuffer;", "commandEndMarker", "", "startLine", "", "intellij.terminal"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final StyledCommandOutput scrapeOutput(@NotNull BlockTerminalSession session2) {
            Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
            return org.jetbrains.plugins.terminal.block.session.ShellCommandOutputScraperImpl$Companion.scrapeOutput$default(this, session2.getModel().getTextBuffer$intellij_terminal(), session2.getCommandBlockIntegration().getCommandEndMarker(), 0, 4, null);
        }

        @NotNull
        public final StyledCommandOutput scrapeOutput(@NotNull TerminalTextBuffer textBuffer, @Nullable String commandEndMarker, int startLine) {
            TerminalLinesCollector styleCollectingOutputBuilder2;
            Intrinsics.checkNotNullParameter((Object)textBuffer, (String)"textBuffer");
            Ref.BooleanRef commandEndMarkerFound = new Ref.BooleanRef();
            StringCollector stringCollector = new CommandEndMarkerListeningStringCollector(new DropTrailingNewLinesStringCollector(new SimpleStringCollector()), commandEndMarker, (Function0<Unit>)((Function0)() -> Companion.scrapeOutput$lambda$0(commandEndMarkerFound)));
            List styles = new ArrayList();
            TerminalLinesCollector terminalLinesCollector2 = styleCollectingOutputBuilder2 = (TerminalLinesCollector)new StylesCollectingTerminalLinesCollector(stringCollector, (Function1<? super StyleRange, Unit>)((Function1)new Function1<StyleRange, Unit>((Object)styles){

                public final void invoke(StyleRange p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    ((List)this.receiver).add(p0);
                }
            }));
            ShellCommandOutputScraperImplKt.collectLines(textBuffer, terminalLinesCollector2, startLine);
            return new StyledCommandOutput(stringCollector.buildText(), commandEndMarkerFound.element, styles);
        }

        public static /* synthetic */ StyledCommandOutput scrapeOutput$default(Companion companion, TerminalTextBuffer terminalTextBuffer, String string, int n, int n2, Object object) {
            if ((n2 & 2) != 0) {
                string = null;
            }
            if ((n2 & 4) != 0) {
                n = -terminalTextBuffer.getHistoryLinesCount();
            }
            return companion.scrapeOutput(terminalTextBuffer, string, n);
        }

        private static final Unit scrapeOutput$lambda$0(Ref.BooleanRef $commandEndMarkerFound) {
            $commandEndMarkerFound.element = true;
            return Unit.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

