import * as ts from "typescript/lib/tsserverlibrary"

import type {AreTypesMutuallyAssignableResponse, GetElementTypeResponse, GetSymbolTypeResponse, TypeRequestKind} from "./protocol"
import {ReverseMapper} from "./ide-get-element-type"
import {IdeProjectService} from "./ide-project-service"

declare global {
  type RegularMap<K, V> = Map<K, V>

  type ErrorKind = OperationCancelledException | FileOutsideOfImportGraphException | OutdatedTypeCheckerIdException

  type OperationCancelledException = "OperationCancelledException"
  type FileOutsideOfImportGraphException = "FileOutsideOfImportGraphException"
  type OutdatedTypeCheckerIdException = "OutdatedTypeCheckerIdException"

  interface Error {
    ideKind?: ErrorKind
  }
}

declare module "typescript/lib/tsserverlibrary" {

  interface TypeChecker {
    webStormCacheInfo?: {
      ideTypeCheckerId: number,
      ideProjectId: number,
      requestedTypeIds: Set<number>,
      seenTypeIds: RegularMap<number, Type>,
      seenSymbolIds: RegularMap<number, Symbol>,
    }
  }

  interface Type {
    id: number | undefined // internal
  }

  interface LanguageService {

    ideProjectId: number

    webStormGetElementType(
      ts: typeof import("typescript/lib/tsserverlibrary"),
      fileName: string,
      startOffset: number,
      endOffset: number,
      typeRequestKind: TypeRequestKind,
      forceReturnType: boolean,
      cancellationToken: ts.HostCancellationToken,
      reverseMapper?: ReverseMapper,
    ): GetElementTypeResponse

    webStormGetSymbolType(
      ts: typeof import("typescript/lib/tsserverlibrary"),
      symbolId: number,
      cancellationToken: ts.HostCancellationToken,
      reverseMapper?: ReverseMapper,
    ): GetSymbolTypeResponse

    webStormGetTypeProperties(
      ts: typeof import("typescript/lib/tsserverlibrary"),
      typeId: number,
      cancellationToken: ts.HostCancellationToken,
      reverseMapper?: ReverseMapper,
    ): GetElementTypeResponse

    webStormAreTypesMutuallyAssignable(
      ts: typeof import("typescript/lib/tsserverlibrary"),
      type1Id: number,
      type2Id: number,
      cancellationToken: ts.HostCancellationToken,
    ): AreTypesMutuallyAssignableResponse
  }

  namespace server {
    interface ProjectService {
      ideProjectService: IdeProjectService
    }
    interface Project {
      ideProjectId: number
    }
  }

  function isExpression(node: ts.Node): node is ts.Expression
  function isEqualityOperatorKind(kind: ts.SyntaxKind): kind is ts.EqualityOperator
}

export = ts;
