/* sithwm - Minimalist Window Manager for X
 * see README for Copyright, license and other details. */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "sithwm.h"

Client *head_client;

static int getrand(int range)
{
   static unsigned int randnum;
   return range<=0?0:(randnum += 7912511)%range;
}

void place_client(ScreenInfo*screen, struct area *a)
{
   a->pos.x = getrand(screen->area.w-a->w)-opt_bw;
   a->pos.y = getrand(screen->area.h-a->h)-opt_bw;
}

char default_name[2] = "*";

void make_new_client(Window w, ScreenInfo*s, int flags)
{
   XWindowAttributes winattr;
   XGetWindowAttributes(dpy, w, &winattr);
   LOG_DEBUG("\tWindow: 0x%lx (%s) %dx%d+%d+%d\n", w, map_state_string(winattr.map_state),
	     winattr.width, winattr.height, winattr.x, winattr.y);
   if (winattr.override_redirect || (flags && winattr.map_state != IsViewable))
      return;

   Client *c = (Client*)calloc(1, sizeof(Client));

   /* Put it second on the list, since we may not want it to be active - if on other screen. */
   Client **inspt = &head_client;
   if (head_client)
      inspt = &(head_client->next);
   c->next = (*inspt);
   (*inspt) = c;
   c->dyn.window = w;
   c->screen = s;
   c->name = default_name;

   c->dyn.area.w = winattr.width;
   c->dyn.area.h = winattr.height;
   c->dyn.area.pos.x = (unsigned int)winattr.x;
   c->dyn.area.pos.y = (unsigned int)winattr.y;
   if (!flags &&
       ( winattr.x<-20 || winattr.y<-20 || (winattr.x==0&&winattr.y==0) ||
	 (winattr.x+winattr.width) > c->screen->area.w ||
	 (winattr.y+winattr.height) > c->screen->area.h)
	) {
      place_client(s, &c->dyn.area);
   }
   toworldpos(c, c->dyn.area.pos.x, c->dyn.area.pos.y, &c->dyn.area.pos);
   LOG_DEBUG("\twindow started as %dx%d +%d+%d\n", c->dyn.area.w, c->dyn.area.h, c->dyn.area.pos.x, c->dyn.area.pos.y);

#ifdef DEBUG
   {
      Client *p;
      int i = 0;
      for (p = head_client; p; p = p->next)
	 i++;
      LOG_DEBUG("make_new_client() : new window %dx%d+%d+%d, wincount=%d\n", c->dyn.area.w, c->dyn.area.h, c->dyn.area.pos.x, c->dyn.area.pos.y, i);
   }
#endif

   XSelectInput(dpy, c->dyn.window, ColormapChangeMask | EnterWindowMask | PropertyChangeMask | FocusChangeMask);
#ifdef DEBUG
   XSync(dpy, 0);
#endif
   func_grab(c->dyn.window);
#if DEATHSTAR
   /* Read instance/class information for client and check against list
    * built with -app options */
   XClassHint *xclass = XAllocClassHint();
   if (xclass) {
      Application *a = head_app;
      XGetClassHint(dpy, w, xclass);
      LOG_DEBUG("\tClass %s %s\n", xclass->res_name?xclass->res_name:"(nollinolli)", xclass->res_class?xclass->res_class:"(nollinolli)");
      while (a) {
	 if ((!a->res_name || (xclass->res_name && !strcmp(xclass->res_name, a->res_name)))
	     && (!a->res_class || (xclass->res_class && !strcmp(xclass->res_class, a->res_class)))) {
	    if (a->geometry_mask & WidthValue)
	       c->dyn.area.w = a->area.w;
	    if (a->geometry_mask & HeightValue)
	       c->dyn.area.h = a->area.h ;
	    if (a->geometry_mask & XValue) {
	       if (a->geometry_mask & XNegative)
		  c->dyn.area.pos.x = a->area.pos.x + c->screen->area.w-c->dyn.area.w;
	       else
		  c->dyn.area.pos.x = a->area.pos.x;
	    }
	    if (a->geometry_mask & YValue) {
	       if (a->geometry_mask & YNegative)
		  c->dyn.area.pos.y = a->area.pos.y + c->screen->area.h-c->dyn.area.h;
	       else
		  c->dyn.area.pos.y = a->area.pos.y;
	    }
	    c->dyn.sticky = a->sticky;
	 }
	 a = a->next;
      }
      XFree(xclass->res_class);
      XFree(xclass->res_name);
      XFree(xclass);
   }
#endif
   XSetWindowBorderWidth(dpy, c->dyn.window, opt_bw);
   select_client(c, XACT_NEW<<FUNC_SHIFT);
}

void get_client_props(Client*client)
{
   if (client->name != default_name)
      XFree(client->name);
   XFetchName(dpy, client->dyn.window, &client->name);
   if (!client->name)
      client->name = default_name;
   XWMHints *hints = XGetWMHints(dpy, client->dyn.window);
   if (hints) {

      LOG_DEBUG("Hints: 0x%lx %s %s:%i \n", client->dyn.window, client->name, hints->flags&InputHint?"inp":"inv", hints->input);

      if (hints->flags&InputHint && !hints->input)
	 client->dyn.opts |= FL_INPUT;

#ifndef STORMTROOPER
      client->icon = (hints->flags&IconWindowHint)?hints->icon_window:
	 ((hints->flags&IconPixmapHint)?hints->icon_pixmap:client->dyn.window);
      {
	 Window root_return;
	 int x_return, y_return;
	 unsigned int border_width_return,depth_return;
	 XGetGeometry(dpy, client->icon, &root_return,
		      &x_return, &y_return,
		      &client->icon_width, &client->icon_height,
		      &border_width_return, &depth_return);
      }
#endif

      XFree(hints);
   }
}

#ifdef DEBUG
const char *map_state_string(int map_state) {
	const char *map_states[4] = {
		"IsUnmapped",
		"IsUnviewable",
		"IsViewable",
		"Unknown"
	};
	return ((unsigned int)map_state < 3)
		? map_states[map_state]
		: map_states[3];
}
#endif

/* used all over the place.  return the client that has specified window */

Client *find_client(Window w) {
   Client *c;
   for (c = head_client; c; c = c->next)
      if (w == c->dyn.window)
	 return c;
   return NULL;
}

Client* select_window(Window w, unsigned int func)
{
   Client*c = find_client(w);
   select_client(c, func);
   return c;
}

void select_client(Client *c, unsigned int funcmask)
{
   LOG_DEBUG("select_client() : 0x%lx Actions: 0x%x\n", c?c->dyn.window:0, funcmask);
   if (!c)
      return;

   unsigned int func = funcmask >> FUNC_SHIFT;
   if ((c->dyn.area.w+c->dyn.area.h) > min_size_for_func[func])
      funcmask |= setmodifiers[func];

   LOG_DEBUG("SEL:0x%lx ", c->dyn.window);
   prt_mask(funcmask, funcmasks);
   LOG_DEBUG("\n");

   ScreenInfo*screen=c->screen;

   if (funcmask & (FMOD_MAXIMISE|FMOD_FIX)) {
      toviewpos(c, &c->dyn.area.pos);
      if (funcmask & FMOD_FIX) {
	 c->dyn.sticky ^= '!';
      } else {
	 c->dyn.area.w = screen->area.w>>(c->dyn.maxim_state&1);
	 c->dyn.area.h = screen->area.h>>(((c->dyn.maxim_state)>>1)&1);
	 place_client(screen, &c->dyn.area);
	 c->dyn.maxim_state++;
      }
      toworldpos(c, c->dyn.area.pos.x, c->dyn.area.pos.y, &c->dyn.area.pos);
   }

   if (funcmask&FMOD_SET_VIEW && !c->dyn.sticky)
   {
      int i;
      /* try first the desktop we've got, then the last screen pos for
	 this client, then the clients position - wich should match
	 for sure. */
      for (i=0;
	   i<2 && !intersect(&screen->area, &c->dyn.area);
	   i++) {
	 screen->area.pos = (!i)?c->last_screen:c->dyn.area.pos;
      }
   }

   if (funcmask&(FMOD_RAISE|FMOD_MAXIMISE)) {
      struct pos r;
      toviewpos(c, &r);
      XMoveResizeWindow(dpy, c->dyn.window, r.x, r.y, c->dyn.area.w, c->dyn.area.h);
      XMapRaised(dpy, c->dyn.window);
      if (screen->infow_func>screen->do_infow_func)
	 screen->do_infow_func = screen->infow_func;
      LOG_DEBUG("raise() : 0x%lx\n", c?c->dyn.window:0);
   }

   if (c->screen == current_screen)
   {
      if ((funcmask&FMOD_FOCUS) && c != head_client) {
	 Client *ccc;
	 for (ccc = head_client; ccc; ccc = ccc->next) {
	    if (ccc->next == c) {
	       ccc->next = c->next;
	       c->next = head_client;
	       head_client = c;
	       break;
	    }
	 }
      }
      if (funcmask&FMOD_SETMOUSE)
	 XWarpPointer(dpy, None, c->dyn.window, 0, 0, 0, 0,
		      (c->last_cursor.x>0&&c->last_cursor.x<c->dyn.area.w)?c->last_cursor.x:(c->dyn.area.w>>1),
		      (c->last_cursor.y>0&&c->last_cursor.y<c->dyn.area.h)?c->last_cursor.y:(c->dyn.area.h>>1));
   }
   get_client_props(c);
}
