/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import java.awt.Dimension;
import java.io.File;
import java.util.Collection;
import java.util.Map;
import org.fest.util.Arrays;
import org.fest.util.Collections;
import org.fest.util.Maps;
import org.fest.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ToString {
    static String toStringOf(Object o) {
        if (ToString.isOneDimensionalArray(o)) {
            return Arrays.format((Object)o);
        }
        if (o instanceof Class) {
            return ToString.toStringOf((Class)o);
        }
        if (o instanceof Collection) {
            return ToString.toStringOf((Collection)o);
        }
        if (o instanceof Map) {
            return ToString.toStringOf((Map)o);
        }
        if (o instanceof File) {
            return ToString.toStringOf((File)o);
        }
        if (o instanceof Dimension) {
            return ToString.toStringOf((Dimension)o);
        }
        if (o instanceof String) {
            return Strings.quote((String)((String)o));
        }
        return o == null ? null : o.toString();
    }

    private static boolean isOneDimensionalArray(Object o) {
        return o != null && o.getClass().isArray();
    }

    private static String toStringOf(Class<?> c) {
        return c.getName();
    }

    private static String toStringOf(Collection<?> c) {
        return Collections.format(c);
    }

    private static String toStringOf(Map<?, ?> m) {
        return Maps.format(m);
    }

    private static String toStringOf(File f) {
        return f.getAbsolutePath();
    }

    private static String toStringOf(Dimension d) {
        return Strings.concat((Object[])new Object[]{"(", d.width, ", ", d.height, ")"});
    }

    private ToString() {
    }
}

