// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// Backend Backend with all it's children resources
//
// swagger:model Backend
type Backend struct {
	BackendBase `json:",inline"`

	// Acl list
	ACLList Acls `json:"acl_list,omitempty"`

	// filter list
	FilterList Filters `json:"filter_list,omitempty"`

	// HTTP after response rule list
	HTTPAfterResponseRuleList HTTPAfterResponseRules `json:"http_after_response_rule_list,omitempty"`

	// HTTP check list
	HTTPCheckList HTTPChecks `json:"http_check_list,omitempty"`

	// HTTP error rule list
	HTTPErrorRuleList HTTPErrorRules `json:"http_error_rule_list,omitempty"`

	// HTTP request rule list
	HTTPRequestRuleList HTTPRequestRules `json:"http_request_rule_list,omitempty"`

	// HTTP response rule list
	HTTPResponseRuleList HTTPResponseRules `json:"http_response_rule_list,omitempty"`

	// log target list
	LogTargetList LogTargets `json:"log_target_list,omitempty"`

	// server switching rule list
	ServerSwitchingRuleList ServerSwitchingRules `json:"server_switching_rule_list,omitempty"`

	// stick rule list
	StickRuleList StickRules `json:"stick_rule_list,omitempty"`

	// TCP check rule list
	TCPCheckRuleList TCPChecks `json:"tcp_check_rule_list,omitempty"`

	// TCP request rule list
	TCPRequestRuleList TCPRequestRules `json:"tcp_request_rule_list,omitempty"`

	// TCP response rule list
	TCPResponseRuleList TCPResponseRules `json:"tcp_response_rule_list,omitempty"`

	// server templates
	ServerTemplates map[string]ServerTemplate `json:"server_templates,omitempty"`

	// servers
	Servers map[string]Server `json:"servers,omitempty"`
}

// UnmarshalJSON unmarshals this object from a JSON structure
func (m *Backend) UnmarshalJSON(raw []byte) error {
	// AO0
	var aO0 BackendBase
	if err := swag.ReadJSON(raw, &aO0); err != nil {
		return err
	}
	m.BackendBase = aO0

	// AO1
	var dataAO1 struct {
		ACLList Acls `json:"acl_list,omitempty"`

		FilterList Filters `json:"filter_list,omitempty"`

		HTTPAfterResponseRuleList HTTPAfterResponseRules `json:"http_after_response_rule_list,omitempty"`

		HTTPCheckList HTTPChecks `json:"http_check_list,omitempty"`

		HTTPErrorRuleList HTTPErrorRules `json:"http_error_rule_list,omitempty"`

		HTTPRequestRuleList HTTPRequestRules `json:"http_request_rule_list,omitempty"`

		HTTPResponseRuleList HTTPResponseRules `json:"http_response_rule_list,omitempty"`

		LogTargetList LogTargets `json:"log_target_list,omitempty"`

		ServerSwitchingRuleList ServerSwitchingRules `json:"server_switching_rule_list,omitempty"`

		StickRuleList StickRules `json:"stick_rule_list,omitempty"`

		TCPCheckRuleList TCPChecks `json:"tcp_check_rule_list,omitempty"`

		TCPRequestRuleList TCPRequestRules `json:"tcp_request_rule_list,omitempty"`

		TCPResponseRuleList TCPResponseRules `json:"tcp_response_rule_list,omitempty"`

		ServerTemplates map[string]ServerTemplate `json:"server_templates,omitempty"`

		Servers map[string]Server `json:"servers,omitempty"`
	}
	if err := swag.ReadJSON(raw, &dataAO1); err != nil {
		return err
	}

	m.ACLList = dataAO1.ACLList

	m.FilterList = dataAO1.FilterList

	m.HTTPAfterResponseRuleList = dataAO1.HTTPAfterResponseRuleList

	m.HTTPCheckList = dataAO1.HTTPCheckList

	m.HTTPErrorRuleList = dataAO1.HTTPErrorRuleList

	m.HTTPRequestRuleList = dataAO1.HTTPRequestRuleList

	m.HTTPResponseRuleList = dataAO1.HTTPResponseRuleList

	m.LogTargetList = dataAO1.LogTargetList

	m.ServerSwitchingRuleList = dataAO1.ServerSwitchingRuleList

	m.StickRuleList = dataAO1.StickRuleList

	m.TCPCheckRuleList = dataAO1.TCPCheckRuleList

	m.TCPRequestRuleList = dataAO1.TCPRequestRuleList

	m.TCPResponseRuleList = dataAO1.TCPResponseRuleList

	m.ServerTemplates = dataAO1.ServerTemplates

	m.Servers = dataAO1.Servers

	return nil
}

// MarshalJSON marshals this object to a JSON structure
func (m Backend) MarshalJSON() ([]byte, error) {
	_parts := make([][]byte, 0, 2)

	aO0, err := swag.WriteJSON(m.BackendBase)
	if err != nil {
		return nil, err
	}
	_parts = append(_parts, aO0)
	var dataAO1 struct {
		ACLList Acls `json:"acl_list,omitempty"`

		FilterList Filters `json:"filter_list,omitempty"`

		HTTPAfterResponseRuleList HTTPAfterResponseRules `json:"http_after_response_rule_list,omitempty"`

		HTTPCheckList HTTPChecks `json:"http_check_list,omitempty"`

		HTTPErrorRuleList HTTPErrorRules `json:"http_error_rule_list,omitempty"`

		HTTPRequestRuleList HTTPRequestRules `json:"http_request_rule_list,omitempty"`

		HTTPResponseRuleList HTTPResponseRules `json:"http_response_rule_list,omitempty"`

		LogTargetList LogTargets `json:"log_target_list,omitempty"`

		ServerSwitchingRuleList ServerSwitchingRules `json:"server_switching_rule_list,omitempty"`

		StickRuleList StickRules `json:"stick_rule_list,omitempty"`

		TCPCheckRuleList TCPChecks `json:"tcp_check_rule_list,omitempty"`

		TCPRequestRuleList TCPRequestRules `json:"tcp_request_rule_list,omitempty"`

		TCPResponseRuleList TCPResponseRules `json:"tcp_response_rule_list,omitempty"`

		ServerTemplates map[string]ServerTemplate `json:"server_templates,omitempty"`

		Servers map[string]Server `json:"servers,omitempty"`
	}

	dataAO1.ACLList = m.ACLList

	dataAO1.FilterList = m.FilterList

	dataAO1.HTTPAfterResponseRuleList = m.HTTPAfterResponseRuleList

	dataAO1.HTTPCheckList = m.HTTPCheckList

	dataAO1.HTTPErrorRuleList = m.HTTPErrorRuleList

	dataAO1.HTTPRequestRuleList = m.HTTPRequestRuleList

	dataAO1.HTTPResponseRuleList = m.HTTPResponseRuleList

	dataAO1.LogTargetList = m.LogTargetList

	dataAO1.ServerSwitchingRuleList = m.ServerSwitchingRuleList

	dataAO1.StickRuleList = m.StickRuleList

	dataAO1.TCPCheckRuleList = m.TCPCheckRuleList

	dataAO1.TCPRequestRuleList = m.TCPRequestRuleList

	dataAO1.TCPResponseRuleList = m.TCPResponseRuleList

	dataAO1.ServerTemplates = m.ServerTemplates

	dataAO1.Servers = m.Servers

	jsonDataAO1, errAO1 := swag.WriteJSON(dataAO1)
	if errAO1 != nil {
		return nil, errAO1
	}
	_parts = append(_parts, jsonDataAO1)
	return swag.ConcatJSON(_parts...), nil
}

// Validate validates this backend
func (m *Backend) Validate(formats strfmt.Registry) error {
	var res []error

	// validation for a type composition with BackendBase
	if err := m.BackendBase.Validate(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateACLList(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateFilterList(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHTTPAfterResponseRuleList(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHTTPCheckList(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHTTPErrorRuleList(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHTTPRequestRuleList(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHTTPResponseRuleList(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLogTargetList(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateServerSwitchingRuleList(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStickRuleList(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTCPCheckRuleList(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTCPRequestRuleList(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTCPResponseRuleList(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateServerTemplates(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateServers(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Backend) validateACLList(formats strfmt.Registry) error {

	if swag.IsZero(m.ACLList) { // not required
		return nil
	}

	if err := m.ACLList.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("acl_list")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("acl_list")
		}
		return err
	}

	return nil
}

func (m *Backend) validateFilterList(formats strfmt.Registry) error {

	if swag.IsZero(m.FilterList) { // not required
		return nil
	}

	if err := m.FilterList.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("filter_list")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("filter_list")
		}
		return err
	}

	return nil
}

func (m *Backend) validateHTTPAfterResponseRuleList(formats strfmt.Registry) error {

	if swag.IsZero(m.HTTPAfterResponseRuleList) { // not required
		return nil
	}

	if err := m.HTTPAfterResponseRuleList.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("http_after_response_rule_list")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("http_after_response_rule_list")
		}
		return err
	}

	return nil
}

func (m *Backend) validateHTTPCheckList(formats strfmt.Registry) error {

	if swag.IsZero(m.HTTPCheckList) { // not required
		return nil
	}

	if err := m.HTTPCheckList.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("http_check_list")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("http_check_list")
		}
		return err
	}

	return nil
}

func (m *Backend) validateHTTPErrorRuleList(formats strfmt.Registry) error {

	if swag.IsZero(m.HTTPErrorRuleList) { // not required
		return nil
	}

	if err := m.HTTPErrorRuleList.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("http_error_rule_list")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("http_error_rule_list")
		}
		return err
	}

	return nil
}

func (m *Backend) validateHTTPRequestRuleList(formats strfmt.Registry) error {

	if swag.IsZero(m.HTTPRequestRuleList) { // not required
		return nil
	}

	if err := m.HTTPRequestRuleList.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("http_request_rule_list")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("http_request_rule_list")
		}
		return err
	}

	return nil
}

func (m *Backend) validateHTTPResponseRuleList(formats strfmt.Registry) error {

	if swag.IsZero(m.HTTPResponseRuleList) { // not required
		return nil
	}

	if err := m.HTTPResponseRuleList.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("http_response_rule_list")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("http_response_rule_list")
		}
		return err
	}

	return nil
}

func (m *Backend) validateLogTargetList(formats strfmt.Registry) error {

	if swag.IsZero(m.LogTargetList) { // not required
		return nil
	}

	if err := m.LogTargetList.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("log_target_list")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("log_target_list")
		}
		return err
	}

	return nil
}

func (m *Backend) validateServerSwitchingRuleList(formats strfmt.Registry) error {

	if swag.IsZero(m.ServerSwitchingRuleList) { // not required
		return nil
	}

	if err := m.ServerSwitchingRuleList.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("server_switching_rule_list")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("server_switching_rule_list")
		}
		return err
	}

	return nil
}

func (m *Backend) validateStickRuleList(formats strfmt.Registry) error {

	if swag.IsZero(m.StickRuleList) { // not required
		return nil
	}

	if err := m.StickRuleList.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("stick_rule_list")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("stick_rule_list")
		}
		return err
	}

	return nil
}

func (m *Backend) validateTCPCheckRuleList(formats strfmt.Registry) error {

	if swag.IsZero(m.TCPCheckRuleList) { // not required
		return nil
	}

	if err := m.TCPCheckRuleList.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("tcp_check_rule_list")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("tcp_check_rule_list")
		}
		return err
	}

	return nil
}

func (m *Backend) validateTCPRequestRuleList(formats strfmt.Registry) error {

	if swag.IsZero(m.TCPRequestRuleList) { // not required
		return nil
	}

	if err := m.TCPRequestRuleList.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("tcp_request_rule_list")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("tcp_request_rule_list")
		}
		return err
	}

	return nil
}

func (m *Backend) validateTCPResponseRuleList(formats strfmt.Registry) error {

	if swag.IsZero(m.TCPResponseRuleList) { // not required
		return nil
	}

	if err := m.TCPResponseRuleList.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("tcp_response_rule_list")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("tcp_response_rule_list")
		}
		return err
	}

	return nil
}

func (m *Backend) validateServerTemplates(formats strfmt.Registry) error {

	if swag.IsZero(m.ServerTemplates) { // not required
		return nil
	}

	for k := range m.ServerTemplates {

		if err := validate.Required("server_templates"+"."+k, "body", m.ServerTemplates[k]); err != nil {
			return err
		}
		if val, ok := m.ServerTemplates[k]; ok {
			if err := val.Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("server_templates" + "." + k)
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("server_templates" + "." + k)
				}
				return err
			}
		}

	}

	return nil
}

func (m *Backend) validateServers(formats strfmt.Registry) error {

	if swag.IsZero(m.Servers) { // not required
		return nil
	}

	for k := range m.Servers {

		if err := validate.Required("servers"+"."+k, "body", m.Servers[k]); err != nil {
			return err
		}
		if val, ok := m.Servers[k]; ok {
			if err := val.Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("servers" + "." + k)
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("servers" + "." + k)
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this backend based on the context it is used
func (m *Backend) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	// validation for a type composition with BackendBase
	if err := m.BackendBase.ContextValidate(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateACLList(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFilterList(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateHTTPAfterResponseRuleList(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateHTTPCheckList(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateHTTPErrorRuleList(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateHTTPRequestRuleList(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateHTTPResponseRuleList(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLogTargetList(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateServerSwitchingRuleList(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStickRuleList(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTCPCheckRuleList(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTCPRequestRuleList(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTCPResponseRuleList(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateServerTemplates(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateServers(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Backend) contextValidateACLList(ctx context.Context, formats strfmt.Registry) error {

	if err := m.ACLList.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("acl_list")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("acl_list")
		}
		return err
	}

	return nil
}

func (m *Backend) contextValidateFilterList(ctx context.Context, formats strfmt.Registry) error {

	if err := m.FilterList.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("filter_list")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("filter_list")
		}
		return err
	}

	return nil
}

func (m *Backend) contextValidateHTTPAfterResponseRuleList(ctx context.Context, formats strfmt.Registry) error {

	if err := m.HTTPAfterResponseRuleList.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("http_after_response_rule_list")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("http_after_response_rule_list")
		}
		return err
	}

	return nil
}

func (m *Backend) contextValidateHTTPCheckList(ctx context.Context, formats strfmt.Registry) error {

	if err := m.HTTPCheckList.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("http_check_list")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("http_check_list")
		}
		return err
	}

	return nil
}

func (m *Backend) contextValidateHTTPErrorRuleList(ctx context.Context, formats strfmt.Registry) error {

	if err := m.HTTPErrorRuleList.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("http_error_rule_list")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("http_error_rule_list")
		}
		return err
	}

	return nil
}

func (m *Backend) contextValidateHTTPRequestRuleList(ctx context.Context, formats strfmt.Registry) error {

	if err := m.HTTPRequestRuleList.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("http_request_rule_list")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("http_request_rule_list")
		}
		return err
	}

	return nil
}

func (m *Backend) contextValidateHTTPResponseRuleList(ctx context.Context, formats strfmt.Registry) error {

	if err := m.HTTPResponseRuleList.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("http_response_rule_list")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("http_response_rule_list")
		}
		return err
	}

	return nil
}

func (m *Backend) contextValidateLogTargetList(ctx context.Context, formats strfmt.Registry) error {

	if err := m.LogTargetList.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("log_target_list")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("log_target_list")
		}
		return err
	}

	return nil
}

func (m *Backend) contextValidateServerSwitchingRuleList(ctx context.Context, formats strfmt.Registry) error {

	if err := m.ServerSwitchingRuleList.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("server_switching_rule_list")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("server_switching_rule_list")
		}
		return err
	}

	return nil
}

func (m *Backend) contextValidateStickRuleList(ctx context.Context, formats strfmt.Registry) error {

	if err := m.StickRuleList.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("stick_rule_list")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("stick_rule_list")
		}
		return err
	}

	return nil
}

func (m *Backend) contextValidateTCPCheckRuleList(ctx context.Context, formats strfmt.Registry) error {

	if err := m.TCPCheckRuleList.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("tcp_check_rule_list")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("tcp_check_rule_list")
		}
		return err
	}

	return nil
}

func (m *Backend) contextValidateTCPRequestRuleList(ctx context.Context, formats strfmt.Registry) error {

	if err := m.TCPRequestRuleList.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("tcp_request_rule_list")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("tcp_request_rule_list")
		}
		return err
	}

	return nil
}

func (m *Backend) contextValidateTCPResponseRuleList(ctx context.Context, formats strfmt.Registry) error {

	if err := m.TCPResponseRuleList.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("tcp_response_rule_list")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("tcp_response_rule_list")
		}
		return err
	}

	return nil
}

func (m *Backend) contextValidateServerTemplates(ctx context.Context, formats strfmt.Registry) error {

	for k := range m.ServerTemplates {

		if val, ok := m.ServerTemplates[k]; ok {
			if err := val.ContextValidate(ctx, formats); err != nil {
				return err
			}
		}

	}

	return nil
}

func (m *Backend) contextValidateServers(ctx context.Context, formats strfmt.Registry) error {

	for k := range m.Servers {

		if val, ok := m.Servers[k]; ok {
			if err := val.ContextValidate(ctx, formats); err != nil {
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *Backend) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *Backend) UnmarshalBinary(b []byte) error {
	var res Backend
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
