/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.ph.snuggletex.definitions;

import java.util.EnumMap;
import uk.ac.ed.ph.snuggletex.internal.util.BeanToStringOptions;
import uk.ac.ed.ph.snuggletex.internal.util.DumpMode;
import uk.ac.ed.ph.snuggletex.internal.util.ObjectDumperOptions;
import uk.ac.ed.ph.snuggletex.internal.util.ObjectUtilities;
import uk.ac.ed.ph.snuggletex.internal.util.PropertyOptions;
import uk.ac.ed.ph.snuggletex.semantics.Interpretation;
import uk.ac.ed.ph.snuggletex.semantics.InterpretationType;
import uk.ac.ed.ph.snuggletex.semantics.MathCharacterInterpretation;

public final class MathCharacter {
    private final int codePoint;
    private final String inputCommandName;
    private final MathCharacterType type;
    private final MathCharacterInterpretation mathCharacterInterpretation;
    private final EnumMap<InterpretationType, Interpretation> interpretationMap;

    public MathCharacter(int codePoint, String inputCommandName, MathCharacterType type) {
        this.codePoint = codePoint;
        this.inputCommandName = inputCommandName;
        this.type = type;
        this.mathCharacterInterpretation = new MathCharacterInterpretation(this);
        this.interpretationMap = new EnumMap(InterpretationType.class);
        this.interpretationMap.put(InterpretationType.MATH_CHARACTER, this.mathCharacterInterpretation);
    }

    public int getCodePoint() {
        return this.codePoint;
    }

    public String getInputCommandName() {
        return this.inputCommandName;
    }

    public MathCharacterType getType() {
        return this.type;
    }

    public String getChars() {
        return new String(Character.toChars(this.codePoint));
    }

    @ObjectDumperOptions(value=DumpMode.IGNORE)
    @BeanToStringOptions(value=PropertyOptions.IGNORE_PROPERTY)
    public MathCharacterInterpretation getMathCharacterInterpretation() {
        return this.mathCharacterInterpretation;
    }

    @ObjectDumperOptions(value=DumpMode.IGNORE)
    @BeanToStringOptions(value=PropertyOptions.IGNORE_PROPERTY)
    public EnumMap<InterpretationType, Interpretation> getInterpretationMap() {
        return this.interpretationMap;
    }

    public void addInterpretation(Interpretation interpretation) {
        this.interpretationMap.put(interpretation.getType(), interpretation);
    }

    public String toString() {
        return ObjectUtilities.beanToString(this);
    }

    public static enum MathCharacterType {
        ACCENT,
        ALPHA,
        BIN,
        CLOSE,
        FENCE,
        NUMERIC,
        OP,
        OPEN,
        ORD,
        PUNCT,
        REL;

    }
}

