/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ns;

import java.io.IOException;
import java.nio.ByteBuffer;
import oracle.net.ns.NetException;
import oracle.net.ns.Packet;
import oracle.net.ns.SQLnetDef;
import oracle.net.ns.SessionAtts;

public class ControlPacket
extends Packet
implements SQLnetDef {
    private short nsControlCommand;
    static final short NSPCTL_SERR = 8;
    static final short NSPCTL_CLRATTN = 9;
    static final int ORA_ERROR_EMFI_NUMBER = 22;
    static final int NSECMANSHUT = 12572;
    static final int NSESENDMESG = 12573;

    public ControlPacket(SessionAtts sessionAtts) {
        super(sessionAtts);
    }

    public void read(byte[] byArray) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byteBuffer.position(8);
        this.nsControlCommand = byteBuffer.getShort();
        if (this.nsControlCommand == 8) {
            this.processNSError(byteBuffer);
        } else if (this.nsControlCommand == 9) {
            this.disableAttentionProcessing();
        }
    }

    private void processNSError(ByteBuffer byteBuffer) throws IOException {
        int n2 = byteBuffer.getInt();
        int n3 = byteBuffer.getInt();
        int n4 = byteBuffer.getInt();
        if (n3 == 12572 || n3 == 12573) {
            this.sAtts.needsToBeClosed = true;
            return;
        }
        if (n2 == 22) {
            throw new NetException(n3, "ORA-" + n3, true);
        }
        throw new NetException(n3, "TNS-" + n3, true);
    }

    private void disableAttentionProcessing() {
        this.sAtts.negotiatedOptions &= 0xFFFFFDFF;
        this.sAtts.negotiatedOptions &= 0xFFFFFBFF;
    }
}

