/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx;

import java.util.Objects;
import javafx.beans.InvalidationListener;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import org.apache.commons.lang3.StringUtils;

public class PaymentOptionView
extends ImageView {
    private final ObjectProperty<Option> option = new SimpleObjectProperty((Object)this, "option", (Object)Option.MASTERCARD);
    private final ObjectProperty<Theme> theme = new SimpleObjectProperty((Object)this, "style", (Object)Theme.DARK);

    public PaymentOptionView() {
        InvalidationListener updateListener = it -> this.updateView();
        this.optionProperty().addListener(updateListener);
        this.themeProperty().addListener(updateListener);
        this.setFitWidth(100.0);
        this.setPreserveRatio(true);
        this.updateView();
    }

    private void updateView() {
        Object fileName = "";
        switch (this.getOption()) {
            case UNKNOWN: {
                break;
            }
            case CREDIT_CARD: {
                fileName = "CreditCard";
                break;
            }
            case CHECKOUT2: {
                fileName = "2checkout";
                break;
            }
            case ALI_PAY: {
                fileName = "AliPay";
                break;
            }
            case AMAZON: {
                fileName = "Amazon";
                break;
            }
            case AMERICAN_EXPRESS: {
                fileName = "AmericanExpress";
                break;
            }
            case APPLE_PAY: {
                fileName = "ApplePay";
                break;
            }
            case BANCONTACT: {
                fileName = "Bancontact";
                break;
            }
            case BITCOIN: {
                fileName = "Bitcoin";
                break;
            }
            case BITPAY: {
                fileName = "Bitpay";
                break;
            }
            case CIRRUS: {
                fileName = "Cirrus";
                break;
            }
            case CLICKANDBUY: {
                fileName = "Clickandbuy";
                break;
            }
            case COINKITE: {
                fileName = "CoinKite";
                break;
            }
            case DINERSCLUB: {
                fileName = "DinersClub";
                break;
            }
            case DIRECTDEBIT: {
                fileName = "DirectDebit";
                break;
            }
            case DISCOVER: {
                fileName = "Discover";
                break;
            }
            case DWOLLA: {
                fileName = "Dwolla";
                break;
            }
            case EBAY: {
                fileName = "Ebay";
                break;
            }
            case EWAY: {
                fileName = "Eway";
                break;
            }
            case GIROPAY: {
                fileName = "GiroPay";
                break;
            }
            case GOOGLEWALLET: {
                fileName = "GoogleWallet";
                break;
            }
            case INGENICO: {
                fileName = "Ingenico";
                break;
            }
            case JCB: {
                fileName = "JCB";
                break;
            }
            case KLARNA: {
                fileName = "Klarna";
                break;
            }
            case LASER: {
                fileName = "Laser";
                break;
            }
            case MAESTRO: {
                fileName = "Maestro";
                break;
            }
            case MASTERCARD: {
                fileName = "MasterCard";
                break;
            }
            case MONERO: {
                fileName = "Monero";
                break;
            }
            case NETELLER: {
                fileName = "Neteller";
                break;
            }
            case OGONE: {
                fileName = "Ogone";
                break;
            }
            case OKPAY: {
                fileName = "OkPay";
                break;
            }
            case PAYBOX: {
                fileName = "PayBox";
                break;
            }
            case PAYMILL: {
                fileName = "Paymill";
                break;
            }
            case PAYONE: {
                fileName = "Payone";
                break;
            }
            case PAYONEER: {
                fileName = "Payoneer";
                break;
            }
            case PAYPAL: {
                fileName = "Paypal";
                break;
            }
            case PAYSAFECARD: {
                fileName = "PaysafeCard";
                break;
            }
            case PAYU: {
                fileName = "PayU";
                break;
            }
            case PAYZA: {
                fileName = "Payza";
                break;
            }
            case RIPPLE: {
                fileName = "Ripple";
                break;
            }
            case SAGE: {
                fileName = "Sage";
                break;
            }
            case SEPA: {
                fileName = "Sepa";
                break;
            }
            case SHOPIFY: {
                fileName = "Shopify";
                break;
            }
            case SKRILL: {
                fileName = "Skrill";
                break;
            }
            case SOLO: {
                fileName = "Solo";
                break;
            }
            case SQUARE: {
                fileName = "Square";
                break;
            }
            case STRIPE: {
                fileName = "Stripe";
                break;
            }
            case SWITCH: {
                fileName = "Switch";
                break;
            }
            case UKASH: {
                fileName = "Ukash";
                break;
            }
            case UNIONPAY: {
                fileName = "UnionPay";
                break;
            }
            case VERIFONE: {
                fileName = "Verifone";
                break;
            }
            case VERISIGN: {
                fileName = "VeriSign";
                break;
            }
            case VISA: {
                fileName = "Visa";
                break;
            }
            case WEBMONEY: {
                fileName = "WebMoney";
                break;
            }
            case WESTERNUNION: {
                fileName = "WesternUnion";
                break;
            }
            case WORLDPAY: {
                fileName = "WorldPay";
                break;
            }
            default: {
                throw new IllegalArgumentException("option can not be " + this.getOption());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)fileName)) {
            fileName = switch (this.getTheme()) {
                default -> throw new IncompatibleClassChangeError();
                case Theme.DARK -> (String)fileName + "-dark.png";
                case Theme.LIGHT -> (String)fileName + "-light.png";
            };
            this.setImage(new Image(Objects.requireNonNull(PaymentOptionView.class.getResource("paymentoptions/" + (String)fileName)).toExternalForm()));
        } else {
            this.setImage(null);
        }
    }

    public final Option getOption() {
        return (Option)((Object)this.option.get());
    }

    public final ObjectProperty<Option> optionProperty() {
        return this.option;
    }

    public final void setOption(Option option) {
        this.option.set((Object)option);
    }

    public final Theme getTheme() {
        return (Theme)((Object)this.theme.get());
    }

    public final ObjectProperty<Theme> themeProperty() {
        return this.theme;
    }

    public final void setTheme(Theme theme) {
        this.theme.set((Object)theme);
    }

    public static enum Option {
        UNKNOWN,
        CREDIT_CARD,
        CHECKOUT2,
        ALI_PAY,
        AMAZON,
        AMERICAN_EXPRESS,
        APPLE_PAY,
        BANCONTACT,
        BITCOIN,
        BITPAY,
        CIRRUS,
        CLICKANDBUY,
        COINKITE,
        DINERSCLUB,
        DIRECTDEBIT,
        DISCOVER,
        DWOLLA,
        EBAY,
        EWAY,
        GIROPAY,
        GOOGLEWALLET,
        INGENICO,
        JCB,
        KLARNA,
        LASER,
        MAESTRO,
        MASTERCARD,
        MONERO,
        NETELLER,
        OGONE,
        OKPAY,
        PAYBOX,
        PAYMILL,
        PAYONE,
        PAYONEER,
        PAYPAL,
        PAYSAFECARD,
        PAYU,
        PAYZA,
        RIPPLE,
        SAGE,
        SEPA,
        SHOPIFY,
        SKRILL,
        SOLO,
        SQUARE,
        STRIPE,
        SWITCH,
        UKASH,
        UNIONPAY,
        VERIFONE,
        VERISIGN,
        VISA,
        WEBMONEY,
        WESTERNUNION,
        WORLDPAY;

    }

    public static enum Theme {
        DARK,
        LIGHT;

    }
}

