/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx.binding;

import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.WeakListChangeListener;

public class ObservableValuesListBinding<T, U>
extends ObjectBinding<U> {
    private final ObservableList<ObservableValue<T>> source;
    private final Function<Stream<T>, U> transformer;
    private final InvalidationListener elementInvalidationListener = obs -> this.invalidate();
    private final WeakInvalidationListener weakElementInvalidationListener = new WeakInvalidationListener(this.elementInvalidationListener);
    private final ListChangeListener<ObservableValue<T>> listChangeListener = change -> {
        while (change.next()) {
            if (change.wasRemoved()) {
                change.getRemoved().forEach(this::safeRemoveListener);
            }
            if (change.wasAdded()) {
                change.getAddedSubList().forEach(this::safeAddListener);
            }
            this.invalidate();
        }
    };
    private final WeakListChangeListener<ObservableValue<T>> weakListChangeListener = new WeakListChangeListener(this.listChangeListener);

    public ObservableValuesListBinding(ObservableList<ObservableValue<T>> source, Function<Stream<T>, U> transformer) {
        this.source = Objects.requireNonNull(source, "Source list cannot be null");
        this.transformer = Objects.requireNonNull(transformer, "Transformer function cannot be null");
        this.source.forEach(this::safeAddListener);
        this.source.addListener(this.weakListChangeListener);
    }

    private void safeAddListener(ObservableValue<T> item) {
        if (item != null) {
            item.addListener((InvalidationListener)this.weakElementInvalidationListener);
        }
    }

    private void safeRemoveListener(ObservableValue<T> item) {
        if (item != null) {
            item.removeListener((InvalidationListener)this.weakElementInvalidationListener);
        }
    }

    protected U computeValue() {
        return this.transformer.apply(this.source.stream().map(ObservableValue::getValue));
    }

    public void dispose() {
        this.source.forEach(this::safeRemoveListener);
        this.source.removeListener(this.weakListChangeListener);
    }
}

