/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx.incubator.templatepane;

import com.dlsc.gemsfx.incubator.templatepane.TemplatePane;
import com.dlsc.gemsfx.incubator.templatepane.Tile;
import java.util.Objects;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.RadioMenuItem;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import javafx.stage.StageStyle;

public class TemplatePaneControls
extends BorderPane {
    private TemplatePane controlsPane;
    private TemplatePane pane;
    private CheckBox checkbox;
    private Stage stage;

    public TemplatePaneControls(TemplatePane pane) {
        this.pane = Objects.requireNonNull(pane);
        this.checkbox = new CheckBox("Show all tiles");
        this.checkbox.setSelected(false);
        this.checkbox.setOnAction(evt -> this.controlsPane.requestLayout());
        this.controlsPane = new TemplatePane();
        BorderPane.setMargin((Node)this.checkbox, (Insets)new Insets(5.0));
        BorderPane.setMargin((Node)this.controlsPane, (Insets)new Insets(5.0));
        this.setTop((Node)this.checkbox);
        this.setCenter((Node)this.controlsPane);
        this.fillPane();
        this.setPrefSize(200.0, 300.0);
    }

    public String getUserAgentStylesheet() {
        return Objects.requireNonNull(TemplatePaneControls.class.getResource("controls.css")).toExternalForm();
    }

    public final void show() {
        if (this.stage == null) {
            this.stage = new Stage();
            this.stage.setTitle("Controls");
            this.stage.initStyle(StageStyle.UTILITY);
            this.stage.initOwner(this.pane.getScene().getWindow());
            Scene scene = new Scene((Parent)this);
            this.stage.setScene(scene);
            this.stage.sizeToScene();
            this.stage.show();
        }
    }

    private void fillPane() {
        for (TemplatePane.Position pos : TemplatePane.Position.values()) {
            ToggleButton button = new ToggleButton(pos.name());
            button.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
            button.setPrefHeight(20.0);
            button.setPrefWidth(20.0);
            button.setStyle("-fx-font-size: 8px");
            button.setSelected(true);
            this.controlsPane.setNode(pos, (Node)button);
            Tile controlsTile = this.controlsPane.getTile(pos);
            Tile tile = this.pane.getTile(pos);
            controlsTile.visibleProperty().bind((ObservableValue)Bindings.or((ObservableBooleanValue)Bindings.isNotNull(tile.nodeProperty()), (ObservableBooleanValue)this.checkbox.selectedProperty()));
            tile.visibleProperty().bind((ObservableValue)button.selectedProperty());
            ContextMenu menu = new ContextMenu();
            RadioMenuItem appearTransition = new RadioMenuItem("Appear");
            RadioMenuItem slideTransition = new RadioMenuItem("Slide");
            RadioMenuItem shrinkTransition = new RadioMenuItem("Shrink");
            switch (tile.getTransition()) {
                case APPEAR: {
                    appearTransition.setSelected(true);
                    break;
                }
                case SHRINK: {
                    shrinkTransition.setSelected(true);
                    break;
                }
                case SLIDE: {
                    slideTransition.setSelected(true);
                    break;
                }
            }
            ToggleGroup group = new ToggleGroup();
            group.getToggles().addAll((Object[])new Toggle[]{appearTransition, slideTransition, shrinkTransition});
            appearTransition.setOnAction(evt -> tile.setTransition(Tile.TileTransition.APPEAR));
            slideTransition.setOnAction(evt -> tile.setTransition(Tile.TileTransition.SLIDE));
            shrinkTransition.setOnAction(evt -> tile.setTransition(Tile.TileTransition.SHRINK));
            menu.getItems().addAll((Object[])new MenuItem[]{appearTransition, slideTransition, shrinkTransition});
            button.setContextMenu(menu);
        }
    }
}

