/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx.skins;

import com.dlsc.gemsfx.DurationPicker;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import java.util.ResourceBundle;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Pos;
import javafx.scene.control.Label;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;

public class DurationUnitField
extends Label {
    private final ResourceBundle i18n = ResourceBundle.getBundle("duration-picker");
    private final DurationPicker picker;
    private final ChronoUnit chronoUnit;
    private String typedText = "";
    private DurationUnitField nextField;
    private DurationUnitField previousField;
    private boolean updating;
    private final ObjectProperty<Long> value = new SimpleObjectProperty((Object)this, "value");
    private final LongProperty maximumValue = new SimpleLongProperty((Object)this, "maximumValue", Long.MAX_VALUE);
    private final ObjectProperty<Duration> duration = new SimpleObjectProperty((Object)this, "duration");
    private final ObjectProperty<DurationPicker.LabelType> labelType = new SimpleObjectProperty((Object)this, "labelType", (Object)DurationPicker.LabelType.SHORT);
    private final BooleanProperty fillDigits = new SimpleBooleanProperty((Object)this, "fillDigits", true);

    public DurationUnitField(DurationPicker picker, ChronoUnit chronoUnit) {
        this.picker = Objects.requireNonNull(picker);
        this.chronoUnit = chronoUnit;
        this.setMinWidth(Double.NEGATIVE_INFINITY);
        this.updateStyles();
        this.labelTypeProperty().addListener(it -> this.updateStyles());
        this.getStyleClass().addAll((Object[])new String[]{"unit-field", chronoUnit.name().toLowerCase()});
        this.setAlignment(Pos.CENTER);
        this.setOnMouseClicked(evt -> this.requestFocus());
        this.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> {
            Object result;
            Long value = this.getValue();
            if (value == null) {
                result = this.isFillDigits() ? this.fill("", chronoUnit, "-") : "-";
                result = (String)result + " ";
            } else {
                result = this.isFillDigits() ? this.fill(Long.toString(value), chronoUnit, "0") : Long.toString(value);
            }
            if (!this.getLabelType().equals((Object)DurationPicker.LabelType.NONE)) {
                boolean shortLabels = this.getLabelType().equals((Object)DurationPicker.LabelType.SHORT);
                switch (chronoUnit) {
                    case DAYS: {
                        result = (String)result + (String)(shortLabels ? this.i18n.getString("unit.short.days") : " " + this.i18n.getString("unit.long.days"));
                        break;
                    }
                    case HOURS: {
                        result = (String)result + (String)(shortLabels ? this.i18n.getString("unit.short.hours") : " " + this.i18n.getString("unit.long.hours"));
                        break;
                    }
                    case MINUTES: {
                        result = (String)result + (String)(shortLabels ? this.i18n.getString("unit.short.minutes") : " " + this.i18n.getString("unit.long.minutes"));
                        break;
                    }
                    case SECONDS: {
                        result = (String)result + (String)(shortLabels ? this.i18n.getString("unit.short.seconds") : " " + this.i18n.getString("unit.long.seconds"));
                        break;
                    }
                    case MILLIS: {
                        result = (String)result + (String)(shortLabels ? this.i18n.getString("unit.short.millis") : " " + this.i18n.getString("unit.long.millis"));
                    }
                }
            }
            return result;
        }, (Observable[])new Observable[]{this.valueProperty(), this.labelTypeProperty(), this.fillDigitsProperty()}));
        this.focusedProperty().addListener(it -> {
            if (!this.isFocused()) {
                this.constrainValue();
            }
        });
        this.maximumValueProperty().addListener(it -> this.constrainValue());
        this.setFocusTraversable(true);
        this.setAlignment(Pos.CENTER);
        this.valueProperty().addListener(it -> {
            Long value = this.getValue();
            this.typedText = value != null ? Long.toString(value) : "";
        });
        this.focusedProperty().addListener(it -> {
            if (this.isFocused()) {
                this.typedText = "";
            }
        });
        this.addEventHandler(KeyEvent.KEY_PRESSED, evt -> {
            if (evt.getCode().isArrowKey()) {
                this.handleArrowKey((KeyEvent)evt);
            } else {
                boolean handled = false;
                if (evt.getCode().isDigitKey()) {
                    this.handleDigit((KeyEvent)evt);
                    handled = true;
                } else if (evt.getCode().equals((Object)KeyCode.BACK_SPACE) && this.typedText.length() > 0) {
                    this.handleBackspace();
                    handled = true;
                } else if (evt.getCode().equals((Object)KeyCode.SPACE) && this.nextField != null) {
                    this.nextField.requestFocus();
                }
                if (handled) {
                    if (this.typedText.length() == 0) {
                        this.setValue(0L);
                    } else {
                        this.setValue(Math.min(this.getMaximumValue(), Long.parseLong(this.typedText)));
                    }
                    int jumpLength = 2;
                    if (chronoUnit.equals(ChronoUnit.DAYS)) {
                        jumpLength = -1;
                    } else if (chronoUnit.equals(ChronoUnit.MILLIS)) {
                        jumpLength = 4;
                    }
                    if (jumpLength != -1 && this.typedText.length() == jumpLength && this.nextField != null) {
                        this.nextField.requestFocus();
                    }
                }
            }
        });
        this.duration.addListener(it -> {
            this.updating = true;
            try {
                Duration duration = (Duration)this.duration.get();
                if (duration == null) {
                    this.setValue(null);
                    return;
                }
                switch (chronoUnit) {
                    case DAYS: {
                        this.setValue(duration.toDaysPart());
                        return;
                    }
                    case HOURS: {
                        this.setValue(Long.valueOf(duration.toHoursPart()));
                        return;
                    }
                    case MINUTES: {
                        this.setValue(Long.valueOf(duration.toMinutesPart()));
                        return;
                    }
                    case SECONDS: {
                        this.setValue(Long.valueOf(duration.toSecondsPart()));
                        return;
                    }
                    case MILLIS: {
                        this.setValue(Long.valueOf(duration.toMillisPart()));
                        return;
                    }
                }
                return;
            }
            finally {
                this.updating = false;
            }
        });
    }

    public boolean isUpdating() {
        return this.updating;
    }

    private void updateStyles() {
        this.getStyleClass().setAll((Object[])new String[]{"label", "unit-field"});
        switch (this.getLabelType()) {
            case NONE: {
                this.getStyleClass().add((Object)"no-label");
                break;
            }
            case SHORT: {
                this.getStyleClass().add((Object)"short-label");
                break;
            }
            case LONG: {
                this.getStyleClass().add((Object)"long-label");
            }
        }
        this.getStyleClass().add((Object)this.getChronoUnit().name().toLowerCase());
    }

    public final ChronoUnit getChronoUnit() {
        return this.chronoUnit;
    }

    private String fill(String str, ChronoUnit chronoUnit, String fillCharacter) {
        int length = str.length();
        switch (chronoUnit) {
            default: {
                if (length == 0) {
                    return fillCharacter;
                }
                return str;
            }
            case HOURS: 
            case MINUTES: 
            case SECONDS: {
                switch (length) {
                    case 0: {
                        return fillCharacter + fillCharacter;
                    }
                    case 1: {
                        return fillCharacter + str;
                    }
                }
                return str;
            }
            case MILLIS: 
        }
        switch (length) {
            case 0: {
                return fillCharacter + fillCharacter + fillCharacter;
            }
            case 1: {
                return fillCharacter + fillCharacter + str;
            }
            case 2: {
                return fillCharacter + str;
            }
        }
        return str;
    }

    private void handleBackspace() {
        this.typedText = this.typedText.substring(0, this.typedText.length() - 1);
    }

    private void handleDigit(KeyEvent evt) {
        int maxLength = switch (this.chronoUnit) {
            default -> -1;
            case ChronoUnit.HOURS, ChronoUnit.MINUTES, ChronoUnit.SECONDS -> 2;
            case ChronoUnit.MILLIS -> 3;
        };
        if (maxLength != -1 && this.typedText.length() == maxLength) {
            this.typedText = "";
        }
        switch (evt.getText()) {
            case "0": 
            case "1": 
            case "2": 
            case "3": 
            case "4": 
            case "5": 
            case "6": 
            case "7": 
            case "8": 
            case "9": {
                this.typedText = this.typedText + evt.getText();
                break;
            }
        }
    }

    private void handleArrowKey(KeyEvent evt) {
        if (evt.getCode().equals((Object)KeyCode.DOWN)) {
            this.decrement();
            this.picker.getProperties().put((Object)"ADJUST_TIME", (Object)"ADJUST_TIME");
        } else if (evt.getCode().equals((Object)KeyCode.UP)) {
            this.increment();
            this.picker.getProperties().put((Object)"ADJUST_TIME", (Object)"ADJUST_TIME");
        } else if (evt.getCode().equals((Object)KeyCode.RIGHT)) {
            if (this.nextField != null) {
                this.nextField.requestFocus();
            }
        } else if (evt.getCode().equals((Object)KeyCode.LEFT) && this.previousField != null) {
            this.previousField.requestFocus();
        }
        evt.consume();
    }

    void decrement() {
        Long value = this.getValue();
        if (value != null) {
            long newValue = value - 1L;
            if (newValue < 0L) {
                if (this.picker.isRollover() && this.getMaximumValue() != Long.MAX_VALUE) {
                    this.setValue(this.getMaximumValue());
                    if (this.picker.isLinkingFields() && this.previousField != null) {
                        this.previousField.decrement();
                    }
                } else {
                    this.setValue(0L);
                }
            } else {
                this.setValue(newValue);
            }
        } else {
            this.setValue(0L);
        }
    }

    void increment() {
        Long value = this.getValue();
        if (value != null) {
            long newValue = value + 1L;
            if (newValue > this.getMaximumValue()) {
                if (this.picker.isRollover()) {
                    this.setValue(0L);
                    if (this.picker.isLinkingFields() && this.previousField != null) {
                        this.previousField.increment();
                    }
                } else {
                    this.setValue(this.getMaximumValue());
                }
            } else {
                this.setValue(newValue);
            }
        } else {
            this.setValue(0L);
        }
    }

    final void setNextField(DurationUnitField field) {
        this.nextField = field;
    }

    final void setPreviousField(DurationUnitField field) {
        this.previousField = field;
    }

    private void constrainValue() {
        Long value = this.getValue();
        if (value != null) {
            if (value < 0L) {
                this.setValue(0L);
            } else if (value > this.getMaximumValue()) {
                this.setValue(this.getMaximumValue());
            }
        }
    }

    public final ObjectProperty<Long> valueProperty() {
        return this.value;
    }

    public final Long getValue() {
        return (Long)this.valueProperty().get();
    }

    public final void setValue(Long value) {
        this.valueProperty().set((Object)value);
    }

    public final LongProperty maximumValueProperty() {
        return this.maximumValue;
    }

    final Long getMaximumValue() {
        return this.maximumValueProperty().get();
    }

    final void setMaximumValue(Long maximumValue) {
        this.maximumValueProperty().set(maximumValue.longValue());
    }

    public final ObjectProperty<Duration> durationProperty() {
        return this.duration;
    }

    public final DurationPicker.LabelType getLabelType() {
        return (DurationPicker.LabelType)((Object)this.labelType.get());
    }

    public final ObjectProperty<DurationPicker.LabelType> labelTypeProperty() {
        return this.labelType;
    }

    public final boolean isFillDigits() {
        return this.fillDigits.get();
    }

    public final BooleanProperty fillDigitsProperty() {
        return this.fillDigits;
    }
}

