/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx.treeview.link;

import com.dlsc.gemsfx.treeview.TreeNodeView;
import com.dlsc.gemsfx.treeview.link.AbstractLinkStrategy;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.shape.CubicCurveTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;

public class SimpleCatmullRomLink<T>
extends AbstractLinkStrategy<T> {
    @Override
    protected ArrayList<Node> drawLink(TreeNodeView.LayoutDirection direction, double maxDimensionInLine, double startX, double startY, double endX, double endY, double vgap, double hgap) {
        Path path = new Path();
        path.getStyleClass().add((Object)"link-path");
        path.getElements().add((Object)new MoveTo(startX, startY));
        Node arrow = this.createSimpleArrow();
        switch (direction) {
            case TOP_TO_BOTTOM: {
                CubicCurveTo curve = new CubicCurveTo(startX, startY + vgap / 2.0, endX, endY - vgap / 2.0, endX, endY);
                path.getElements().add((Object)curve);
                arrow.setRotate(this.getTangentAngle(curve, 0.95));
                break;
            }
            case BOTTOM_TO_TOP: {
                CubicCurveTo curve = new CubicCurveTo(startX, startY - vgap / 2.0, endX, endY + vgap / 2.0, endX, endY);
                path.getElements().add((Object)curve);
                arrow.setRotate(this.getTangentAngle(curve, 0.05));
                break;
            }
            case LEFT_TO_RIGHT: {
                CubicCurveTo curve = new CubicCurveTo(startX + hgap / 2.0, startY, endX - hgap / 2.0, endY, endX, endY);
                path.getElements().add((Object)curve);
                arrow.setRotate(this.getTangentAngle(curve, 0.95));
                break;
            }
            case RIGHT_TO_LEFT: {
                CubicCurveTo curve = new CubicCurveTo(startX - hgap / 2.0, startY, endX + hgap / 2.0, endY, endX, endY);
                path.getElements().add((Object)curve);
                arrow.setRotate(this.getTangentAngle(curve, 0.05));
            }
        }
        return new ArrayList<Node>(List.of(path, arrow));
    }
}

