/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid;

import java.io.StringWriter;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Node;

@ThreadSafe
public final class MathMLSerializer {
    private static final Log LOGGER = LogFactory.getLog(MathMLSerializer.class);

    private MathMLSerializer() {
    }

    public static String serializeDocument(Node node, boolean bl, boolean bl2) {
        return MathMLSerializer.serializeDocument(node, bl, bl2, false);
    }

    public static String serializeDocument(Node node, boolean bl, boolean bl2, boolean bl3) {
        StringWriter stringWriter = new StringWriter();
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            DOMSource dOMSource = new DOMSource(node);
            StreamResult streamResult = new StreamResult(stringWriter);
            if (bl) {
                transformer.setOutputProperty("doctype-public", "-//W3C//DTD MathML 2.0//EN");
                transformer.setOutputProperty("doctype-system", "http://www.w3.org/TR/MathML2/dtd/mathml2.dtd");
                transformer.setOutputProperty("media-type", "application/mathml+xml");
            }
            MathMLSerializer.boolToProperty(bl2, "indent", transformer);
            MathMLSerializer.boolToProperty(bl3, "omit-xml-declaration", transformer);
            transformer.transform(dOMSource, streamResult);
        }
        catch (TransformerException transformerException) {
            LOGGER.warn((Object)transformerException.getMessage(), (Throwable)transformerException);
        }
        return stringWriter.toString();
    }

    private static void boolToProperty(boolean bl, String string, Transformer transformer) {
        if (bl) {
            transformer.setOutputProperty(string, "yes");
        } else {
            transformer.setOutputProperty(string, "no");
        }
    }
}

