/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.secret;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.freedesktop.dbus.ObjectPath;
import org.freedesktop.dbus.types.UInt64;
import org.freedesktop.dbus.types.Variant;
import org.freedesktop.secret.Secret;
import org.freedesktop.secret.Service;
import org.freedesktop.secret.Static;
import org.freedesktop.secret.handlers.Messaging;

public class Item
extends Messaging
implements org.freedesktop.secret.interfaces.Item {
    private String id;

    public Item(String collectionID, String itemID, Service service) {
        super(service.getConnection(), null, "org.freedesktop.secrets", Static.ObjectPaths.item(collectionID, itemID), "org.freedesktop.Secret.Item");
        this.id = itemID;
    }

    public Item(ObjectPath item, Service service) {
        super(service.getConnection(), null, "org.freedesktop.secrets", item.getPath(), "org.freedesktop.Secret.Item");
        String itemID;
        List<String> list = Arrays.asList(this.objectPath.split("/"));
        this.id = itemID = list.get(list.size() - 1);
    }

    public static Map<String, Variant> createProperties(String label, Map<String, String> attributes) {
        HashMap<String, Variant> properties = new HashMap<String, Variant>();
        properties.put("org.freedesktop.Secret.Item.Label", new Variant((Object)label));
        if (attributes != null) {
            properties.put("org.freedesktop.Secret.Item.Attributes", new Variant(attributes, "a{ss}"));
        }
        return properties;
    }

    @Override
    public ObjectPath delete() {
        Object[] response = this.send("Delete", "", new Object[0]);
        if (response == null) {
            return null;
        }
        ObjectPath prompt = (ObjectPath)response[0];
        return prompt;
    }

    @Override
    public Secret getSecret(ObjectPath session) {
        Object[] response = this.send("GetSecret", "o", session);
        if (response == null) {
            return null;
        }
        try {
            Object[] inner = (Object[])response[0];
            ObjectPath session_path = (ObjectPath)inner[0];
            byte[] parameters = Static.Convert.toByteArray((ArrayList)inner[1]);
            byte[] value = Static.Convert.toByteArray((ArrayList)inner[2]);
            String contentType = (String)inner[3];
            Secret secret = contentType.equals("text/plain") || contentType.equals("text/plain; charset=utf-8") ? new Secret(session_path, parameters, value) : new Secret(session_path, parameters, value, contentType);
            return secret;
        }
        catch (ClassCastException | IndexOutOfBoundsException e) {
            return null;
        }
    }

    @Override
    public void setSecret(Secret secret) {
        this.send("SetSecret", "(oayays)", secret);
    }

    @Override
    public boolean isLocked() {
        Variant response = this.getProperty("Locked");
        if (response == null) {
            return true;
        }
        return (Boolean)response.getValue();
    }

    @Override
    public Map<String, String> getAttributes() {
        Variant response = this.getProperty("Attributes");
        if (response == null) {
            return null;
        }
        return (Map)response.getValue();
    }

    @Override
    public void setAttributes(Map<String, String> attributes) {
        this.setProperty("Attributes", new Variant(attributes, "a{ss}"));
    }

    @Override
    public String getLabel() {
        Variant response = this.getProperty("Label");
        if (response == null) {
            return null;
        }
        return (String)response.getValue();
    }

    @Override
    public void setLabel(String label) {
        this.setProperty("Label", new Variant((Object)label));
    }

    @Override
    public String getType() {
        Variant response = this.getProperty("Type");
        if (response == null) {
            return null;
        }
        return (String)response.getValue();
    }

    @Override
    public UInt64 created() {
        Variant response = this.getProperty("Created");
        if (response == null) {
            return null;
        }
        return (UInt64)response.getValue();
    }

    @Override
    public UInt64 modified() {
        Variant response = this.getProperty("Modified");
        if (response == null) {
            return null;
        }
        return (UInt64)response.getValue();
    }

    public boolean isRemote() {
        return false;
    }

    @Override
    public String getObjectPath() {
        return super.getObjectPath();
    }

    public String getId() {
        return this.id;
    }
}

