/*
 * Decompiled with CFR 0.152.
 */
package org.tinylog.throwable;

import java.util.ArrayList;
import java.util.List;
import org.tinylog.throwable.AbstractThrowableFilter;
import org.tinylog.throwable.ThrowableData;
import org.tinylog.throwable.ThrowableStore;

public abstract class AbstractStackTraceElementsFilter
extends AbstractThrowableFilter {
    public AbstractStackTraceElementsFilter(String arguments) {
        super(arguments);
    }

    @Override
    public ThrowableData filter(ThrowableData origin) {
        List<StackTraceElement> currentTrace = origin.getStackTrace();
        ArrayList<StackTraceElement> newTrace = new ArrayList<StackTraceElement>(currentTrace.size());
        for (StackTraceElement element : currentTrace) {
            if (!this.shouldKept(element.getClassName(), this.getArguments())) continue;
            newTrace.add(element);
        }
        ThrowableData cause = origin.getCause();
        if (cause != null) {
            cause = this.filter(cause);
        }
        return new ThrowableStore(origin.getClassName(), origin.getMessage(), newTrace, cause);
    }

    protected abstract boolean shouldKept(String var1, List<String> var2);

    protected boolean match(String className, String filter) {
        return className.startsWith(filter) && (filter.length() == className.length() || className.charAt(filter.length()) == '.');
    }
}

