/*
 * Decompiled with CFR 0.152.
 */
package com.tobiasdiez.easybind;

import com.tobiasdiez.easybind.FlatMapBindingBase;
import com.tobiasdiez.easybind.PropertyBinding;
import com.tobiasdiez.easybind.Subscription;
import java.util.function.Function;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;

class FlatMapProperty<T, U, O extends Property<U>>
extends FlatMapBindingBase<T, U, O>
implements PropertyBinding<U> {
    private ObservableValue<? extends U> boundTo = null;
    private boolean resetOnUnbind = false;
    private U resetTo = null;

    public FlatMapProperty(ObservableValue<T> source, Function<? super T, O> mapper) {
        super(source, mapper);
    }

    @Override
    protected Subscription observeTargetObservable(O mapped) {
        if (this.boundTo != null) {
            mapped.bind(this.boundTo);
        }
        Subscription s1 = super.observeTargetObservable(mapped);
        Subscription s2 = () -> {
            if (this.boundTo != null) {
                mapped.unbind();
                if (this.resetOnUnbind) {
                    mapped.setValue(this.resetTo);
                }
            }
        };
        return s1.and(s2);
    }

    @Override
    protected void sourceInvalidated() {
        super.sourceInvalidated();
        if (this.boundTo != null) {
            this.getTargetObservable();
        }
    }

    public void setValue(U value) {
        Property target = (Property)this.getTargetObservable();
        if (target != null) {
            target.setValue(value);
        }
    }

    public void bind(ObservableValue<? extends U> other) {
        Property target = (Property)this.getTargetObservable();
        if (target != null) {
            target.bind(other);
        }
        this.boundTo = other;
        this.resetOnUnbind = false;
        this.resetTo = null;
    }

    @Override
    public void bind(ObservableValue<? extends U> other, U resetToOnUnbind) {
        Property target = (Property)this.getTargetObservable();
        if (target != null) {
            target.bind(other);
        }
        this.boundTo = other;
        this.resetOnUnbind = true;
        this.resetTo = resetToOnUnbind;
    }

    public boolean isBound() {
        return this.boundTo != null || this.getTargetObservable() != null && ((Property)this.getTargetObservable()).isBound();
    }

    public void unbind() {
        Property target = (Property)this.getTargetObservable();
        if (target != null) {
            target.unbind();
        }
        this.boundTo = null;
    }

    public void bindBidirectional(Property<U> other) {
        Bindings.bindBidirectional((Property)this, other);
    }

    public void unbindBidirectional(Property<U> other) {
        Bindings.unbindBidirectional((Property)this, other);
    }

    public Object getBean() {
        return null;
    }

    public String getName() {
        return null;
    }
}

