/*
 * Decompiled with CFR 0.152.
 */
package org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.reflectionmodel;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.AccessSpecifier;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.Node;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.Context;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.MethodUsage;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.TypeSolver;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedConstructorDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedFieldDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedMethodDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedTypeParameterDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedValueDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.logic.MethodResolutionLogic;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.model.LambdaArgumentTypePlaceholder;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.model.SymbolReference;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.model.typesystem.ReferenceTypeImpl;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.types.ResolvedReferenceType;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.types.ResolvedType;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.core.resolution.MethodUsageResolutionCapability;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.core.resolution.SymbolResolutionCapability;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.javaparsermodel.contexts.ContextHelper;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.logic.AbstractClassDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.reflectionmodel.ReflectionClassAdapter;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.reflectionmodel.ReflectionFactory;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.reflectionmodel.ReflectionFieldDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.reflectionmodel.ReflectionInterfaceDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.reflectionmodel.ReflectionMethodDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.reflectionmodel.comparators.MethodComparator;

public class ReflectionClassDeclaration
extends AbstractClassDeclaration
implements MethodUsageResolutionCapability,
SymbolResolutionCapability {
    private Class<?> clazz;
    private TypeSolver typeSolver;
    private ReflectionClassAdapter reflectionClassAdapter;

    public ReflectionClassDeclaration(Class<?> clazz, TypeSolver typeSolver) {
        if (clazz == null) {
            throw new IllegalArgumentException("Class should not be null");
        }
        if (clazz.isInterface()) {
            throw new IllegalArgumentException("Class should not be an interface");
        }
        if (clazz.isPrimitive()) {
            throw new IllegalArgumentException("Class should not represent a primitive class");
        }
        if (clazz.isArray()) {
            throw new IllegalArgumentException("Class should not be an array");
        }
        if (clazz.isEnum()) {
            throw new IllegalArgumentException("Class should not be an enum");
        }
        this.clazz = clazz;
        this.typeSolver = typeSolver;
        this.reflectionClassAdapter = new ReflectionClassAdapter(clazz, typeSolver, this);
    }

    @Override
    public Set<ResolvedMethodDeclaration> getDeclaredMethods() {
        return this.reflectionClassAdapter.getDeclaredMethods();
    }

    @Override
    public List<ResolvedReferenceType> getAncestors(boolean acceptIncompleteList) {
        return this.reflectionClassAdapter.getAncestors();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReflectionClassDeclaration that = (ReflectionClassDeclaration)o;
        return this.clazz.getCanonicalName().equals(that.clazz.getCanonicalName());
    }

    public int hashCode() {
        return this.clazz.hashCode();
    }

    @Override
    public String getPackageName() {
        if (this.clazz.getPackage() != null) {
            return this.clazz.getPackage().getName();
        }
        return null;
    }

    @Override
    public String getClassName() {
        String canonicalName = this.clazz.getCanonicalName();
        if (canonicalName != null && this.getPackageName() != null) {
            return canonicalName.substring(this.getPackageName().length() + 1, canonicalName.length());
        }
        return null;
    }

    @Override
    public String getQualifiedName() {
        return this.clazz.getCanonicalName();
    }

    @Override
    @Deprecated
    public SymbolReference<ResolvedMethodDeclaration> solveMethod(String name, List<ResolvedType> argumentsTypes, boolean staticOnly) {
        Predicate<Method> & Serializable staticFilter = (Predicate<Method> & Serializable)m -> !staticOnly || staticOnly && Modifier.isStatic(m.getModifiers());
        ArrayList<ResolvedMethodDeclaration> candidateSolvedMethods = new ArrayList<ResolvedMethodDeclaration>();
        List methods = Arrays.stream(this.clazz.getDeclaredMethods()).filter((Predicate<Method> & Serializable)m -> m.getName().equals(name)).filter(staticFilter).filter((Predicate<Method> & Serializable)method -> !method.isBridge()).filter((Predicate<Method> & Serializable)method -> !method.isSynthetic()).sorted(new MethodComparator()).collect(Collectors.toList());
        for (Method method2 : methods) {
            ReflectionMethodDeclaration methodDeclaration = new ReflectionMethodDeclaration(method2, this.typeSolver);
            candidateSolvedMethods.add(methodDeclaration);
            if (!argumentsTypes.isEmpty() || methodDeclaration.getNumberOfParams() != 0) continue;
            return SymbolReference.solved(methodDeclaration);
        }
        this.getSuperClass().flatMap(ResolvedReferenceType::getTypeDeclaration).ifPresent((Consumer<ResolvedReferenceTypeDeclaration> & Serializable)superClassTypeDeclaration -> {
            SymbolReference<ResolvedMethodDeclaration> ref = MethodResolutionLogic.solveMethodInType(superClassTypeDeclaration, name, argumentsTypes, staticOnly);
            if (ref.isSolved()) {
                candidateSolvedMethods.add(ref.getCorrespondingDeclaration());
            }
        });
        for (ResolvedReferenceType interfaceDeclaration : this.getInterfaces()) {
            interfaceDeclaration.getTypeDeclaration().ifPresent((Consumer<ResolvedReferenceTypeDeclaration> & Serializable)interfaceTypeDeclaration -> {
                SymbolReference<ResolvedMethodDeclaration> ref = MethodResolutionLogic.solveMethodInType(interfaceTypeDeclaration, name, argumentsTypes, staticOnly);
                if (ref.isSolved()) {
                    candidateSolvedMethods.add(ref.getCorrespondingDeclaration());
                }
            });
        }
        if (candidateSolvedMethods.isEmpty()) {
            return SymbolReference.unsolved();
        }
        return MethodResolutionLogic.findMostApplicable(candidateSolvedMethods, name, argumentsTypes, this.typeSolver);
    }

    public String toString() {
        return "ReflectionClassDeclaration{clazz=" + this.getId() + '}';
    }

    public ResolvedType getUsage(Node node) {
        return new ReferenceTypeImpl(this);
    }

    @Override
    public Optional<MethodUsage> solveMethodAsUsage(String name, List<ResolvedType> argumentsTypes, Context invokationContext, List<ResolvedType> typeParameterValues) {
        ArrayList<MethodUsage> methodUsages = new ArrayList<MethodUsage>();
        List allMethods = Arrays.stream(this.clazz.getDeclaredMethods()).filter((Predicate<Method> & Serializable)m -> m.getName().equals(name)).sorted(new MethodComparator()).collect(Collectors.toList());
        for (Method method : allMethods) {
            if (method.isBridge() || method.isSynthetic()) continue;
            ReflectionMethodDeclaration methodDeclaration = new ReflectionMethodDeclaration(method, this.typeSolver);
            MethodUsage methodUsage = new MethodUsage(methodDeclaration);
            for (int i = 0; i < this.getTypeParameters().size() && i < typeParameterValues.size(); ++i) {
                ResolvedTypeParameterDeclaration tpToReplace = this.getTypeParameters().get(i);
                ResolvedType newValue = typeParameterValues.get(i);
                methodUsage = methodUsage.replaceTypeParameter(tpToReplace, newValue);
            }
            methodUsages.add(methodUsage);
            if (!argumentsTypes.isEmpty() || methodUsage.getNoParams() != 0) continue;
            return Optional.of(methodUsage);
        }
        this.getSuperClass().ifPresent((Consumer<ResolvedReferenceType> & Serializable)superClass -> superClass.getTypeDeclaration().ifPresent((Consumer<ResolvedReferenceTypeDeclaration> & Serializable)superClassTypeDeclaration -> ContextHelper.solveMethodAsUsage(superClassTypeDeclaration, name, argumentsTypes, invokationContext, typeParameterValues).ifPresent(methodUsages::add)));
        for (ResolvedReferenceType interfaceDeclaration : this.getInterfaces()) {
            interfaceDeclaration.getTypeDeclaration().flatMap((Function<ResolvedReferenceTypeDeclaration, Optional> & Serializable)superClassTypeDeclaration -> interfaceDeclaration.getTypeDeclaration()).flatMap((Function<ResolvedReferenceTypeDeclaration, Optional> & Serializable)interfaceTypeDeclaration -> ContextHelper.solveMethodAsUsage(interfaceTypeDeclaration, name, argumentsTypes, invokationContext, typeParameterValues)).ifPresent(methodUsages::add);
        }
        Optional<MethodUsage> ref = MethodResolutionLogic.findMostApplicableUsage(methodUsages, name, argumentsTypes, this.typeSolver);
        return ref;
    }

    @Override
    public boolean canBeAssignedTo(ResolvedReferenceTypeDeclaration other) {
        if (other instanceof LambdaArgumentTypePlaceholder) {
            return this.isFunctionalInterface();
        }
        if (other.getQualifiedName().equals(this.getQualifiedName())) {
            return true;
        }
        if (this.clazz.getSuperclass() != null && new ReflectionClassDeclaration(this.clazz.getSuperclass(), this.typeSolver).canBeAssignedTo(other)) {
            return true;
        }
        for (Class<?> interfaze : this.clazz.getInterfaces()) {
            if (!new ReflectionInterfaceDeclaration(interfaze, this.typeSolver).canBeAssignedTo(other)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isAssignableBy(ResolvedType type) {
        return this.reflectionClassAdapter.isAssignableBy(type);
    }

    @Override
    public boolean isTypeParameter() {
        return false;
    }

    @Override
    public ResolvedFieldDeclaration getField(String name) {
        return this.reflectionClassAdapter.getField(name);
    }

    @Override
    public List<ResolvedFieldDeclaration> getAllFields() {
        return this.reflectionClassAdapter.getAllFields();
    }

    @Override
    public SymbolReference<? extends ResolvedValueDeclaration> solveSymbol(String name, TypeSolver typeSolver) {
        for (Field field : this.clazz.getFields()) {
            if (!field.getName().equals(name)) continue;
            return SymbolReference.solved(new ReflectionFieldDeclaration(field, typeSolver));
        }
        return SymbolReference.unsolved();
    }

    @Override
    public boolean hasDirectlyAnnotation(String canonicalName) {
        return this.reflectionClassAdapter.hasDirectlyAnnotation(canonicalName);
    }

    @Override
    public boolean hasField(String name) {
        return this.reflectionClassAdapter.hasField(name);
    }

    @Override
    public boolean isAssignableBy(ResolvedReferenceTypeDeclaration other) {
        return this.isAssignableBy(new ReferenceTypeImpl(other));
    }

    @Override
    public String getName() {
        return this.clazz.getSimpleName();
    }

    @Override
    public boolean isField() {
        return false;
    }

    @Override
    public boolean isParameter() {
        return false;
    }

    @Override
    public boolean isType() {
        return true;
    }

    @Override
    public boolean isClass() {
        return !this.clazz.isInterface();
    }

    @Override
    public Optional<ResolvedReferenceType> getSuperClass() {
        if (!this.reflectionClassAdapter.getSuperClass().isPresent()) {
            return Optional.empty();
        }
        return Optional.of(this.reflectionClassAdapter.getSuperClass().get());
    }

    @Override
    public List<ResolvedReferenceType> getInterfaces() {
        return this.reflectionClassAdapter.getInterfaces();
    }

    @Override
    public boolean isInterface() {
        return this.clazz.isInterface();
    }

    @Override
    public List<ResolvedTypeParameterDeclaration> getTypeParameters() {
        return this.reflectionClassAdapter.getTypeParameters();
    }

    @Override
    public AccessSpecifier accessSpecifier() {
        return ReflectionFactory.modifiersToAccessLevel(this.clazz.getModifiers());
    }

    @Override
    public List<ResolvedConstructorDeclaration> getConstructors() {
        return this.reflectionClassAdapter.getConstructors();
    }

    @Override
    public Optional<ResolvedReferenceTypeDeclaration> containerType() {
        return this.reflectionClassAdapter.containerType();
    }

    @Override
    public Set<ResolvedReferenceTypeDeclaration> internalTypes() {
        return Arrays.stream(this.clazz.getDeclaredClasses()).map((Function<Class, ResolvedReferenceTypeDeclaration> & Serializable)ic -> ReflectionFactory.typeDeclarationFor(ic, this.typeSolver)).collect(Collectors.toSet());
    }

    @Override
    protected ResolvedReferenceType object() {
        return new ReferenceTypeImpl(this.typeSolver.getSolvedJavaLangObject());
    }
}

