/*
 * Decompiled with CFR 0.152.
 */
package org.javamodularity.moduleplugin.tasks;

import groovy.util.Node;
import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.plugins.ide.eclipse.GenerateEclipseClasspath;
import org.gradle.plugins.ide.eclipse.model.EclipseClasspath;

public final class ClasspathFile {
    private static final Logger LOGGER = Logging.getLogger(ClasspathFile.class);
    static final String NAME_ITEM = "classpathentry";
    static final String NAME_CHILD = "attributes";
    static final String NAME_GRAND = "attribute";
    static final String NAME_ATTRIBUTE = "gradle_used_by_scope";
    static final String NAME_JRE = "JRE_CONTAINER";

    public void configure(Task task) {
        EclipseClasspath eclipseClasspath = ((GenerateEclipseClasspath)task).getClasspath();
        eclipseClasspath.file((Action & Serializable)xmlFileContentMerger -> xmlFileContentMerger.withXml((Action & Serializable)xmlProvider -> {
            Node rootNode = xmlProvider.asNode();
            LOGGER.debug("addAction: rootNode.before improving:{}", (Object)rootNode);
            this.improveEclipseClasspathFile(rootNode);
            LOGGER.debug("addAction: rootNode.after  improving:{}", (Object)rootNode);
        }));
    }

    void improveEclipseClasspathFile(Node rootNode) {
        this.putJreOnModulePath(rootNode);
        this.markMain(rootNode);
        this.markTest(rootNode);
    }

    void markMain(Node rootNode) {
        ClasspathFile.children(rootNode).filter((Predicate<Node> & Serializable)i -> NAME_ITEM.equals(i.name())).filter((Predicate<Node> & Serializable)i -> this.isKindOf((Node)i, "lib")).filter((Predicate<Node> & Serializable)i -> this.getGradleScope((Node)i).contains("main")).filter((Predicate<Node> & Serializable)i -> this.hasNoAttributeModule((Node)i)).forEach((Consumer<Node> & Serializable)i -> this.addAttribute((Node)i, "module"));
    }

    void markTest(Node rootNode) {
        ClasspathFile.children(rootNode).filter((Predicate<Node> & Serializable)i -> NAME_ITEM.equals(i.name())).filter((Predicate<Node> & Serializable)i -> "test".equals(this.getGradleScope((Node)i))).filter((Predicate<Node> & Serializable)i -> this.hasNoAttributeTest((Node)i)).forEach((Consumer<Node> & Serializable)i -> this.addAttribute((Node)i, "test"));
    }

    void putJreOnModulePath(Node rootNode) {
        ClasspathFile.children(rootNode).filter((Predicate<Node> & Serializable)i -> NAME_ITEM.equals(i.name())).filter((Predicate<Node> & Serializable)i -> this.isJre((Node)i)).filter((Predicate<Node> & Serializable)i -> this.hasNoAttributeModule((Node)i)).forEach((Consumer<Node> & Serializable)i -> this.addAttribute((Node)i, "module"));
    }

    String getGradleScope(Node item) {
        Optional<Node> oGrand;
        String empty = "";
        Optional<Node> oChild = ClasspathFile.children(item).filter((Predicate<Node> & Serializable)c -> NAME_CHILD.equals(c.name())).findFirst();
        if (oChild.isPresent() && (oGrand = this.getAttributeNamed(oChild.get(), NAME_ATTRIBUTE)).isPresent()) {
            Node grand = oGrand.get();
            Object value = grand.attribute((Object)"value");
            return null == value ? "" : value.toString();
        }
        return "";
    }

    Optional<Node> getAttributeNamed(Node child, String name) {
        return ClasspathFile.children(child).filter((Predicate<Node> & Serializable)g -> NAME_GRAND.equals(g.name())).filter((Predicate<Node> & Serializable)g -> name.equals(g.attribute((Object)"name"))).findFirst();
    }

    boolean hasNoAttributeModule(Node item) {
        return ClasspathFile.children(item).filter((Predicate<Node> & Serializable)c -> NAME_CHILD.equals(c.name())).filter((Predicate<Node> & Serializable)c -> this.hasAttributeNamed((Node)c, "module")).findFirst().isEmpty();
    }

    boolean hasNoAttributeTest(Node item) {
        return ClasspathFile.children(item).filter((Predicate<Node> & Serializable)c -> NAME_CHILD.equals(c.name())).filter((Predicate<Node> & Serializable)c -> this.hasAttributeNamed((Node)c, "test")).findFirst().isEmpty();
    }

    boolean hasAttributeNamed(Node child, String name) {
        return this.getAttributeNamed(child, name).isPresent();
    }

    boolean isJre(Node item) {
        Object path = item.attribute((Object)"path");
        return this.isKindOf(item, "con") && null != path && path.toString().contains(NAME_JRE);
    }

    boolean isKindOf(Node item, String kind) {
        Object attr = item.attribute((Object)"kind");
        return kind.equals(attr);
    }

    void addAttribute(Node item, String attributeName) {
        ConcurrentSkipListMap<String, String> map = new ConcurrentSkipListMap<String, String>();
        map.put("name", attributeName);
        map.put("value", "true");
        ClasspathFile.children(item).filter((Predicate<Node> & Serializable)c -> NAME_CHILD.equals(c.name())).findFirst().ifPresentOrElse((Consumer<Node> & Serializable)c -> c.appendNode((Object)NAME_GRAND, map), new AddAttribute(item, map));
    }

    private static Stream<Node> children(Node item) {
        return item.children().stream().filter((Predicate<Object> & Serializable)c -> c instanceof Node).map(Node.class::cast);
    }

    private static class AddAttribute
    implements Runnable {
        private final transient Node insItem;
        private final transient Map<String, String> insMap;

        private AddAttribute(Node item, Map<String, String> map) {
            this.insItem = item;
            this.insMap = map;
        }

        @Override
        public void run() {
            this.insItem.appendNode((Object)ClasspathFile.NAME_CHILD).appendNode((Object)ClasspathFile.NAME_GRAND, this.insMap);
        }
    }
}

