/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.citeproc.helper;

import java.util.Locale;
import java.util.regex.Pattern;

public class SmartQuotes {
    private static final String NUMBER = "\\p{N}";
    private static final String NO_NUMBER = "[^\\p{N}]";
    private static final String LETTER = "\\p{L}";
    private static final String WORD = "[\\p{L}_\\p{N}]";
    private static final String NO_WORD = "[^\\p{L}_\\p{N}]";
    private static final String LEFT_SINGLE_QUOTE = "\u2018";
    private static final String RIGHT_SINGLE_QUOTE = "\u2019";
    private static final String LEFT_DOUBLE_QUOTE = "\u201c";
    private static final String RIGHT_DOUBLE_QUOTE = "\u201d";
    private static final String PRIME = "\u2032";
    private static final String DOUBLE_PRIME = "\u2033";
    private static final String TRIPLE_PRIME = "\u2034";
    private final Pattern[] patterns;
    private final String[] replacements;

    public SmartQuotes() {
        this(LEFT_SINGLE_QUOTE, RIGHT_SINGLE_QUOTE, LEFT_DOUBLE_QUOTE, RIGHT_DOUBLE_QUOTE, Locale.ENGLISH);
    }

    public SmartQuotes(String leftSingleQuote, String rightSingleQuote, String leftDoubleQuote, String rightDoubleQuote, Locale locale) {
        this(leftSingleQuote, rightSingleQuote, leftDoubleQuote, rightDoubleQuote, RIGHT_SINGLE_QUOTE, PRIME, DOUBLE_PRIME, TRIPLE_PRIME, locale);
    }

    public SmartQuotes(String leftSingleQuote, String rightSingleQuote, String leftDoubleQuote, String rightDoubleQuote, String apostrophe, String prime, String doublePrime, String triplePrime, Locale locale) {
        String[][] replacements = new String[][]{{"'(em|cause|twas|tis|til)([^a-z])", locale != null && locale.getLanguage().equalsIgnoreCase("en") ? apostrophe + "$1$2" : "$0"}, {"'''", triplePrime}, {"([^\\p{L}_\\p{N}]|^)\"(" + leftSingleQuote + "|'|[\\p{L}_\\p{N}])", "$1" + leftDoubleQuote + "$2"}, {"(" + leftDoubleQuote + "[^\"]*)\"([^\"]*$|[^" + leftDoubleQuote + "\"]*" + leftDoubleQuote + ")", "$1" + rightDoubleQuote + "$2"}, {"([^\\p{N}])\"", "$1" + rightDoubleQuote}, {"''", doublePrime}, {"([^\\p{L}_\\p{N}]|^)'(\\S)", "$1" + leftSingleQuote + "$2"}, {"(\\p{L}|\\p{N})'(\\p{L})", "$1" + apostrophe + "$2"}, {"(" + leftSingleQuote + ")([0-9]{2}[^" + rightSingleQuote + apostrophe + "]*)(" + leftSingleQuote + "([^\\p{N}]|$)|$|" + rightSingleQuote + apostrophe + "\\p{L})", apostrophe + "$2$3"}, {"((" + leftSingleQuote + "[^']*)|\\p{L})'([^\\p{N}]|$)", "$1" + rightSingleQuote + "$3"}, {"(\\B|^)" + leftSingleQuote + "(?=([^" + leftSingleQuote + rightSingleQuote + apostrophe + "]*[" + rightSingleQuote + apostrophe + "]\\b)*([^" + leftSingleQuote + rightSingleQuote + apostrophe + "]*\\B[^\\p{L}_\\p{N}][" + leftSingleQuote + rightSingleQuote + apostrophe + "]\\b|[^" + leftSingleQuote + rightSingleQuote + apostrophe + "]*$))", "$1" + rightSingleQuote}, {"(.)\"", "$1" + doublePrime}, {"^\"", leftDoubleQuote}, {"'", prime}};
        this.patterns = new Pattern[replacements.length];
        this.replacements = new String[replacements.length];
        for (int i = 0; i < replacements.length; ++i) {
            this.patterns[i] = Pattern.compile(replacements[i][0]);
            this.replacements[i] = replacements[i][1];
        }
    }

    public String apply(String str) {
        for (int i = 0; i < this.patterns.length; ++i) {
            str = this.patterns[i].matcher(str).replaceAll(this.replacements[i]);
        }
        return str;
    }
}

