/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.util.HashMap;

public class VCFParse
extends BaseParse {
    protected HashMap<String, String> tagmap = new HashMap(16);
    private static final int BUFF_SIZE = 1024;
    private static final byte[] buffer = new byte[1024];
    private int buffer_pos;
    private int buffer_size;
    private long page_start;
    private long block_addr;
    private long line_no = 0L;
    private LargeFileReader filein;
    String[] col_names = new String[]{"Chromosome", "Position", "ID", "Reference Base(s)", "Alternate non-reference alleles", "Quality", "Filter", "Info"};

    public VCFParse(String string) {
        super(string);
        this.initTags();
        this.buffer_pos = 0;
        this.page_start = 0L;
        this.block_addr = 0L;
        try {
            this.filein = new LargeFileReader(string);
            this.parseHeader();
            this.parseColumnLabels();
            this.page_start = this.filein.getFilePointer();
            this.block_addr = this.filein.getFilePointer();
        }
        catch (IOException iOException) {
            System.out.println("Couldn't open file as VCF");
        }
    }

    private void parseColumnLabels() {
        try {
            long l = this.filein.getFilePointer();
            String string = this.filein.readLine();
            if (string != null && string.length() > 1 && string.substring(0, 1).equals("#")) {
                this.col_names = string.substring(1).split("\\t");
            } else {
                this.filein.seek(l);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void parseHeader() {
        String string = null;
        this.header = "";
        long l = 0L;
        try {
            String string2;
            l = this.filein.getFilePointer();
            while ((string = this.filein.readLine()) != null && (string2 = string.substring(0, 2)).equals("##")) {
                this.header = this.header + string;
                this.header = this.header + "\n";
                l = this.filein.getFilePointer();
            }
            if (l >= 0L) {
                this.filein.seek(l);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void seek(long l) throws IOException {
        this.filein.seek(l);
        this.block_addr = this.filein.getFilePointer();
    }

    public long getNextRecordIndex2() {
        try {
            long l = this.filein.getFilePointer();
            String string = this.filein.readLine();
            if (string == null) {
                return -1L;
            }
            return l;
        }
        catch (IOException iOException) {
            return -1L;
        }
    }

    @Override
    public long getNextRecordIndex() {
        try {
            if (this.line_no % 1000L == 0L) {
                this.filein.seek(this.block_addr);
                byte[] byArray = new byte[this.buffer_pos];
                this.filein.read(byArray);
                this.page_start = this.filein.getFilePointer();
                this.buffer_size = 0;
            }
            while (true) {
                if (this.buffer_size == 0 || this.buffer_pos >= this.buffer_size) {
                    this.block_addr = this.filein.getFilePointer();
                    this.buffer_size = this.filein.read(buffer);
                    this.buffer_pos = 0;
                }
                if (this.buffer_size < 1) {
                    return -1L;
                }
                if (buffer[this.buffer_pos] == 10) {
                    ++this.buffer_pos;
                    ++this.line_no;
                    return this.page_start;
                }
                ++this.buffer_pos;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return -1L;
        }
    }

    @Override
    public String[] getNextRecord() {
        try {
            String string = this.filein.readLine();
            if (string == null) {
                return null;
            }
            return string.split("\\t");
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public double getProgress() {
        try {
            return 1.0 * (double)this.filein.getRealOffset() / (1.0 * (double)this.filein.length());
        }
        catch (IOException iOException) {
            return 1.0;
        }
    }

    @Override
    public String getToolTip(String string, int n, int n2, String[] stringArray) {
        if (n2 == 7) {
            return this.prettyPrintInfo(string);
        }
        if (n2 > 8) {
            String string2 = stringArray[3];
            String string3 = stringArray[4];
            String string4 = stringArray[8];
            return this.prettyPrintSample(string, string4, string2, string3);
        }
        return string;
    }

    private String prettyPrintInfo(String string) {
        String string2 = "<html>";
        String[] stringArray = string.split(";");
        if (stringArray.length < 1) {
            return string;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = stringArray[i].split("=");
            string2 = this.tagmap.get(stringArray2[0]) == null ? string2 + stringArray2[0] : string2 + this.tagmap.get(stringArray2[0]);
            if (stringArray2.length > 1) {
                string2 = string2 + " = " + stringArray2[1];
            }
            string2 = string2 + "<br>";
        }
        string2 = string2 + "</html>";
        return string2;
    }

    private int getInt(String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    private String prettyPrintSample(String string, String string2, String string3, String string4) {
        String[] stringArray = string2.split(":");
        String[] stringArray2 = string.split(":");
        String[] stringArray3 = string4.split(",");
        if (stringArray2.length < 1) {
            return string;
        }
        if (stringArray.length < stringArray2.length) {
            return string;
        }
        String string5 = "";
        for (int i = 0; i < stringArray2.length; ++i) {
            String[] stringArray4;
            if (stringArray[i].equals("GT")) {
                int n;
                string5 = string5 + "Genotype";
                stringArray4 = stringArray2[i].split("/");
                if (stringArray4.length != 2) {
                    stringArray4 = stringArray2[i].split("\\|");
                    if (stringArray4.length == 2) {
                        string5 = string5 + " (Phased) ";
                    }
                } else {
                    string5 = string5 + " (Unphased) ";
                }
                if (stringArray4.length != 2) {
                    n = this.getInt(stringArray2[i]);
                    string5 = n == 0 ? string5 + " " + string3 : (n < 1 || n > stringArray3.length ? string5 + " " + stringArray2[i] : string5 + " " + stringArray3[n - 1]);
                } else {
                    n = this.getInt(stringArray4[0]);
                    int n2 = this.getInt(stringArray4[1]);
                    string5 = n == 0 ? string5 + string3 + "," : (n < 1 || n > stringArray3.length ? string5 + "unknown," : string5 + stringArray3[n - 1] + ",");
                    string5 = n2 == 0 ? string5 + string3 : (n2 < 1 || n2 > stringArray3.length ? string5 + "unknown" : string5 + stringArray3[n2 - 1]);
                }
            } else if (stringArray[i].equals("DP")) {
                string5 = string5 + "Sample Depth " + stringArray2[i];
            } else if (stringArray[i].equals("FT")) {
                string5 = string5 + "Genotype Filter " + stringArray2[i];
            } else if (stringArray[i].equals("GL")) {
                string5 = string5 + "Log10-scaled Likelihoods ";
                stringArray4 = stringArray2[i].split(",");
                if (stringArray4.length != 3) {
                    string5 = string5 + stringArray2[i];
                } else {
                    string5 = string5 + "AA:" + stringArray4[0] + ",";
                    string5 = string5 + "AB:" + stringArray4[1] + ",";
                    string5 = string5 + "BB:" + stringArray4[2];
                }
            } else if (stringArray[i].equals("GQ")) {
                string5 = string5 + "Phred Genotype Quality " + stringArray2[i];
            } else if (stringArray[i].equals("HQ")) {
                string5 = string5 + "Phred Haplotype Qualities " + stringArray2[i];
            }
            string5 = string5 + "BREAKEDLINED";
        }
        string5 = string5.replaceAll(">", "&gt;");
        string5 = string5.replaceAll("<", "&lt;");
        string5 = string5.replaceAll("BREAKEDLINED", "<br>");
        return "<html>" + string5 + "</html>";
    }

    @Override
    public String getColumnName(int n) {
        if (n >= this.col_names.length) {
            return "Sample";
        }
        if (n < 0) {
            return "Unknown";
        }
        return this.col_names[n];
    }

    @Override
    public int getNumColumnLabels() {
        if (this.col_names == null) {
            return 0;
        }
        return this.col_names.length;
    }

    private void initTags() {
        this.tagmap.put("AA", "Ancestral allele");
        this.tagmap.put("AC", "Allele count");
        this.tagmap.put("AF", "Allele frequency");
        this.tagmap.put("AN", "Total number of alleles");
        this.tagmap.put("BQ", "RMS base quality");
        this.tagmap.put("CIGAR", "Alignment description");
        this.tagmap.put("DB", "dbSNP membership");
        this.tagmap.put("DP", "Combined depth across samples");
        this.tagmap.put("END", "End position of variant");
        this.tagmap.put("H2", "hapmap2 membership");
        this.tagmap.put("MQ", "RMS mapping quality");
        this.tagmap.put("MQ0", "Number of reads with MAPQ of 0");
        this.tagmap.put("NS", "Number of samples");
        this.tagmap.put("SB", "Strand bias");
        this.tagmap.put("SOMATIC", "Somatic mutation");
        this.tagmap.put("VALIDATED", "Follow-up validation");
    }
}

