/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jinja;

import com.intellij.jinja.template.psi.DjangoTagName;
import com.intellij.jinja.template.psi.impl.DjangoTagElementImpl;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Jinja2TemplateUtil {
    public static final String IDENTIFIER_RE = "\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*";
    private static final Pattern IDENTIFIER_PATTERN = Pattern.compile("\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*");

    public static boolean isIdentifierString(@NotNull @NonNls String name) {
        if (name == null) {
            Jinja2TemplateUtil.$$$reportNull$$$0(0);
        }
        return IDENTIFIER_PATTERN.matcher(name).matches();
    }

    @Nullable
    public static DjangoTagName getTagNameElement(@NotNull DjangoTagElementImpl tag) {
        PsiElement[] endNames;
        if (tag == null) {
            Jinja2TemplateUtil.$$$reportNull$$$0(1);
        }
        if ((endNames = PsiTreeUtil.collectElements((PsiElement)tag, element -> element instanceof DjangoTagName)).length == 1) {
            return (DjangoTagName)endNames[0];
        }
        return null;
    }

    @Nullable
    public static String getTagName(@NotNull DjangoTagElementImpl tag) {
        DjangoTagName tagName;
        if (tag == null) {
            Jinja2TemplateUtil.$$$reportNull$$$0(2);
        }
        if ((tagName = Jinja2TemplateUtil.getTagNameElement(tag)) != null) {
            return tagName.getTagName();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
        }
        objectArray2[1] = "com/intellij/jinja/Jinja2TemplateUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isIdentifierString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getTagNameElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getTagName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

