/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.pro.cython;

import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.editor.FoldingGroup;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.python.pro.cython.psi.elementTypes.CythonElementTypes;
import com.jetbrains.python.PyElementTypes;
import com.jetbrains.python.PythonFoldingBuilder;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0014J\u0012\u0010\b\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0014J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0018\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0007H\u0014J\"\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0014\u00a8\u0006\u0017"}, d2={"Lcom/intellij/python/pro/cython/CythonFoldingBuilder;", "Lcom/jetbrains/python/PythonFoldingBuilder;", "<init>", "()V", "isFunction", "", "elementType", "Lcom/intellij/psi/tree/IElementType;", "isClass", "isImport", "node", "Lcom/intellij/lang/ASTNode;", "isLanguageSpecificFoldableBlock", "checkFoldBlocks", "statementList", "parentType", "foldingDescriptor", "Lcom/intellij/lang/folding/FoldingDescriptor;", "range", "Lcom/intellij/openapi/util/TextRange;", "group", "Lcom/intellij/openapi/editor/FoldingGroup;", "Companion", "intellij.python"})
public final class CythonFoldingBuilder
extends PythonFoldingBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final TokenSet CYTHON_FOLDABLE_BLOCKS;
    @NotNull
    private static final TokenSet IMPORT_STATEMENTS;

    protected boolean isFunction(@Nullable IElementType elementType) {
        return elementType == CythonElementTypes.FUNCTION_DECLARATION;
    }

    protected boolean isClass(@Nullable IElementType elementType) {
        return elementType == CythonElementTypes.CLASS_DECLARATION || elementType == PyElementTypes.CLASS_DECLARATION;
    }

    protected boolean isImport(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return IMPORT_STATEMENTS.contains(node.getElementType());
    }

    protected boolean isLanguageSpecificFoldableBlock(@NotNull IElementType elementType) {
        Intrinsics.checkNotNullParameter((Object)elementType, (String)"elementType");
        return CYTHON_FOLDABLE_BLOCKS.contains(elementType);
    }

    protected boolean checkFoldBlocks(@NotNull ASTNode statementList, @NotNull IElementType parentType) {
        Intrinsics.checkNotNullParameter((Object)statementList, (String)"statementList");
        Intrinsics.checkNotNullParameter((Object)parentType, (String)"parentType");
        return CYTHON_FOLDABLE_BLOCKS.contains(parentType) || super.checkFoldBlocks(statementList, parentType);
    }

    @NotNull
    protected FoldingDescriptor foldingDescriptor(@NotNull ASTNode node, @NotNull TextRange range, @Nullable FoldingGroup group) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        return new FoldingDescriptor(node, range, group, this.getLanguagePlaceholderText(node, range));
    }

    static {
        SpreadBuilder spreadBuilder = new SpreadBuilder[]{CythonElementTypes.STRUCT_OR_UNION_DECLARATION, CythonElementTypes.ENUM_DECLARATION, CythonElementTypes.CDEF_BLOCK, CythonElementTypes.PROPERTY_DECLARATION, CythonElementTypes.FUSED_TYPE_DECLARATION};
        TokenSet tokenSet = TokenSet.create((IElementType[])spreadBuilder);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"create(...)");
        CYTHON_FOLDABLE_BLOCKS = tokenSet;
        spreadBuilder = new SpreadBuilder(3);
        spreadBuilder.addSpread((Object)PyElementTypes.IMPORT_STATEMENTS.getTypes());
        spreadBuilder.add((Object)CythonElementTypes.CIMPORT_STATEMENT);
        spreadBuilder.add((Object)CythonElementTypes.FROM_CIMPORT_STATEMENT);
        TokenSet tokenSet2 = TokenSet.create((IElementType[])((IElementType[])spreadBuilder.toArray((Object[])new IElementType[spreadBuilder.size()])));
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet2, (String)"create(...)");
        IMPORT_STATEMENTS = tokenSet2;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0013\u0010\b\u001a\u00070\u0005\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/python/pro/cython/CythonFoldingBuilder$Companion;", "", "<init>", "()V", "CYTHON_FOLDABLE_BLOCKS", "Lcom/intellij/psi/tree/TokenSet;", "getCYTHON_FOLDABLE_BLOCKS", "()Lcom/intellij/psi/tree/TokenSet;", "IMPORT_STATEMENTS", "Lorg/jetbrains/annotations/NotNull;", "intellij.python"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TokenSet getCYTHON_FOLDABLE_BLOCKS() {
            return CYTHON_FOLDABLE_BLOCKS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

