/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.pro.cython.parser;

import com.intellij.lang.SyntaxTreeBuilder;
import com.intellij.psi.tree.IElementType;
import com.intellij.python.pro.cython.parser.CythonDeclParsing;
import com.intellij.python.pro.cython.parser.CythonParsingContext;
import com.intellij.python.pro.cython.parser.CythonTokenTypes;
import com.intellij.python.pro.cython.psi.elementTypes.CythonElementTypes;
import com.jetbrains.python.PyParsingBundle;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.parsing.ExpressionParsing;
import com.jetbrains.python.parsing.ParsingContext;
import org.jetbrains.annotations.NonNls;

public class CythonExpressionParsing
extends ExpressionParsing {
    @NonNls
    protected static final String TOK_SIZEOF = "sizeof";
    @NonNls
    protected static final String TOK_NEW = "new";
    @NonNls
    protected static final String TOK_IN = "in";
    @NonNls
    protected static final String TOK_FROM = "from";

    public CythonExpressionParsing(CythonParsingContext context) {
        super((ParsingContext)context);
    }

    public CythonParsingContext getParsingContext() {
        return (CythonParsingContext)this.myContext;
    }

    protected IElementType getReferenceType() {
        return CythonElementTypes.REFERENCE_EXPRESSION;
    }

    protected boolean parseUnaryExpression(boolean isTargetExpression) {
        if (this.atToken((IElementType)PyTokenTypes.AND)) {
            this.parseAmpersandExpression(isTargetExpression);
            return true;
        }
        if (this.atToken((IElementType)PyTokenTypes.LT)) {
            this.parseTypeCast(isTargetExpression);
            return true;
        }
        if (this.atToken((IElementType)PyTokenTypes.IDENTIFIER, TOK_SIZEOF)) {
            this.parseSizeOfExpression();
            return true;
        }
        if (this.atToken((IElementType)PyTokenTypes.IDENTIFIER, TOK_NEW) && this.parseNewExpression()) {
            return true;
        }
        return super.parseUnaryExpression(isTargetExpression);
    }

    protected void parseComprehensionRange(boolean generatorExpression) {
        if (this.atToken((IElementType)PyTokenTypes.IN_KEYWORD)) {
            this.nextToken();
            boolean result = generatorExpression ? this.parseORTestExpression(false, false) : this.parseTupleExpression(false, false, true, false);
            if (!result) {
                this.myBuilder.error(PyParsingBundle.message((String)"PARSE.expected.expression", (Object[])new Object[0]));
            }
        } else if (this.atToken((IElementType)PyTokenTypes.FROM_KEYWORD)) {
            this.nextToken();
            this.parseExpression();
            if (this.atToken((IElementType)CythonTokenTypes.BY_KEYWORD)) {
                this.nextToken();
                this.parseExpression();
            }
        } else {
            this.myBuilder.error(PyParsingBundle.message((String)"PARSE.expected.symbols", (Object[])new Object[]{TOK_IN, TOK_FROM}));
        }
    }

    private void parseSizeOfExpression() {
        CythonDeclParsing parser2 = this.getParsingContext().getDeclParser();
        SyntaxTreeBuilder.Marker marker = this.myBuilder.mark();
        this.nextToken();
        this.checkMatches((IElementType)PyTokenTypes.LPAR, PyParsingBundle.message((String)"PARSE.expected.lpar", (Object[])new Object[0]));
        parser2.parseBaseTypeDecl(false);
        parser2.parseNameDecl(true, false, false);
        this.checkMatches((IElementType)PyTokenTypes.RPAR, PyParsingBundle.message((String)"PARSE.expected.rpar", (Object[])new Object[0]));
        marker.done((IElementType)CythonElementTypes.SIZEOF_EXPRESSION);
    }

    private boolean parseNewExpression() {
        SyntaxTreeBuilder.Marker marker = this.myBuilder.mark();
        this.nextToken();
        if (this.parseExpressionOptional()) {
            marker.done((IElementType)CythonElementTypes.NEW_EXPRESSION);
            return true;
        }
        marker.rollbackTo();
        return false;
    }

    private void parseTypeCast(boolean isTargetExpression) {
        this.assertCurrentToken(PyTokenTypes.LT);
        SyntaxTreeBuilder builder = this.myContext.getBuilder();
        SyntaxTreeBuilder.Marker marker = builder.mark();
        this.nextToken();
        CythonDeclParsing declParser = this.getParsingContext().getDeclParser();
        declParser.parseBaseTypeDecl(false);
        declParser.parseNameDecl(true, false, false);
        if (this.atToken((IElementType)CythonTokenTypes.QUESTION)) {
            this.nextToken();
        }
        this.checkMatches((IElementType)PyTokenTypes.GT, PyParsingBundle.message((String)"PARSE.gt.expected", (Object[])new Object[0]));
        this.parseUnaryExpression(isTargetExpression);
        marker.done((IElementType)CythonElementTypes.TYPECAST_EXPRESSION);
    }

    private void parseAmpersandExpression(boolean isTargetExpression) {
        this.assertCurrentToken(PyTokenTypes.AND);
        SyntaxTreeBuilder builder = this.myContext.getBuilder();
        SyntaxTreeBuilder.Marker marker = builder.mark();
        this.nextToken();
        this.parseUnaryExpression(isTargetExpression);
        marker.done((IElementType)CythonElementTypes.ADDRESS_EXPRESSION);
    }
}

