/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.scientific.py.tables.providers;

import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.scientific.py.tables.providers.PyPandasBaseProvider;
import com.intellij.scientific.tables.DSTableRawData;
import com.intellij.scientific.tables.DataId;
import com.intellij.scientific.tables.api.DSDataFrameInfo;
import com.intellij.scientific.tables.api.DSTableDataType;
import com.intellij.scientific.tables.api.FilterExpression;
import java.util.List;
import javax.swing.RowSorter;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000fH\u0016J4\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u000f2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00182\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\"\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u000f2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020\u001cH\u0016J \u0010!\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\"\u001a\u00020#2\u0006\u0010 \u001a\u00020\u001cH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006$"}, d2={"Lcom/intellij/scientific/py/tables/providers/PyPandasSeriesProvider;", "Lcom/intellij/scientific/py/tables/providers/PyPandasBaseProvider;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getType", "Lcom/intellij/scientific/tables/api/DSTableDataType;", "isFallbackToStaticTableSupported", "", "parseStaticTableToFrameInfo", "Lcom/intellij/scientific/tables/api/DSDataFrameInfo;", "text", "", "parseStaticTableToTableData", "Lcom/intellij/scientific/tables/DSTableRawData;", "dataId", "Lcom/intellij/scientific/tables/DataId;", "table", "getSortingCommand", "tableVariable", "sortKeys", "", "Ljavax/swing/RowSorter$SortKey;", "columns", "indexColumnWidth", "", "getFilteringCommand", "filters", "Lcom/intellij/scientific/tables/api/FilterExpression;", "tableColumnsNumber", "getColumnVariableExpressionForFilterCommand", "filterExpression", "Lcom/intellij/scientific/tables/api/FilterExpression$SingleExpression;", "intellij.scientific.py.tables"})
public final class PyPandasSeriesProvider
extends PyPandasBaseProvider {
    @NotNull
    private final Project project;

    public PyPandasSeriesProvider(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public DSTableDataType getType() {
        return DSTableDataType.PANDAS_SERIES;
    }

    public boolean isFallbackToStaticTableSupported() {
        return false;
    }

    @NotNull
    public DSDataFrameInfo parseStaticTableToFrameInfo(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        throw new NotImplementedError("Showing Series as tables isn't supported for non-executed cells");
    }

    @NotNull
    public DSTableRawData parseStaticTableToTableData(@NotNull DataId dataId, @NotNull String table) {
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        throw new NotImplementedError("Showing Series as tables isn't supported for non-executed cells");
    }

    @NotNull
    public String getSortingCommand(@NotNull String tableVariable, @NotNull List<? extends RowSorter.SortKey> sortKeys, @NotNull List<String> columns, int indexColumnWidth) {
        Intrinsics.checkNotNullParameter((Object)tableVariable, (String)"tableVariable");
        Intrinsics.checkNotNullParameter(sortKeys, (String)"sortKeys");
        Intrinsics.checkNotNullParameter(columns, (String)"columns");
        if (sortKeys.isEmpty()) {
            return tableVariable;
        }
        return this.getSortCommand(tableVariable, sortKeys, null, indexColumnWidth);
    }

    @NotNull
    public String getFilteringCommand(@NotNull String tableVariable, @Nullable FilterExpression filters, int tableColumnsNumber) {
        Intrinsics.checkNotNullParameter((Object)tableVariable, (String)"tableVariable");
        if (filters == null) {
            return tableVariable;
        }
        return tableVariable + "[" + this.composeFilterCommand(tableVariable, filters, tableColumnsNumber) + "]";
    }

    @Override
    @NotNull
    public String getColumnVariableExpressionForFilterCommand(@NotNull String tableVariable, @NotNull FilterExpression.SingleExpression filterExpression, int tableColumnsNumber) {
        Intrinsics.checkNotNullParameter((Object)tableVariable, (String)"tableVariable");
        Intrinsics.checkNotNullParameter((Object)filterExpression, (String)"filterExpression");
        return tableVariable;
    }
}

