/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.postcss.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.css.CssSelector;
import com.intellij.psi.css.CssSelectorList;
import java.util.Arrays;
import org.intellij.plugins.postcss.PostCssBundle;
import org.intellij.plugins.postcss.actions.PostCssAddAmpersandToSelectorQuickFix;
import org.intellij.plugins.postcss.actions.PostCssAddAtRuleNestToSelectorQuickFix;
import org.intellij.plugins.postcss.actions.PostCssDeleteAmpersandQuickFix;
import org.intellij.plugins.postcss.actions.PostCssDeleteAtRuleNestQuickFix;
import org.intellij.plugins.postcss.inspections.PostCssBaseInspection;
import org.intellij.plugins.postcss.psi.PostCssPsiUtil;
import org.intellij.plugins.postcss.psi.impl.PostCssElementVisitor;
import org.intellij.plugins.postcss.psi.impl.PostCssNestImpl;
import org.jetbrains.annotations.NotNull;

public class PostCssNestingInspection
extends PostCssBaseInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PostCssNestingInspection.$$$reportNull$$$0(0);
        }
        return new PostCssElementVisitor(){

            public void visitCssSelector(CssSelector selector) {
                if (PostCssPsiUtil.isEmptyElement((PsiElement)selector) || !PostCssPsiUtil.isInsidePostCss((PsiElement)selector) || PostCssPsiUtil.isInsideCustomSelector((PsiElement)selector)) {
                    return;
                }
                if (PostCssPsiUtil.isInsideNestedRuleset((PsiElement)selector)) {
                    PostCssNestingInspection.annotateNestedSelectorsWithoutAmpersand(selector, holder);
                }
            }

            public void visitCssSelectorList(CssSelectorList selectorList) {
                if (PostCssPsiUtil.isEmptyElement((PsiElement)selectorList) || !PostCssPsiUtil.isInsidePostCss((PsiElement)selectorList) || PostCssPsiUtil.isInsideCustomSelector((PsiElement)selectorList)) {
                    return;
                }
                if (PostCssPsiUtil.isInsideNestedRuleset((PsiElement)selectorList)) {
                    PostCssNestingInspection.annotateNestedSelectorsWithoutNest(selectorList, holder);
                } else {
                    PostCssNestingInspection.annotateTopLevelSelectorsWithNestingSigns(selectorList, holder);
                }
            }

            @Override
            public void visitPostCssNest(PostCssNestImpl postCssNest) {
                if (PostCssPsiUtil.isEmptyElement((PsiElement)postCssNest) || !PostCssPsiUtil.isInsidePostCss((PsiElement)postCssNest) || PostCssPsiUtil.isInsideCustomSelector((PsiElement)postCssNest)) {
                    return;
                }
                CssSelectorList selectorList = postCssNest.getSelectorList();
                if (PostCssPsiUtil.isInsideNestedRuleset((PsiElement)selectorList)) {
                    if (PostCssPsiUtil.isEmptyElement((PsiElement)selectorList)) {
                        holder.registerProblem(postCssNest.getFirstChild(), PostCssBundle.message("annotator.nested.selector.doesnt.have.ampersand.error", new Object[0]), new LocalQuickFix[0]);
                    }
                } else {
                    PostCssNestingInspection.annotateTopLevelSelectorsWithNest(postCssNest, holder);
                }
            }
        };
    }

    private static void annotateNestedSelectorsWithoutAmpersand(CssSelector selector, ProblemsHolder holder) {
        if (PostCssPsiUtil.isInsideNest((PsiElement)selector)) {
            if (!PostCssPsiUtil.containsAmpersand((PsiElement)selector)) {
                holder.registerProblem((PsiElement)selector, PostCssBundle.message("annotator.nested.selector.doesnt.have.ampersand.error", new Object[0]), new LocalQuickFix[0]);
            }
        } else if (!PostCssPsiUtil.containsAmpersand((PsiElement)selector)) {
            holder.registerProblem((PsiElement)selector, PostCssBundle.message("annotator.nested.selector.doesnt.starts.with.ampersand.error", new Object[0]), new LocalQuickFix[]{new PostCssAddAmpersandToSelectorQuickFix()});
        }
    }

    private static void annotateTopLevelSelectorsWithNestingSigns(CssSelectorList selectorList, ProblemsHolder holder) {
        for (TextRange range : PostCssPsiUtil.findAllAmpersands((PsiElement)selectorList)) {
            ProblemDescriptor problemDescriptor = holder.getManager().createProblemDescriptor((PsiElement)selectorList, range, PostCssBundle.message("annotator.normal.selector.contains.direct.nesting.selector", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, true, new LocalQuickFix[]{new PostCssDeleteAmpersandQuickFix()});
            holder.registerProblem(problemDescriptor);
        }
    }

    private static void annotateTopLevelSelectorsWithNest(PostCssNestImpl postCssNest, ProblemsHolder holder) {
        holder.registerProblem(postCssNest.getFirstChild(), PostCssBundle.message("annotator.normal.selector.contains.nest", new Object[0]), new LocalQuickFix[]{new PostCssDeleteAtRuleNestQuickFix()});
    }

    private static void annotateNestedSelectorsWithoutNest(CssSelectorList list, ProblemsHolder holder) {
        if (PostCssPsiUtil.isInsideNest((PsiElement)list)) {
            return;
        }
        boolean everySelectorHasAmpersand = Arrays.stream(list.getSelectors()).allMatch(PostCssPsiUtil::containsAmpersand);
        boolean everySelectorStartsWithAmpersand = Arrays.stream(list.getSelectors()).allMatch(PostCssPsiUtil::startsWithAmpersand);
        if (everySelectorHasAmpersand && !everySelectorStartsWithAmpersand) {
            holder.registerProblem((PsiElement)list, PostCssBundle.message("annotator.nested.selector.list.doesnt.have.nest.at.rule.error", new Object[0]), new LocalQuickFix[]{new PostCssAddAtRuleNestToSelectorQuickFix()});
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/intellij/plugins/postcss/inspections/PostCssNestingInspection", "buildVisitor"));
    }
}

