/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notebooks.visualization.execution;

import com.intellij.notebooks.visualization.ui.ProgressStatus;
import java.time.ZonedDateTime;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001:\u0004\u0002\u0003\u0004\u0005\u0082\u0001\u0004\u0006\u0007\b\t\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\n\u00c0\u0006\u0001"}, d2={"Lcom/intellij/notebooks/visualization/execution/ExecutionEvent;", "", "ExecutionStarted", "ExecutionSubmitted", "ExecutionStopped", "ExecutionReset", "Lcom/intellij/notebooks/visualization/execution/ExecutionEvent$ExecutionReset;", "Lcom/intellij/notebooks/visualization/execution/ExecutionEvent$ExecutionStarted;", "Lcom/intellij/notebooks/visualization/execution/ExecutionEvent$ExecutionStopped;", "Lcom/intellij/notebooks/visualization/execution/ExecutionEvent$ExecutionSubmitted;", "intellij.notebooks.visualization"})
public interface ExecutionEvent {

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/notebooks/visualization/execution/ExecutionEvent$ExecutionReset;", "Lcom/intellij/notebooks/visualization/execution/ExecutionEvent;", "status", "Lcom/intellij/notebooks/visualization/ui/ProgressStatus;", "<init>", "(Lcom/intellij/notebooks/visualization/ui/ProgressStatus;)V", "getStatus", "()Lcom/intellij/notebooks/visualization/ui/ProgressStatus;", "intellij.notebooks.visualization"})
    public static final class ExecutionReset
    implements ExecutionEvent {
        @Nullable
        private final ProgressStatus status;

        public ExecutionReset(@Nullable ProgressStatus status) {
            this.status = status;
        }

        @Nullable
        public final ProgressStatus getStatus() {
            return this.status;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/notebooks/visualization/execution/ExecutionEvent$ExecutionStarted;", "Lcom/intellij/notebooks/visualization/execution/ExecutionEvent;", "status", "Lcom/intellij/notebooks/visualization/ui/ProgressStatus;", "startTime", "Ljava/time/ZonedDateTime;", "<init>", "(Lcom/intellij/notebooks/visualization/ui/ProgressStatus;Ljava/time/ZonedDateTime;)V", "getStatus", "()Lcom/intellij/notebooks/visualization/ui/ProgressStatus;", "getStartTime", "()Ljava/time/ZonedDateTime;", "intellij.notebooks.visualization"})
    public static final class ExecutionStarted
    implements ExecutionEvent {
        @Nullable
        private final ProgressStatus status;
        @NotNull
        private final ZonedDateTime startTime;

        public ExecutionStarted(@Nullable ProgressStatus status, @NotNull ZonedDateTime startTime) {
            Intrinsics.checkNotNullParameter((Object)startTime, (String)"startTime");
            this.status = status;
            this.startTime = startTime;
        }

        @Nullable
        public final ProgressStatus getStatus() {
            return this.status;
        }

        @NotNull
        public final ZonedDateTime getStartTime() {
            return this.startTime;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\n\u0018\u00002\u00020\u0001B#\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0015\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\n\n\u0002\u0010\u0010\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0011"}, d2={"Lcom/intellij/notebooks/visualization/execution/ExecutionEvent$ExecutionStopped;", "Lcom/intellij/notebooks/visualization/execution/ExecutionEvent;", "status", "Lcom/intellij/notebooks/visualization/ui/ProgressStatus;", "endTime", "Ljava/time/ZonedDateTime;", "executionCount", "", "<init>", "(Lcom/intellij/notebooks/visualization/ui/ProgressStatus;Ljava/time/ZonedDateTime;Ljava/lang/Integer;)V", "getStatus", "()Lcom/intellij/notebooks/visualization/ui/ProgressStatus;", "getEndTime", "()Ljava/time/ZonedDateTime;", "getExecutionCount", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "intellij.notebooks.visualization"})
    public static final class ExecutionStopped
    implements ExecutionEvent {
        @Nullable
        private final ProgressStatus status;
        @NotNull
        private final ZonedDateTime endTime;
        @Nullable
        private final Integer executionCount;

        public ExecutionStopped(@Nullable ProgressStatus status, @NotNull ZonedDateTime endTime, @Nullable Integer executionCount) {
            Intrinsics.checkNotNullParameter((Object)endTime, (String)"endTime");
            this.status = status;
            this.endTime = endTime;
            this.executionCount = executionCount;
        }

        @Nullable
        public final ProgressStatus getStatus() {
            return this.status;
        }

        @NotNull
        public final ZonedDateTime getEndTime() {
            return this.endTime;
        }

        @Nullable
        public final Integer getExecutionCount() {
            return this.executionCount;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/notebooks/visualization/execution/ExecutionEvent$ExecutionSubmitted;", "Lcom/intellij/notebooks/visualization/execution/ExecutionEvent;", "status", "Lcom/intellij/notebooks/visualization/ui/ProgressStatus;", "<init>", "(Lcom/intellij/notebooks/visualization/ui/ProgressStatus;)V", "getStatus", "()Lcom/intellij/notebooks/visualization/ui/ProgressStatus;", "intellij.notebooks.visualization"})
    public static final class ExecutionSubmitted
    implements ExecutionEvent {
        @Nullable
        private final ProgressStatus status;

        public ExecutionSubmitted(@Nullable ProgressStatus status) {
            this.status = status;
        }

        @Nullable
        public final ProgressStatus getStatus() {
            return this.status;
        }
    }
}

