/*
 * Decompiled with CFR 0.152.
 */
package git4idea.search;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.i18n.GitBundle;
import git4idea.ignore.GitRepositoryIgnoredFilesHolder;
import git4idea.index.vfs.GitIndexVirtualFileKt;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.repo.GitUntrackedFilesHolder;
import git4idea.search.GitSearchScope;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u001e\u0010\u0004\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00070\u0005\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\f\u001a\u00020\rH\u0017J\u0011\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0006H\u0096\u0002J\u0010\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0006H\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0004\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lgit4idea/search/GitTrackedSearchScope;", "Lgit4idea/search/GitSearchScope;", "project", "Lcom/intellij/openapi/project/Project;", "rootToFilesHolders", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lkotlin/Pair;", "Lgit4idea/repo/GitUntrackedFilesHolder;", "Lgit4idea/ignore/GitRepositoryIgnoredFilesHolder;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/util/Map;)V", "getDisplayName", "", "contains", "", "file", "isTracked", "Companion", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitTrackedSearchScope.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitTrackedSearchScope.kt\ngit4idea/search/GitTrackedSearchScope\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,57:1\n24#2:58\n*S KotlinDebug\n*F\n+ 1 GitTrackedSearchScope.kt\ngit4idea/search/GitTrackedSearchScope\n*L\n35#1:58\n*E\n"})
public final class GitTrackedSearchScope
extends GitSearchScope {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final Project project;
    @NotNull
    private final Map<VirtualFile, Pair<GitUntrackedFilesHolder, GitRepositoryIgnoredFilesHolder>> rootToFilesHolders;
    @NotNull
    private static final Logger LOG;

    public GitTrackedSearchScope(@NotNull Project project, @NotNull Map<VirtualFile, ? extends Pair<? extends GitUntrackedFilesHolder, ? extends GitRepositoryIgnoredFilesHolder>> rootToFilesHolders) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(rootToFilesHolders, (String)"rootToFilesHolders");
        super(project);
        this.project = project;
        this.rootToFilesHolders = rootToFilesHolders;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = GitBundle.message((String)"search.scope.project.git.tracked", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public boolean contains(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return super.contains(file) && this.isTracked(file);
    }

    @VisibleForTesting
    public final boolean isTracked(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        FilePath filePath = GitIndexVirtualFileKt.filePath(file);
        VirtualFile virtualFile = ProjectLevelVcsManager.getInstance((Project)this.project).getVcsRootFor(file);
        if (virtualFile == null) {
            return false;
        }
        VirtualFile gitRoot = virtualFile;
        Pair<GitUntrackedFilesHolder, GitRepositoryIgnoredFilesHolder> pair = this.rootToFilesHolders.get(gitRoot);
        if (pair == null) {
            return false;
        }
        Pair<GitUntrackedFilesHolder, GitRepositoryIgnoredFilesHolder> pair2 = pair;
        GitUntrackedFilesHolder untrackedFilesHolder = (GitUntrackedFilesHolder)pair2.component1();
        GitRepositoryIgnoredFilesHolder ignoredFilesHolder = (GitRepositoryIgnoredFilesHolder)pair2.component2();
        return !untrackedFilesHolder.containsUntrackedFile(filePath) && !ignoredFilesHolder.containsFile(filePath);
    }

    static {
        Companion $this$thisLogger$iv = Companion = new Companion(null);
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0001\u00a2\u0006\u0002\b\nJ0\u0010\u000b\u001a\u001c\u0012\u0004\u0012\u00020\r\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e\u0018\u00010\f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lgit4idea/search/GitTrackedSearchScope$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getSearchScope", "Lgit4idea/search/GitTrackedSearchScope;", "project", "Lcom/intellij/openapi/project/Project;", "getSearchScope$intellij_vcs_git", "getFilesHoldersMapping", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lkotlin/Pair;", "Lgit4idea/repo/GitUntrackedFilesHolder;", "Lgit4idea/ignore/GitRepositoryIgnoredFilesHolder;", "repositories", "", "Lgit4idea/repo/GitRepository;", "intellij.vcs.git"})
    @SourceDebugExtension(value={"SMAP\nGitTrackedSearchScope.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitTrackedSearchScope.kt\ngit4idea/search/GitTrackedSearchScope$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,57:1\n1193#2,2:58\n1267#2,4:60\n*S KotlinDebug\n*F\n+ 1 GitTrackedSearchScope.kt\ngit4idea/search/GitTrackedSearchScope$Companion\n*L\n46#1:58,2\n46#1:60,4\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @VisibleForTesting
        @Nullable
        public final GitTrackedSearchScope getSearchScope$intellij_vcs_git(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            List<GitRepository> list = GitRepositoryManager.getInstance(project).getRepositories();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getRepositories(...)");
            List<GitRepository> repositories = list;
            if (repositories.isEmpty()) {
                return null;
            }
            Map<VirtualFile, Pair<GitUntrackedFilesHolder, GitRepositoryIgnoredFilesHolder>> map2 = this.getFilesHoldersMapping(repositories);
            if (map2 == null) {
                return null;
            }
            Map<VirtualFile, Pair<GitUntrackedFilesHolder, GitRepositoryIgnoredFilesHolder>> rootToFilesHolders = map2;
            return new GitTrackedSearchScope(project, rootToFilesHolders);
        }

        /*
         * WARNING - void declaration
         */
        private final Map<VirtualFile, Pair<GitUntrackedFilesHolder, GitRepositoryIgnoredFilesHolder>> getFilesHoldersMapping(List<? extends GitRepository> repositories) {
            void $this$associateTo$iv$iv;
            Iterable $this$associate$iv = repositories;
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            Iterable iterable = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map2 = destination$iv$iv;
                GitRepository repo = (GitRepository)element$iv$iv;
                boolean bl = false;
                if (!repo.getUntrackedFilesHolder().isInitialized() || !repo.getIgnoredFilesHolder().getInitialized()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Untracked files holder is not initialized for " + repo);
                    }
                    return null;
                }
                Pair pair = TuplesKt.to((Object)repo.getRoot(), (Object)new Pair((Object)repo.getUntrackedFilesHolder(), (Object)repo.getIgnoredFilesHolder()));
                map2.put(pair.getFirst(), pair.getSecond());
            }
            return destination$iv$iv;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

