/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import java.util.Collection;
import java.util.Objects;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.InvertableType;
import org.apache.lucene.document.StoredValue;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.IndexOrDocValuesQuery;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.SortedSetSelector;
import org.apache.lucene.search.SortedSetSortField;
import org.apache.lucene.search.TermInSetQuery;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.BytesRef;

public class KeywordField
extends Field {
    private static final FieldType FIELD_TYPE = new FieldType();
    private static final FieldType FIELD_TYPE_STORED;
    private BytesRef binaryValue;
    private final StoredValue storedValue;

    public KeywordField(String name, BytesRef value, Field.Store stored) {
        super(name, value, (IndexableFieldType)(stored == Field.Store.YES ? FIELD_TYPE_STORED : FIELD_TYPE));
        this.binaryValue = value;
        this.storedValue = stored == Field.Store.YES ? new StoredValue(value) : null;
    }

    public KeywordField(String name, String value, Field.Store stored) {
        super(name, value, (IndexableFieldType)(stored == Field.Store.YES ? FIELD_TYPE_STORED : FIELD_TYPE));
        this.binaryValue = new BytesRef(value);
        this.storedValue = stored == Field.Store.YES ? new StoredValue(value) : null;
    }

    @Override
    public BytesRef binaryValue() {
        return this.binaryValue;
    }

    @Override
    public InvertableType invertableType() {
        return InvertableType.BINARY;
    }

    @Override
    public void setStringValue(String value) {
        super.setStringValue(value);
        this.binaryValue = new BytesRef(value);
        if (this.storedValue != null) {
            this.storedValue.setStringValue(value);
        }
    }

    @Override
    public void setBytesValue(BytesRef value) {
        super.setBytesValue(value);
        this.binaryValue = value;
        if (this.storedValue != null) {
            this.storedValue.setBinaryValue(value);
        }
    }

    @Override
    public StoredValue storedValue() {
        return this.storedValue;
    }

    public static Query newExactQuery(String field, BytesRef value) {
        Objects.requireNonNull(field, "field must not be null");
        Objects.requireNonNull(value, "value must not be null");
        return new ConstantScoreQuery(new TermQuery(new Term(field, value)));
    }

    public static Query newExactQuery(String field, String value) {
        Objects.requireNonNull(value, "value must not be null");
        return KeywordField.newExactQuery(field, new BytesRef(value));
    }

    @Deprecated(forRemoval=true, since="9.10")
    public static Query newSetQuery(String field, BytesRef ... values) {
        Objects.requireNonNull(field, "field must not be null");
        Objects.requireNonNull(values, "values must not be null");
        TermInSetQuery indexQuery = new TermInSetQuery(field, values);
        TermInSetQuery dvQuery = new TermInSetQuery(MultiTermQuery.DOC_VALUES_REWRITE, field, values);
        return new IndexOrDocValuesQuery(indexQuery, dvQuery);
    }

    public static Query newSetQuery(String field, Collection<BytesRef> values) {
        Objects.requireNonNull(field, "field must not be null");
        Objects.requireNonNull(values, "values must not be null");
        TermInSetQuery indexQuery = new TermInSetQuery(field, values);
        TermInSetQuery dvQuery = new TermInSetQuery(MultiTermQuery.DOC_VALUES_REWRITE, field, values);
        return new IndexOrDocValuesQuery(indexQuery, dvQuery);
    }

    public static SortField newSortField(String field, boolean reverse, SortedSetSelector.Type selector) {
        Objects.requireNonNull(field, "field must not be null");
        Objects.requireNonNull(selector, "selector must not be null");
        return new SortedSetSortField(field, reverse, selector);
    }

    static {
        FIELD_TYPE.setIndexOptions(IndexOptions.DOCS);
        FIELD_TYPE.setOmitNorms(true);
        FIELD_TYPE.setTokenized(false);
        FIELD_TYPE.setDocValuesType(DocValuesType.SORTED_SET);
        FIELD_TYPE.freeze();
        FIELD_TYPE_STORED = new FieldType(FIELD_TYPE);
        FIELD_TYPE_STORED.setStored(true);
        FIELD_TYPE_STORED.freeze();
    }
}

