/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.util.zipFs;

import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.io.ResilientFileChannel;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class TraceableFileChannel {
    private static final Logger LOG = Logger.getInstance(TraceableFileChannel.class);
    private final ResilientFileChannel myFileChannel;
    @NotNull
    private final Throwable myOpenTrace;
    @Nullable
    private volatile Throwable myCloseTrace;

    TraceableFileChannel(@NotNull Path path, StandardOpenOption ... options) throws IOException {
        if (path == null) {
            TraceableFileChannel.$$$reportNull$$$0(0);
        }
        this.myFileChannel = new ResilientFileChannel(path, (OpenOption[])options);
        this.myOpenTrace = new Throwable(String.valueOf(path) + " channel creation trace");
    }

    int read(@NotNull ByteBuffer buffer, long position) throws IOException {
        if (buffer == null) {
            TraceableFileChannel.$$$reportNull$$$0(1);
        }
        try {
            return this.myFileChannel.read(buffer, position);
        }
        catch (ClosedChannelException e) {
            this.reportOpenAndCloseTraces(e);
            throw e;
        }
    }

    long size() throws IOException {
        try {
            return this.myFileChannel.size();
        }
        catch (ClosedChannelException e) {
            this.reportOpenAndCloseTraces(e);
            throw e;
        }
    }

    void close() throws IOException {
        try {
            this.myFileChannel.close();
        }
        finally {
            this.myCloseTrace = new Throwable();
        }
    }

    boolean isOpen() {
        return this.myFileChannel.isOpen();
    }

    private void reportOpenAndCloseTraces(ClosedChannelException e) {
        Throwable closeTrace = this.myCloseTrace;
        Attachment closeTraceAttachment = closeTrace == null ? new Attachment("closed externally!", new Throwable()) : new Attachment("close trace", closeTrace);
        LOG.error("Channel is already closed ", (Throwable)e, new Attachment[]{new Attachment("open trace", this.myOpenTrace), closeTraceAttachment});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
        }
        objectArray2[1] = "com/intellij/indexing/shared/util/zipFs/TraceableFileChannel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "read";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

