/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk.target.ssh.target;

import com.intellij.execution.Platform;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.target.HostPort;
import com.intellij.execution.target.ResolvedPortBinding;
import com.intellij.execution.target.ResolvedPortBindingKt;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetPlatform;
import com.intellij.execution.target.TargetProgressIndicator;
import com.intellij.execution.target.TargetedCommandLine;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.AdditionalLibraryRootsProvider;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.SyntheticLibrary;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.remote.DeferredRemoteProcess;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteProcess;
import com.intellij.ssh.ConnectionBuilder;
import com.intellij.ssh.DialogSshSudoPasswordStringProvider;
import com.intellij.ssh.PasswordStringProvider;
import com.intellij.ssh.ProcessBuilder;
import com.intellij.ssh.RSyncUtil;
import com.intellij.ssh.RemoteCredentialsUtil;
import com.intellij.ssh.SftpProgressTracker;
import com.intellij.ssh.SshSession;
import com.intellij.ssh.config.unified.SshConfig;
import com.intellij.ssh.process.SshExecProcess;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.plugins.remotesdk.RemoteSdkBundle;
import com.jetbrains.plugins.remotesdk.target.ssh.target.NewSshVolume;
import com.jetbrains.plugins.remotesdk.target.ssh.target.PublishedVolume;
import com.jetbrains.plugins.remotesdk.target.ssh.target.SshEnvironmentKt;
import com.jetbrains.plugins.remotesdk.target.ssh.target.SshRemoteEnvironmentRequest;
import com.jetbrains.plugins.remotesdk.target.ssh.target.SshTargetEnvironmentConfiguration;
import com.jetbrains.plugins.remotesdk.target.ssh.target.SshTargetUtilKt;
import com.jetbrains.plugins.remotesdk.target.ssh.target.SshTempTargetPathsService;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00b6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\b\u0000\u0018\u0000 E2\u00020\u00012\u00020\u0002:\u0001EB\u0093\u0001\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010\u0012\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0010\u0012\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u0010\u0012\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u00180\u0010\u0012\u0006\u0010\u001b\u001a\u00020\u001c\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0018\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0016J \u00100\u001a\u0002012\u0006\u0010,\u001a\u0002022\u0006\u00103\u001a\u00020\u001c2\u0006\u00104\u001a\u00020\u001cH\u0002J\b\u00105\u001a\u000206H\u0016J\b\u00107\u001a\u00020\u001cH\u0016J*\u00108\u001a\u0002062\u0018\u00109\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020<0;0:2\u0006\u0010=\u001a\u00020>H\u0016JB\u0010?\u001a\u0002062\u0006\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020<2\u0018\u0010C\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020<0;0D2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010=\u001a\u00020>H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R \u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\"R \u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\"R \u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u00180\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\"R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010&\u001a\u00020'X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)\u00a8\u0006F"}, d2={"Lcom/jetbrains/plugins/remotesdk/target/ssh/target/SshEnvironment;", "Lcom/intellij/execution/target/TargetEnvironment;", "Lcom/intellij/execution/target/TargetEnvironment$BatchUploader;", "targetConfiguration", "Lcom/jetbrains/plugins/remotesdk/target/ssh/target/SshTargetEnvironmentConfiguration;", "request", "Lcom/jetbrains/plugins/remotesdk/target/ssh/target/SshRemoteEnvironmentRequest;", "credentials", "Lcom/intellij/remote/RemoteCredentials;", "connectionBuilder", "Lcom/intellij/ssh/ConnectionBuilder;", "project", "Lcom/intellij/openapi/project/Project;", "connection", "Lcom/intellij/ssh/SshSession;", "uploadVolumes", "", "Lcom/intellij/execution/target/TargetEnvironment$UploadRoot;", "Lcom/intellij/execution/target/TargetEnvironment$UploadableVolume;", "downloadVolumes", "Lcom/intellij/execution/target/TargetEnvironment$DownloadRoot;", "Lcom/intellij/execution/target/TargetEnvironment$DownloadableVolume;", "targetPortBindings", "Lcom/intellij/execution/target/TargetEnvironment$TargetPortBinding;", "Lcom/intellij/execution/target/ResolvedPortBinding;", "localPortBindings", "Lcom/intellij/execution/target/TargetEnvironment$LocalPortBinding;", "isRunAsSudoViaRoot", "", "<init>", "(Lcom/jetbrains/plugins/remotesdk/target/ssh/target/SshTargetEnvironmentConfiguration;Lcom/jetbrains/plugins/remotesdk/target/ssh/target/SshRemoteEnvironmentRequest;Lcom/intellij/remote/RemoteCredentials;Lcom/intellij/ssh/ConnectionBuilder;Lcom/intellij/openapi/project/Project;Lcom/intellij/ssh/SshSession;Ljava/util/Map;Ljava/util/Map;Ljava/util/Map;Ljava/util/Map;Z)V", "getRequest", "()Lcom/jetbrains/plugins/remotesdk/target/ssh/target/SshRemoteEnvironmentRequest;", "getUploadVolumes", "()Ljava/util/Map;", "getDownloadVolumes", "getTargetPortBindings", "getLocalPortBindings", "targetPlatform", "Lcom/intellij/execution/target/TargetPlatform;", "getTargetPlatform", "()Lcom/intellij/execution/target/TargetPlatform;", "createProcess", "Ljava/lang/Process;", "commandLine", "Lcom/intellij/execution/target/TargetedCommandLine;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "startSshProcess", "Lcom/intellij/ssh/process/SshExecProcess;", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "allocatePty", "runViaSudo", "shutdown", "", "canUploadInBatches", "runBatchUpload", "uploads", "", "Lkotlin/Pair;", "", "targetProgressIndicator", "Lcom/intellij/execution/target/TargetProgressIndicator;", "uploadWithRsync", "localSharedPath", "Ljava/nio/file/Path;", "remoteSharedPath", "paths", "", "Companion", "intellij.remoteRun"})
@SourceDebugExtension(value={"SMAP\nSshEnvironment.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SshEnvironment.kt\ncom/jetbrains/plugins/remotesdk/target/ssh/target/SshEnvironment\n+ 2 promise.kt\norg/jetbrains/concurrency/Promises__PromiseKt\n*L\n1#1,725:1\n212#2,12:726\n*S KotlinDebug\n*F\n+ 1 SshEnvironment.kt\ncom/jetbrains/plugins/remotesdk/target/ssh/target/SshEnvironment\n*L\n102#1:726,12\n*E\n"})
public final class SshEnvironment
extends TargetEnvironment
implements TargetEnvironment.BatchUploader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SshTargetEnvironmentConfiguration targetConfiguration;
    @NotNull
    private final SshRemoteEnvironmentRequest request;
    @NotNull
    private final RemoteCredentials credentials;
    @NotNull
    private final ConnectionBuilder connectionBuilder;
    @Nullable
    private final Project project;
    @NotNull
    private final SshSession connection;
    @NotNull
    private final Map<TargetEnvironment.UploadRoot, TargetEnvironment.UploadableVolume> uploadVolumes;
    @NotNull
    private final Map<TargetEnvironment.DownloadRoot, TargetEnvironment.DownloadableVolume> downloadVolumes;
    @NotNull
    private final Map<TargetEnvironment.TargetPortBinding, ResolvedPortBinding> targetPortBindings;
    @NotNull
    private final Map<TargetEnvironment.LocalPortBinding, ResolvedPortBinding> localPortBindings;
    private final boolean isRunAsSudoViaRoot;
    @NotNull
    private final TargetPlatform targetPlatform;
    @NlsSafe
    @NotNull
    public static final String RSYNC = "rsync";

    private SshEnvironment(SshTargetEnvironmentConfiguration targetConfiguration, SshRemoteEnvironmentRequest request, RemoteCredentials credentials, ConnectionBuilder connectionBuilder, Project project, SshSession connection, Map<TargetEnvironment.UploadRoot, ? extends TargetEnvironment.UploadableVolume> uploadVolumes, Map<TargetEnvironment.DownloadRoot, ? extends TargetEnvironment.DownloadableVolume> downloadVolumes, Map<TargetEnvironment.TargetPortBinding, ResolvedPortBinding> targetPortBindings, Map<TargetEnvironment.LocalPortBinding, ResolvedPortBinding> localPortBindings, boolean isRunAsSudoViaRoot) {
        super((TargetEnvironmentRequest)request);
        this.targetConfiguration = targetConfiguration;
        this.request = request;
        this.credentials = credentials;
        this.connectionBuilder = connectionBuilder;
        this.project = project;
        this.connection = connection;
        this.uploadVolumes = uploadVolumes;
        this.downloadVolumes = downloadVolumes;
        this.targetPortBindings = targetPortBindings;
        this.localPortBindings = localPortBindings;
        this.isRunAsSudoViaRoot = isRunAsSudoViaRoot;
        this.targetPlatform = this.getRequest().getTargetPlatform();
        this.getRequest().getConnectionBuilderPromise$intellij_remoteRun().setResult((Object)this.connectionBuilder);
        for (Pair<String, AsyncPromise<String>> pair : this.getRequest().getUploadRootPromises$intellij_remoteRun()) {
            String requestedRemoteRootPath = (String)pair.component1();
            AsyncPromise remoteRootPromise = (AsyncPromise)pair.component2();
            Platform platform = this.getTargetPlatform().getPlatform();
            Intrinsics.checkNotNullExpressionValue((Object)platform, (String)"getPlatform(...)");
            remoteRootPromise.setResult((Object)SshTargetUtilKt.createRemoteDirectory(this.connectionBuilder, platform, this.targetConfiguration, requestedRemoteRootPath, null));
        }
        for (Pair pair : this.getRequest().getPortPromises$intellij_remoteRun()) {
            int targetPort = ((Number)pair.component1()).intValue();
            AsyncPromise localPortPromise = (AsyncPromise)pair.component2();
            localPortPromise.setResult((Object)this.connection.addLocalTunnelWithRandomLocalPort("localhost", targetPort));
        }
        for (Pair pair : this.getRequest().getLocalPortPromises$intellij_remoteRun()) {
            int localPort = ((Number)pair.component1()).intValue();
            AsyncPromise targetPortPromise = (AsyncPromise)pair.component2();
            int remotePort = this.connection.addRemoteTunnelWithRandomRemotePort("localhost", localPort);
            targetPortPromise.setResult((Object)new HostPort("localhost", remotePort));
        }
    }

    @NotNull
    public SshRemoteEnvironmentRequest getRequest() {
        return this.request;
    }

    @NotNull
    public Map<TargetEnvironment.UploadRoot, TargetEnvironment.UploadableVolume> getUploadVolumes() {
        return this.uploadVolumes;
    }

    @NotNull
    public Map<TargetEnvironment.DownloadRoot, TargetEnvironment.DownloadableVolume> getDownloadVolumes() {
        return this.downloadVolumes;
    }

    @NotNull
    public Map<TargetEnvironment.TargetPortBinding, ResolvedPortBinding> getTargetPortBindings() {
        return this.targetPortBindings;
    }

    @NotNull
    public Map<TargetEnvironment.LocalPortBinding, ResolvedPortBinding> getLocalPortBindings() {
        return this.localPortBindings;
    }

    @NotNull
    public TargetPlatform getTargetPlatform() {
        return this.targetPlatform;
    }

    @NotNull
    public Process createProcess(@NotNull TargetedCommandLine commandLine, @NotNull ProgressIndicator indicator) {
        Process process;
        boolean allocatePty;
        List list;
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        try {
            Object object = commandLine.collectCommands().blockingGet(0, TimeUnit.SECONDS);
            Intrinsics.checkNotNull((Object)object);
            list = (List)object;
        }
        catch (TimeoutException err) {
            throw new ExecutionException("Failed to create SSH process due to timeout", err);
        }
        List commands = list;
        GeneralCommandLine generalCommandLine = new GeneralCommandLine(commands);
        generalCommandLine.setWorkDirectory(commandLine.getWorkingDirectory());
        generalCommandLine.withEnvironment(commandLine.getEnvironmentVariables());
        boolean bl = allocatePty = commandLine.getPtyOptions() != null || this.getRequest().isForcedPtyAllocation();
        if (ApplicationManager.getApplication().isDispatchThread()) {
            boolean $i$f$runAsync = false;
            AsyncPromise promise$iv = new AsyncPromise();
            AppExecutorUtil.getAppExecutorService().execute(new Runnable(promise$iv, this, generalCommandLine, allocatePty){
                final /* synthetic */ AsyncPromise $promise;
                final /* synthetic */ SshEnvironment this$0;
                final /* synthetic */ GeneralCommandLine $generalCommandLine$inlined;
                final /* synthetic */ boolean $allocatePty$inlined;
                {
                    this.$promise = $promise;
                    this.this$0 = sshEnvironment;
                    this.$generalCommandLine$inlined = generalCommandLine;
                    this.$allocatePty$inlined = bl;
                }

                public final void run() {
                    RemoteProcess remoteProcess;
                    try {
                        boolean bl = false;
                        remoteProcess = (RemoteProcess)SshEnvironment.access$startSshProcess(this.this$0, this.$generalCommandLine$inlined, this.$allocatePty$inlined, SshEnvironment.access$isRunAsSudoViaRoot$p(this.this$0));
                    }
                    catch (Throwable e) {
                        this.$promise.setError(e);
                        return;
                    }
                    RemoteProcess result = remoteProcess;
                    this.$promise.setResult((Object)result);
                }
            });
            process = (Process)new DeferredRemoteProcess((Promise)promise$iv);
        } else {
            process = (Process)this.startSshProcess(generalCommandLine, allocatePty, this.isRunAsSudoViaRoot);
        }
        return process;
    }

    private final SshExecProcess startSshProcess(GeneralCommandLine commandLine, boolean allocatePty, boolean runViaSudo) {
        ProcessBuilder processBuilder;
        block1: {
            ProcessBuilder $this$startSshProcess_u24lambda_u242 = processBuilder = RemoteCredentialsUtil.processBuilder((ConnectionBuilder)this.connectionBuilder, (GeneralCommandLine)commandLine).withAllocatePty(allocatePty);
            boolean bl = false;
            if (!runViaSudo) break block1;
            SshConfig sshConfig = this.targetConfiguration.findSshConfig(this.project);
            if (sshConfig != null) {
                SshConfig sshConfig2 = sshConfig;
                boolean bl2 = false;
                $this$startSshProcess_u24lambda_u242.withSudo((PasswordStringProvider)new DialogSshSudoPasswordStringProvider(sshConfig2, null, 2, null));
            }
        }
        return ProcessBuilder.start$default((ProcessBuilder)processBuilder, (int)0, (int)1, null);
    }

    public void shutdown() {
        Iterator<Object> iterator = this.getRequest().getPortPromises$intellij_remoteRun().iterator();
        while (iterator.hasNext()) {
            AsyncPromise localPortPromise = (AsyncPromise)iterator.next().component2();
            localPortPromise.then(arg_0 -> SshEnvironment.shutdown$lambda$4(arg_0 -> SshEnvironment.shutdown$lambda$3(this, arg_0), arg_0));
        }
        iterator = this.getRequest().getLocalPortPromises$intellij_remoteRun().iterator();
        while (iterator.hasNext()) {
            AsyncPromise promise = (AsyncPromise)iterator.next().component2();
            promise.then(arg_0 -> SshEnvironment.shutdown$lambda$6(arg_0 -> SshEnvironment.shutdown$lambda$5(this, arg_0), arg_0));
        }
        iterator = this.getLocalPortBindings().entrySet().iterator();
        while (iterator.hasNext()) {
            ResolvedPortBinding localPortBinding = (ResolvedPortBinding)((Map.Entry)iterator.next()).getValue();
            SshEnvironment.shutdown$removeTunnel((Function1<? super Integer, Unit>)((Function1)new Function1<Integer, Unit>((Object)this.connection){

                public final void invoke(int p0) {
                    ((SshSession)this.receiver).removeLocalTunnel(p0);
                }
            }), ResolvedPortBindingKt.getLocalPort((ResolvedPortBinding)localPortBinding));
            SshEnvironment.shutdown$removeTunnel((Function1<? super Integer, Unit>)((Function1)new Function1<Integer, Unit>((Object)this.connection){

                public final void invoke(int p0) {
                    ((SshSession)this.receiver).removeRemoteTunnel(p0);
                }
            }), ResolvedPortBindingKt.getLocalPort((ResolvedPortBinding)localPortBinding));
        }
        iterator = this.getTargetPortBindings().entrySet().iterator();
        while (iterator.hasNext()) {
            ResolvedPortBinding targetPortBinding = (ResolvedPortBinding)((Map.Entry)iterator.next()).getValue();
            SshEnvironment.shutdown$removeTunnel((Function1<? super Integer, Unit>)((Function1)new Function1<Integer, Unit>((Object)this.connection){

                public final void invoke(int p0) {
                    ((SshSession)this.receiver).removeLocalTunnel(p0);
                }
            }), ResolvedPortBindingKt.getLocalPort((ResolvedPortBinding)targetPortBinding));
            SshEnvironment.shutdown$removeTunnel((Function1<? super Integer, Unit>)((Function1)new Function1<Integer, Unit>((Object)this.connection){

                public final void invoke(int p0) {
                    ((SshSession)this.receiver).removeRemoteTunnel(p0);
                }
            }), ResolvedPortBindingKt.getLocalPort((ResolvedPortBinding)targetPortBinding));
        }
    }

    public boolean canUploadInBatches() {
        return this.getRequest().getConfiguration().getUseRsync();
    }

    public void runBatchUpload(@NotNull List<? extends Pair<? extends TargetEnvironment.UploadableVolume, String>> uploads, @NotNull TargetProgressIndicator targetProgressIndicator) throws IOException {
        Intrinsics.checkNotNullParameter(uploads, (String)"uploads");
        Intrinsics.checkNotNullParameter((Object)targetProgressIndicator, (String)"targetProgressIndicator");
        MultiMap batches = new MultiMap();
        for (Pair<? extends TargetEnvironment.UploadableVolume, String> pair : uploads) {
            if (pair.getFirst() instanceof NewSshVolume) {
                Object object = pair.getFirst();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.jetbrains.plugins.remotesdk.target.ssh.target.NewSshVolume");
                Pair<Path, String> batchPaths = ((NewSshVolume)object).getBatchPaths();
                if (batchPaths != null) {
                    batches.putValue(batchPaths, pair);
                    continue;
                }
            }
            ((TargetEnvironment.UploadableVolume)pair.getFirst()).upload((String)pair.getSecond(), targetProgressIndicator);
        }
        for (Map.Entry entry : batches.entrySet()) {
            Path path = (Path)((Pair)entry.getKey()).getFirst();
            String string = (String)((Pair)entry.getKey()).getSecond();
            Object v = entry.getValue();
            Intrinsics.checkNotNullExpressionValue(v, (String)"<get-value>(...)");
            this.uploadWithRsync(path, string, (Collection)v, this.credentials, targetProgressIndicator);
        }
    }

    private final void uploadWithRsync(Path localSharedPath, String remoteSharedPath, Collection<? extends Pair<? extends TargetEnvironment.UploadableVolume, String>> paths, RemoteCredentials credentials, TargetProgressIndicator targetProgressIndicator) {
        if (paths.size() == 1) {
            Pair<? extends TargetEnvironment.UploadableVolume, String> pair = paths.iterator().next();
            TargetEnvironment.UploadableVolume uploadableVolume = (TargetEnvironment.UploadableVolume)pair.component1();
            String path = (String)pair.component2();
            uploadableVolume.upload(path, targetProgressIndicator);
            return;
        }
        List list = ContainerUtil.map(paths, arg_0 -> SshEnvironment.uploadWithRsync$lambda$8(arg_0 -> SshEnvironment.uploadWithRsync$lambda$7(localSharedPath, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"map(...)");
        List relativePaths = list;
        if (SshEnvironmentKt.access$getLOG$p().isDebugEnabled()) {
            SshEnvironmentKt.access$getLOG$p().debug("RSync file content: " + relativePaths);
        }
        String string = ((Object)localSharedPath).toString();
        Collection collection = relativePaths;
        File file = localSharedPath.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        RSyncUtil.uploadInBatchWithRSync((String)string, (String)remoteSharedPath, (Collection)collection, (RemoteCredentials)credentials, Companion.getRsyncExclusions$intellij_remoteRun(file, false, this.project, relativePaths), (boolean)true, (RSyncUtil.IndicatorWrapper)Companion.createIndicatorWrapper(targetProgressIndicator));
    }

    private static final void shutdown$removeTunnel(Function1<? super Integer, Unit> remove, int port) {
        try {
            remove.invoke((Object)port);
        }
        catch (Throwable err) {
            SshEnvironmentKt.access$getLOG$p().info(err);
        }
    }

    private static final Unit shutdown$lambda$3(SshEnvironment this$0, Integer it) {
        Function1 function1 = (Function1)new Function1<Integer, Unit>((Object)this$0.connection){

            public final void invoke(int p0) {
                ((SshSession)this.receiver).removeLocalTunnel(p0);
            }
        };
        Intrinsics.checkNotNull((Object)it);
        SshEnvironment.shutdown$removeTunnel((Function1<? super Integer, Unit>)function1, it);
        return Unit.INSTANCE;
    }

    private static final Unit shutdown$lambda$4(Function1 $tmp0, Object p0) {
        return (Unit)$tmp0.invoke(p0);
    }

    private static final Unit shutdown$lambda$5(SshEnvironment this$0, HostPort it) {
        SshEnvironment.shutdown$removeTunnel((Function1<? super Integer, Unit>)((Function1)new Function1<Integer, Unit>((Object)this$0.connection){

            public final void invoke(int p0) {
                ((SshSession)this.receiver).removeRemoteTunnel(p0);
            }
        }), it.getPort());
        return Unit.INSTANCE;
    }

    private static final Unit shutdown$lambda$6(Function1 $tmp0, Object p0) {
        return (Unit)$tmp0.invoke(p0);
    }

    private static final String uploadWithRsync$lambda$7(Path $localSharedPath, Pair it) {
        return ((Object)$localSharedPath.relativize(((TargetEnvironment.UploadableVolume)it.getFirst()).getLocalRoot().resolve((String)it.getSecond()))).toString();
    }

    private static final String uploadWithRsync$lambda$8(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    @JvmStatic
    @NotNull
    public static final SshEnvironment create(@NotNull SshTargetEnvironmentConfiguration targetConfiguration, @NotNull SshRemoteEnvironmentRequest request, @NotNull ConnectionBuilder connectionBuilder, @NotNull RemoteCredentials credentials, @NotNull TargetProgressIndicator targetProgressIndicator, @Nullable Project project, boolean isRunAsSudoViaRoot) {
        return Companion.create(targetConfiguration, request, connectionBuilder, credentials, targetProgressIndicator, project, isRunAsSudoViaRoot);
    }

    public /* synthetic */ SshEnvironment(SshTargetEnvironmentConfiguration targetConfiguration, SshRemoteEnvironmentRequest request, RemoteCredentials credentials, ConnectionBuilder connectionBuilder, Project project, SshSession connection, Map uploadVolumes, Map downloadVolumes, Map targetPortBindings, Map localPortBindings, boolean isRunAsSudoViaRoot, DefaultConstructorMarker $constructor_marker) {
        this(targetConfiguration, request, credentials, connectionBuilder, project, connection, uploadVolumes, downloadVolumes, targetPortBindings, localPortBindings, isRunAsSudoViaRoot);
    }

    public static final /* synthetic */ SshExecProcess access$startSshProcess(SshEnvironment $this, GeneralCommandLine commandLine, boolean allocatePty, boolean runViaSudo) {
        return $this.startSshProcess(commandLine, allocatePty, runViaSudo);
    }

    public static final /* synthetic */ boolean access$isRunAsSudoViaRoot$p(SshEnvironment $this) {
        return $this.isRunAsSudoViaRoot;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JB\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J$\u0010\u0016\u001a\u00020\u00172\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b0\u00192\u0006\u0010\u001c\u001a\u00020\u001bH\u0002J\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0010\u001a\u00020\u0011Jf\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u001b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020(0'H\u0002J^\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u001b2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\f\u001a\u00020\r2\u0006\u0010$\u001a\u00020%2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020(0'2\u0006\u0010,\u001a\u00020\u0015H\u0002J'\u0010-\u001a\n\u0012\u0004\u0012\u00020/\u0018\u00010.2\u0006\u00100\u001a\u00020/2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0000\u00a2\u0006\u0002\b1J\"\u00102\u001a\n\u0012\u0004\u0012\u000204\u0018\u0001032\b\u00100\u001a\u0004\u0018\u0001042\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J \u00105\u001a\b\u0012\u0004\u0012\u000204032\u0006\u0010\u0012\u001a\u00020\u00132\b\u00100\u001a\u0004\u0018\u000104H\u0002J=\u00106\u001a\b\u0012\u0004\u0012\u00020\u0005032\u0006\u00100\u001a\u00020/2\u0006\u00107\u001a\u00020\u00152\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u000e\b\u0002\u00108\u001a\b\u0012\u0004\u0012\u00020\u000509H\u0000\u00a2\u0006\u0002\b:R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087T\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lcom/jetbrains/plugins/remotesdk/target/ssh/target/SshEnvironment$Companion;", "", "<init>", "()V", "RSYNC", "", "create", "Lcom/jetbrains/plugins/remotesdk/target/ssh/target/SshEnvironment;", "targetConfiguration", "Lcom/jetbrains/plugins/remotesdk/target/ssh/target/SshTargetEnvironmentConfiguration;", "request", "Lcom/jetbrains/plugins/remotesdk/target/ssh/target/SshRemoteEnvironmentRequest;", "connectionBuilder", "Lcom/intellij/ssh/ConnectionBuilder;", "credentials", "Lcom/intellij/remote/RemoteCredentials;", "targetProgressIndicator", "Lcom/intellij/execution/target/TargetProgressIndicator;", "project", "Lcom/intellij/openapi/project/Project;", "isRunAsSudoViaRoot", "", "removeFromParts", "", "parts", "Lcom/intellij/util/containers/MultiMap;", "Ljava/nio/file/Path;", "Lcom/intellij/execution/target/TargetEnvironment$UploadRoot;", "root", "createIndicatorWrapper", "Lcom/intellij/ssh/RSyncUtil$IndicatorWrapper;", "createUploadableVolume", "Lcom/intellij/execution/target/TargetEnvironment$UploadableVolume;", "uploadRoot", "targetRootPath", "Lcom/intellij/execution/target/TargetEnvironment$TargetPath;", "platform", "Lcom/intellij/execution/Platform;", "sftpProgressTrackerFactory", "Lkotlin/Function1;", "Lcom/intellij/ssh/SftpProgressTracker;", "createSshVolume", "Lcom/jetbrains/plugins/remotesdk/target/ssh/target/NewSshVolume;", "uploadVolume", "provideDefaultSharedPaths", "getSshUploadFileFilter", "Ljava/util/function/Predicate;", "Ljava/io/File;", "localRoot", "getSshUploadFileFilter$intellij_remoteRun", "getExcludedFromProjectChildren", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "getAdditionalLibrariesSourceRoots", "getRsyncExclusions", "shouldUseVirtualFile", "relativePathsToRetain", "", "getRsyncExclusions$intellij_remoteRun", "intellij.remoteRun"})
    @SourceDebugExtension(value={"SMAP\nSshEnvironment.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SshEnvironment.kt\ncom/jetbrains/plugins/remotesdk/target/ssh/target/SshEnvironment$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,725:1\n1#2:726\n1563#3:727\n1634#3,3:728\n774#3:731\n865#3,2:732\n*S KotlinDebug\n*F\n+ 1 SshEnvironment.kt\ncom/jetbrains/plugins/remotesdk/target/ssh/target/SshEnvironment$Companion\n*L\n493#1:727\n493#1:728,3\n589#1:731\n589#1:732,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final SshEnvironment create(@NotNull SshTargetEnvironmentConfiguration targetConfiguration, @NotNull SshRemoteEnvironmentRequest request, @NotNull ConnectionBuilder connectionBuilder, @NotNull RemoteCredentials credentials, @NotNull TargetProgressIndicator targetProgressIndicator, @Nullable Project project, boolean isRunAsSudoViaRoot) {
            Object object;
            Object targetDirectory;
            Intrinsics.checkNotNullParameter((Object)((Object)targetConfiguration), (String)"targetConfiguration");
            Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
            Intrinsics.checkNotNullParameter((Object)connectionBuilder, (String)"connectionBuilder");
            Intrinsics.checkNotNullParameter((Object)credentials, (String)"credentials");
            Intrinsics.checkNotNullParameter((Object)targetProgressIndicator, (String)"targetProgressIndicator");
            HashMap uploadVolumes = new HashMap();
            HashMap downloadVolumes = new HashMap();
            HashMap targetPortBindings = new HashMap();
            HashMap localPortBindings = new HashMap();
            Object[] objectArray = new Object[]{connectionBuilder.getHost()};
            targetProgressIndicator.addSystemLine(RemoteSdkBundle.message("progress.text.connecting.to.0", objectArray));
            SshSession connection = connectionBuilder.connect();
            SshEnvironment sshEnvironment = new SshEnvironment(targetConfiguration, request, credentials, connectionBuilder, project, connection, uploadVolumes, downloadVolumes, targetPortBindings, localPortBindings, isRunAsSudoViaRoot, null);
            Function1 sftpProgressTrackerFactory = SshEnvironmentKt.access$makeSftpProgressTrackerFactory();
            Platform platform = request.getTargetPlatform().getPlatform();
            Intrinsics.checkNotNullExpressionValue((Object)platform, (String)"getPlatform(...)");
            Platform platform2 = platform;
            if (targetConfiguration.getUseRsync()) {
                MultiMap pathsForBatches = new MultiMap();
                for (TargetEnvironment.UploadRoot uploadVolume : request.getUploadVolumes()) {
                    TargetEnvironment.TargetPath targetRootPath = uploadVolume.getTargetRootPath();
                    if (targetRootPath instanceof TargetEnvironment.TargetPath.Temporary && ((TargetEnvironment.TargetPath.Temporary)targetRootPath).getParentDirectory() == null) {
                        String string = ((TargetEnvironment.TargetPath.Temporary)targetRootPath).getHint();
                        if (string == null) {
                            string = "unknown";
                        }
                        pathsForBatches.putValue((Object)string, (Object)uploadVolume);
                        continue;
                    }
                    ((Map)uploadVolumes).put(uploadVolume, this.createSshVolume(uploadVolume, project, connectionBuilder, platform2, targetConfiguration, targetProgressIndicator, credentials, (Function1<? super TargetProgressIndicator, ? extends SftpProgressTracker>)sftpProgressTrackerFactory, false));
                }
                for (Map.Entry entry : pathsForBatches.entrySet()) {
                    Path path;
                    Object uploadRoot2;
                    List handledRoots = new ArrayList();
                    block2: for (Object uploadRoot2 : (Collection)entry.getValue()) {
                        Path path2 = uploadRoot2.getLocalRootPath();
                        for (TargetEnvironment.UploadRoot otherRoot : (Collection)entry.getValue()) {
                            if (Intrinsics.areEqual((Object)uploadRoot2, (Object)otherRoot) || !otherRoot.getLocalRootPath().startsWith(path2) || handledRoots.contains(otherRoot)) continue;
                            Map map = uploadVolumes;
                            Intrinsics.checkNotNull((Object)uploadRoot2);
                            map.put(uploadRoot2, this.createSshVolume((TargetEnvironment.UploadRoot)uploadRoot2, project, connectionBuilder, platform2, targetConfiguration, targetProgressIndicator, credentials, (Function1<? super TargetProgressIndicator, ? extends SftpProgressTracker>)sftpProgressTrackerFactory, false));
                            handledRoots.add(uploadRoot2);
                            continue block2;
                        }
                    }
                    MultiMap parts = new MultiMap();
                    for (TargetEnvironment.UploadRoot uploadRoot3 : (Collection)entry.getValue()) {
                        if (handledRoots.contains(uploadRoot3)) continue;
                        for (path = uploadRoot3.getLocalRootPath(); path != null; path = path.getParent()) {
                            parts.putValue((Object)path, (Object)uploadRoot3);
                        }
                    }
                    uploadRoot2 = ((Collection)entry.getValue()).iterator();
                    while (uploadRoot2.hasNext()) {
                        SshTempTargetPathsService service;
                        TargetEnvironment.UploadRoot uploadRoot3;
                        uploadRoot3 = (TargetEnvironment.UploadRoot)uploadRoot2.next();
                        if (handledRoots.contains(uploadRoot3)) continue;
                        path = uploadRoot3.getLocalRootPath();
                        int numberOfSharers = parts.get((Object)path).size();
                        Path sharingPath = path;
                        Path pathToTest = path.getParent();
                        while (pathToTest != null) {
                            int newNumberOfSharers = parts.get((Object)pathToTest).size();
                            Path parent = pathToTest.getParent();
                            if (newNumberOfSharers > numberOfSharers && parent != null) {
                                numberOfSharers = newNumberOfSharers;
                                sharingPath = pathToTest;
                            }
                            pathToTest = parent;
                        }
                        if (numberOfSharers == 1) {
                            Map map = uploadVolumes;
                            Intrinsics.checkNotNull((Object)uploadRoot3);
                            map.put(uploadRoot3, this.createSshVolume(uploadRoot3, project, connectionBuilder, platform2, targetConfiguration, targetProgressIndicator, credentials, (Function1<? super TargetProgressIndicator, ? extends SftpProgressTracker>)sftpProgressTrackerFactory, true));
                            handledRoots.add(uploadRoot3);
                            this.removeFromParts((MultiMap<Path, TargetEnvironment.UploadRoot>)parts, uploadRoot3);
                            continue;
                        }
                        ArrayList pathSharers = new ArrayList(parts.get((Object)sharingPath));
                        Intrinsics.checkNotNullExpressionValue((Object)SshTempTargetPathsService.getInstance(project), (String)"getInstance(...)");
                        TargetEnvironment.TargetPath targetPath = uploadRoot3.getTargetRootPath();
                        Intrinsics.checkNotNull((Object)targetPath, (String)"null cannot be cast to non-null type @[NotNull(value = <null>, exception = <null>)] com.intellij.execution.target.TargetEnvironment.TargetPath.Temporary");
                        TargetEnvironment.TargetPath.Temporary temporary = (TargetEnvironment.TargetPath.Temporary)targetPath;
                        String remoteRootPath = service.getTargetPath(temporary, sharingPath, targetConfiguration);
                        String targetDirectory2 = SshTargetUtilKt.createRemoteDirectory(connectionBuilder, platform2, targetConfiguration, remoteRootPath, temporary.getPrefix());
                        service.setTargetPath(temporary, sharingPath, targetConfiguration, targetDirectory2);
                        Object object2 = new Object[]{sharingPath, connectionBuilder.getHost(), targetDirectory2};
                        targetProgressIndicator.addSystemLine(RemoteSdkBundle.message("progress.text.set.up.batch.uploading.volume.file.0.ssh.1.2", (Object[])object2));
                        Iterator iterator = pathSharers.iterator();
                        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
                        object2 = iterator;
                        while (object2.hasNext()) {
                            TargetEnvironment.UploadRoot pathSharer = (TargetEnvironment.UploadRoot)object2.next();
                            Path relativePath = sharingPath.relativize(pathSharer.getLocalRootPath());
                            ((Map)uploadVolumes).put(pathSharer, new NewSshVolume(credentials, platform2, (Function1<? super TargetProgressIndicator, ? extends SftpProgressTracker>)sftpProgressTrackerFactory, pathSharer.getLocalRootPath(), targetDirectory2 + platform2.fileSeparator + relativePath, targetConfiguration.getUseRsync(), project, sharingPath, targetDirectory2));
                            Intrinsics.checkNotNull((Object)pathSharer);
                            handledRoots.add(pathSharer);
                            this.removeFromParts((MultiMap<Path, TargetEnvironment.UploadRoot>)parts, pathSharer);
                            targetProgressIndicator.addSystemLine("   " + relativePath);
                        }
                    }
                }
            } else {
                for (TargetEnvironment.UploadRoot uploadVolume : request.getUploadVolumes()) {
                    TargetEnvironment.TargetPath targetRootPath = uploadVolume.getTargetRootPath();
                    ((Map)uploadVolumes).put(uploadVolume, this.createUploadableVolume(uploadVolume, request, targetRootPath, platform2, project, connectionBuilder, targetConfiguration, targetProgressIndicator, credentials, (Function1<? super TargetProgressIndicator, ? extends SftpProgressTracker>)sftpProgressTrackerFactory));
                }
            }
            for (TargetEnvironment.DownloadRoot downloadVolume : request.getDownloadVolumes()) {
                String string;
                Object[] targetRootPath;
                Path localDirectory;
                Path path = downloadVolume.getLocalRootPath();
                if (path == null) {
                    path = localDirectory = FileUtil.createTempDirectory((String)"intellij-target.", (String)"").toPath();
                }
                if ((targetRootPath = downloadVolume.getTargetRootPath()) instanceof TargetEnvironment.TargetPath.Persistent) {
                    string = ((TargetEnvironment.TargetPath.Persistent)targetRootPath).getAbsolutePath();
                } else if (targetRootPath instanceof TargetEnvironment.TargetPath.Temporary) {
                    SshTempTargetPathsService service;
                    Intrinsics.checkNotNullExpressionValue((Object)SshTempTargetPathsService.getInstance(project), (String)"getInstance(...)");
                    String directory = SshTargetUtilKt.createRemoteDirectory(connectionBuilder, platform2, targetConfiguration, service.getTargetPath((TargetEnvironment.TargetPath.Temporary)targetRootPath, localDirectory, targetConfiguration), ((TargetEnvironment.TargetPath.Temporary)targetRootPath).getPrefix());
                    service.setTargetPath((TargetEnvironment.TargetPath.Temporary)targetRootPath, localDirectory, targetConfiguration, directory);
                    string = directory;
                } else {
                    throw new IllegalStateException("Unexpected targetRootPath " + (TargetEnvironment.TargetPath)targetRootPath);
                }
                targetDirectory = string;
                targetRootPath = new Object[]{localDirectory, connectionBuilder.getHost(), targetDirectory};
                targetProgressIndicator.addSystemLine(RemoteSdkBundle.message("progress.text.set.up.downloading.volume.file.0.ssh.1.2", targetRootPath));
                Map map = downloadVolumes;
                Intrinsics.checkNotNull((Object)localDirectory);
                map.put(downloadVolume, new NewSshVolume(credentials, platform2, (Function1<? super TargetProgressIndicator, ? extends SftpProgressTracker>)sftpProgressTrackerFactory, localDirectory, (String)targetDirectory, targetConfiguration.getUseRsync(), project, null, null));
            }
            for (TargetEnvironment.TargetPortBinding targetPortBinding : request.getTargetPortBindings()) {
                int n;
                targetDirectory = targetPortBinding.getLocal();
                if (targetDirectory != null) {
                    object = targetDirectory;
                    int it = ((Number)object).intValue();
                    boolean bl = false;
                    connection.addLocalTunnel(it, "localhost", targetPortBinding.getTarget());
                    n = ((Number)object).intValue();
                } else {
                    n = connection.addLocalTunnelWithRandomLocalPort("localhost", targetPortBinding.getTarget());
                }
                int localPort = n;
                ((Map)targetPortBindings).put(targetPortBinding, new ResolvedPortBinding(new HostPort("localhost", localPort), new HostPort("localhost", targetPortBinding.getTarget())));
            }
            for (TargetEnvironment.LocalPortBinding localPortBinding : request.getLocalPortBindings()) {
                int n;
                targetDirectory = localPortBinding.getTarget();
                if (targetDirectory != null) {
                    object = targetDirectory;
                    int it = ((Number)object).intValue();
                    boolean bl = false;
                    connection.addRemoteTunnel(it, "localhost", localPortBinding.getLocal());
                    n = ((Number)object).intValue();
                } else {
                    n = connection.addRemoteTunnelWithRandomRemotePort("localhost", localPortBinding.getLocal());
                }
                int targetPort = n;
                HostPort localHostPort = new HostPort("localhost", localPortBinding.getLocal());
                HostPort targetHostPort = new HostPort("localhost", targetPort);
                ((Map)localPortBindings).put(localPortBinding, new ResolvedPortBinding(localHostPort, targetHostPort));
            }
            return sshEnvironment;
        }

        private final void removeFromParts(MultiMap<Path, TargetEnvironment.UploadRoot> parts, TargetEnvironment.UploadRoot root) {
            for (Path path = root.getLocalRootPath(); path != null; path = path.getParent()) {
                parts.remove((Object)path, (Object)root);
            }
        }

        @NotNull
        public final RSyncUtil.IndicatorWrapper createIndicatorWrapper(@NotNull TargetProgressIndicator targetProgressIndicator) {
            Intrinsics.checkNotNullParameter((Object)targetProgressIndicator, (String)"targetProgressIndicator");
            return new RSyncUtil.IndicatorWrapper(targetProgressIndicator){
                final /* synthetic */ TargetProgressIndicator $targetProgressIndicator;
                {
                    this.$targetProgressIndicator = $targetProgressIndicator;
                }

                public boolean isCanceled() {
                    return false;
                }

                public void checkCanceled() {
                }

                public void addText(String text, Key<?> key) {
                    Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                    Intrinsics.checkNotNullParameter(key, (String)"key");
                    this.$targetProgressIndicator.addText(text, key);
                }

                public void finished(int exitCode) {
                    if (exitCode != 0) {
                        Object[] objectArray = new Object[]{exitCode};
                        this.$targetProgressIndicator.stopWithErrorMessage(RemoteSdkBundle.message("exception.message.rsync.upload.failed.with.exit.code.0", objectArray));
                    }
                }
            };
        }

        private final TargetEnvironment.UploadableVolume createUploadableVolume(TargetEnvironment.UploadRoot uploadRoot, SshRemoteEnvironmentRequest request, TargetEnvironment.TargetPath targetRootPath, Platform platform, Project project, ConnectionBuilder connectionBuilder, SshTargetEnvironmentConfiguration targetConfiguration, TargetProgressIndicator targetProgressIndicator, RemoteCredentials credentials, Function1<? super TargetProgressIndicator, ? extends SftpProgressTracker> sftpProgressTrackerFactory) {
            return request.getPublishedVolumes$intellij_remoteRun().contains(uploadRoot) && targetRootPath instanceof TargetEnvironment.TargetPath.Persistent ? (TargetEnvironment.UploadableVolume)new PublishedVolume(platform, uploadRoot.getLocalRootPath(), ((TargetEnvironment.TargetPath.Persistent)targetRootPath).getAbsolutePath()) : (TargetEnvironment.UploadableVolume)this.createSshVolume(uploadRoot, project, connectionBuilder, platform, targetConfiguration, targetProgressIndicator, credentials, sftpProgressTrackerFactory, false);
        }

        private final NewSshVolume createSshVolume(TargetEnvironment.UploadRoot uploadVolume, Project project, ConnectionBuilder connectionBuilder, Platform platform, SshTargetEnvironmentConfiguration targetConfiguration, TargetProgressIndicator targetProgressIndicator, RemoteCredentials credentials, Function1<? super TargetProgressIndicator, ? extends SftpProgressTracker> sftpProgressTrackerFactory, boolean provideDefaultSharedPaths) {
            String string;
            TargetEnvironment.TargetPath targetRootPath = uploadVolume.getTargetRootPath();
            if (targetRootPath instanceof TargetEnvironment.TargetPath.Persistent) {
                string = ((TargetEnvironment.TargetPath.Persistent)targetRootPath).getAbsolutePath();
            } else if (targetRootPath instanceof TargetEnvironment.TargetPath.Temporary) {
                SshTempTargetPathsService sshTempTargetPathsService = SshTempTargetPathsService.getInstance(project);
                Intrinsics.checkNotNullExpressionValue((Object)sshTempTargetPathsService, (String)"getInstance(...)");
                SshTempTargetPathsService service = sshTempTargetPathsService;
                String directory = SshTargetUtilKt.createRemoteDirectory(connectionBuilder, platform, targetConfiguration, service.getTargetPath((TargetEnvironment.TargetPath.Temporary)targetRootPath, uploadVolume.getLocalRootPath(), targetConfiguration), ((TargetEnvironment.TargetPath.Temporary)targetRootPath).getPrefix());
                service.setTargetPath((TargetEnvironment.TargetPath.Temporary)targetRootPath, uploadVolume.getLocalRootPath(), targetConfiguration, directory);
                string = directory;
            } else {
                throw new IllegalStateException("Unexpected targetRootPath " + targetRootPath);
            }
            String targetDirectory = string;
            Object[] objectArray = new Object[]{uploadVolume.getLocalRootPath(), connectionBuilder.getHost(), targetDirectory};
            targetProgressIndicator.addSystemLine(RemoteSdkBundle.message("progress.text.set.up.uploading.volume.file.0.ssh.1.2", objectArray));
            return new NewSshVolume(credentials, platform, sftpProgressTrackerFactory, uploadVolume.getLocalRootPath(), targetDirectory, targetConfiguration.getUseRsync(), project, provideDefaultSharedPaths ? uploadVolume.getLocalRootPath() : null, provideDefaultSharedPaths ? targetDirectory : null);
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final Predicate<File> getSshUploadFileFilter$intellij_remoteRun(@NotNull File localRoot, @Nullable Project project) {
            List list;
            Intrinsics.checkNotNullParameter((Object)localRoot, (String)"localRoot");
            if (project == null) {
                return null;
            }
            VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)localRoot, (boolean)false);
            if (virtualFile == null) {
                return null;
            }
            List<VirtualFile> list2 = this.getExcludedFromProjectChildren(virtualFile, project);
            if (list2 != null) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = list2;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    VirtualFile virtualFile2 = (VirtualFile)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.toNioPath().toFile());
                }
                list = (List)destination$iv$iv;
            } else {
                list = null;
            }
            List result = list;
            return new Predicate<File>(localRoot, result){
                private final FileTypeManager manager;
                final /* synthetic */ File $localRoot;
                final /* synthetic */ List<File> $result;
                {
                    this.$localRoot = $localRoot;
                    this.$result = $result;
                    this.manager = FileTypeManager.getInstance();
                }

                public final FileTypeManager getManager() {
                    return this.manager;
                }

                public boolean test(File file) {
                    Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                    if (Intrinsics.areEqual((Object)file, (Object)this.$localRoot)) {
                        return true;
                    }
                    if (Intrinsics.areEqual((Object)".idea", (Object)file.getName())) {
                        return false;
                    }
                    if (this.$result != null && this.$result.contains(file)) {
                        return false;
                    }
                    return !this.manager.isFileIgnored(file.getName());
                }
            };
        }

        private final List<VirtualFile> getExcludedFromProjectChildren(VirtualFile localRoot, Project project) {
            return (List)ReadAction.compute(() -> Companion.getExcludedFromProjectChildren$lambda$3(project, localRoot));
        }

        private final List<VirtualFile> getAdditionalLibrariesSourceRoots(Project project, VirtualFile localRoot) {
            SmartList roots = new SmartList();
            for (AdditionalLibraryRootsProvider provider : AdditionalLibraryRootsProvider.EP_NAME.getExtensionList()) {
                Collection libraries;
                Intrinsics.checkNotNullExpressionValue((Object)provider.getAdditionalProjectLibraries(project), (String)"getAdditionalProjectLibraries(...)");
                for (SyntheticLibrary library : libraries) {
                    for (VirtualFile sourceRoot : library.getSourceRoots()) {
                        if (!sourceRoot.isValid() || localRoot != null && !VfsUtil.isAncestor((VirtualFile)localRoot, (VirtualFile)sourceRoot, (boolean)false)) continue;
                        roots.add((Object)sourceRoot);
                    }
                }
            }
            return (List)roots;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<String> getRsyncExclusions$intellij_remoteRun(@NotNull File localRoot, boolean shouldUseVirtualFile, @Nullable Project project, @NotNull Collection<String> relativePathsToRetain) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            Object localFileSystem;
            Intrinsics.checkNotNullParameter((Object)localRoot, (String)"localRoot");
            Intrinsics.checkNotNullParameter(relativePathsToRetain, (String)"relativePathsToRetain");
            if (project == null) {
                return CollectionsKt.emptyList();
            }
            VirtualFile virtualFile = null;
            if (shouldUseVirtualFile) {
                virtualFile = VfsUtil.findFileByIoFile((File)localRoot, (boolean)false);
                if (virtualFile == null) {
                    return CollectionsKt.emptyList();
                }
            } else {
                virtualFile = null;
            }
            List result = new ArrayList();
            List<VirtualFile> excluded = this.getExcludedFromProjectChildren(virtualFile, project);
            Collection collection = excluded;
            if (!(collection == null || collection.isEmpty())) {
                String[] stringArray = LocalFileSystem.getInstance();
                Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getInstance(...)");
                localFileSystem = stringArray;
                Path rootPath = localRoot.toPath();
                for (VirtualFile file : excluded) {
                    Path pathToExclude = localFileSystem.getNioPath(file);
                    if (pathToExclude == null || !pathToExclude.startsWith(rootPath)) continue;
                    boolean shouldExclude = true;
                    Path relativePathToExclude = rootPath.relativize(pathToExclude);
                    for (String relativePathToRetain : relativePathsToRetain) {
                        Path pathToRetain = rootPath.resolve(relativePathToRetain);
                        if (!pathToRetain.startsWith(pathToExclude)) continue;
                        shouldExclude = false;
                        break;
                    }
                    if (!shouldExclude) continue;
                    result.add("/" + relativePathToExclude);
                }
            }
            String string = FileTypeManager.getInstance().getIgnoredFilesList();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getIgnoredFilesList(...)");
            localFileSystem = new String[]{";"};
            localFileSystem = StringsKt.split$default((CharSequence)string, (String[])localFileSystem, (boolean)false, (int)0, (int)6, null);
            List list = result;
            boolean $i$f$filter = false;
            Iterator<VirtualFile> iterator = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl = false;
                boolean bl2 = ((CharSequence)it).length() > 0;
                if (!bl2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list.addAll((List)destination$iv$iv);
            result.add(".idea");
            return result;
        }

        public static /* synthetic */ List getRsyncExclusions$intellij_remoteRun$default(Companion companion, File file, boolean bl, Project project, Collection collection, int n, Object object) {
            if ((n & 8) != 0) {
                collection = CollectionsKt.emptyList();
            }
            return companion.getRsyncExclusions$intellij_remoteRun(file, bl, project, collection);
        }

        private static final List getExcludedFromProjectChildren$lambda$3(Project $project, VirtualFile $localRoot) {
            List result = new ArrayList();
            List<VirtualFile> additionalLibraries = null;
            for (Module module : ModuleManager.Companion.getInstance($project).getModules()) {
                for (VirtualFile excludeRoot : ModuleRootManager.getInstance((Module)module).getExcludeRoots()) {
                    if ($localRoot != null && !VfsUtil.isAncestor((VirtualFile)$localRoot, (VirtualFile)excludeRoot, (boolean)true)) continue;
                    if (additionalLibraries == null) {
                        additionalLibraries = Companion.getAdditionalLibrariesSourceRoots($project, $localRoot);
                    }
                    boolean shouldExclude = true;
                    for (VirtualFile lib : additionalLibraries) {
                        if (!Intrinsics.areEqual((Object)lib, (Object)excludeRoot)) continue;
                        shouldExclude = false;
                        break;
                    }
                    if (!shouldExclude) continue;
                    Intrinsics.checkNotNull((Object)excludeRoot);
                    result.add(excludeRoot);
                }
            }
            return result.isEmpty() ? null : result;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

