/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.execution.header;

import com.intellij.httpClient.http.request.HttpRequestPsiFactory;
import com.intellij.httpClient.http.request.HttpRequestPsiFile;
import com.intellij.httpClient.http.request.HttpRequestPsiUtils;
import com.intellij.httpClient.http.request.psi.HttpHeaderField;
import com.intellij.httpClient.http.request.psi.HttpHeaderFieldName;
import com.intellij.httpClient.http.request.psi.HttpHeaderFieldValue;
import com.intellij.httpClient.http.request.psi.HttpRequest;
import com.intellij.httpClient.http.request.psi.HttpRequestElementTypes;
import com.intellij.httpClient.http.request.psi.HttpRequestTokenTypeSets;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.microservices.http.HttpHeaderDocumentation;
import com.intellij.microservices.http.HttpHeadersDictionary;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiWhiteSpace;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HttpHeadersDocumentationProvider
implements DocumentationProvider {
    @Nullable
    public List<String> getUrlFor(PsiElement element, PsiElement originalElement) {
        HttpHeaderDocumentation doc = HttpHeadersDocumentationProvider.getDocumentation(element);
        if (doc != null) {
            return Collections.singletonList(doc.getUrl());
        }
        return null;
    }

    @Nullable
    @Nls
    public String generateDoc(PsiElement element, @Nullable PsiElement originalElement) {
        HttpHeaderDocumentation doc = HttpHeadersDocumentationProvider.getDocumentation(element);
        if (doc != null) {
            return doc.generateDoc();
        }
        return null;
    }

    @Nullable
    private static HttpHeaderDocumentation getDocumentation(PsiElement element) {
        String name;
        if (element instanceof HttpHeaderField && StringUtil.isNotEmpty((String)(name = ((HttpHeaderField)element).getName()))) {
            return HttpHeadersDictionary.getDocumentation((String)name);
        }
        return null;
    }

    @Nullable
    public PsiElement getDocumentationElementForLookupItem(PsiManager psiManager, Object object, PsiElement element) {
        if (object instanceof HttpHeaderDocumentation) {
            Project project;
            String name = ((HttpHeaderDocumentation)object).getName();
            Project project2 = project = psiManager != null ? psiManager.getProject() : null;
            if (StringUtil.isNotEmpty((String)name) && project != null) {
                HttpRequestPsiFile file = HttpRequestPsiFactory.createDummyFile(project, "http://127.0.0.1\n" + name);
                HttpRequest newRequest = HttpRequestPsiUtils.getFirstRequest((PsiFile)file);
                assert (newRequest != null);
                return (PsiElement)newRequest.getHeaderFieldList().get(0);
            }
            return element;
        }
        return null;
    }

    @Nullable
    public PsiElement getCustomDocumentationElement(@NotNull Editor editor2, @NotNull PsiFile file, @Nullable PsiElement contextElement, int targetOffset) {
        if (editor2 == null) {
            HttpHeadersDocumentationProvider.$$$reportNull$$$0(0);
        }
        if (file == null) {
            HttpHeadersDocumentationProvider.$$$reportNull$$$0(1);
        }
        if (file instanceof HttpRequestPsiFile && contextElement != null) {
            while (contextElement instanceof PsiWhiteSpace || contextElement != null && HttpRequestPsiUtils.isOfType(contextElement, HttpRequestElementTypes.COLON)) {
                contextElement = contextElement.getPrevSibling();
            }
            if (contextElement != null && HttpRequestPsiUtils.isOfTypes(contextElement, HttpRequestTokenTypeSets.HEADER)) {
                contextElement = contextElement.getParent();
            }
            if (contextElement instanceof HttpHeaderFieldName || contextElement instanceof HttpHeaderFieldValue) {
                return contextElement.getParent();
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
        }
        objectArray[1] = "com/intellij/httpClient/execution/header/HttpHeadersDocumentationProvider";
        objectArray[2] = "getCustomDocumentationElement";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

