/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.syntaxSelection;

import com.intellij.codeInsight.editorActions.ExtendWordSelectionHandlerBase;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.BasicJavaScriptStubElementTypes;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UnfairTextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtilKt;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J.\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u0012"}, d2={"Lcom/intellij/lang/javascript/syntaxSelection/JavaScriptStringTemplateSelectioner;", "Lcom/intellij/codeInsight/editorActions/ExtendWordSelectionHandlerBase;", "<init>", "()V", "canSelect", "", "e", "Lcom/intellij/psi/PsiElement;", "select", "", "Lcom/intellij/openapi/util/TextRange;", "editorText", "", "cursorOffset", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "getStringTemplateExpression", "intellij.javascript.frontback.impl"})
public final class JavaScriptStringTemplateSelectioner
extends ExtendWordSelectionHandlerBase {
    public boolean canSelect(@NotNull PsiElement e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        ASTNode aSTNode = e.getNode();
        if (aSTNode == null || (aSTNode = aSTNode.getElementType()) == null) {
            return false;
        }
        ASTNode elementType = aSTNode;
        return elementType == BasicJavaScriptStubElementTypes.STRING_TEMPLATE_EXPRESSION || elementType == JSElementTypes.TAGGED_TEMPLATE_EXPRESSION;
    }

    @NotNull
    public List<TextRange> select(@NotNull PsiElement e, @NotNull CharSequence editorText, int cursorOffset, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)editorText, (String)"editorText");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        PsiElement target = e;
        List result = new ArrayList();
        if (PsiTreeUtilKt.getElementType((PsiElement)e.getParent()) == JSElementTypes.TAGGED_TEMPLATE_EXPRESSION) {
            TextRange textRange = e.getParent().getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
            result.add(textRange);
        }
        if (PsiTreeUtilKt.getElementType((PsiElement)e) == JSElementTypes.TAGGED_TEMPLATE_EXPRESSION) {
            TextRange textRange = e.getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
            result.add(textRange);
            PsiElement psiElement = this.getStringTemplateExpression(e);
            if (psiElement == null) {
                return result;
            }
            target = psiElement;
        }
        TextRange stringRange = target.getTextRange();
        Intrinsics.checkNotNull((Object)stringRange);
        result.add(stringRange);
        result.add(new UnfairTextRange(stringRange.getStartOffset() + 1, stringRange.getEndOffset() - 1));
        ASTNode lBracket = target.getNode().findChildByType(JSTokenTypes.DOLLAR);
        ASTNode rBracket = target.getNode().findChildByType(JSTokenTypes.RBRACE);
        while (lBracket != null && rBracket != null) {
            result.add(new UnfairTextRange(lBracket.getTextRange().getStartOffset(), rBracket.getTextRange().getEndOffset()));
            lBracket = target.getNode().findChildByType(JSTokenTypes.DOLLAR, rBracket);
            rBracket = target.getNode().findChildByType(JSTokenTypes.RBRACE, lBracket);
        }
        return result;
    }

    private final PsiElement getStringTemplateExpression(PsiElement e) {
        ASTNode aSTNode = e.getNode().findChildByType(BasicJavaScriptStubElementTypes.STRING_TEMPLATE_EXPRESSION);
        return aSTNode != null ? aSTNode.getPsi() : null;
    }
}

