/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base.introspector.jdbc.wrappers;

import com.intellij.database.dialects.base.introspector.jdbc.wrappers.ClosableIt;
import com.intellij.database.dialects.base.introspector.jdbc.wrappers.DatabaseMetaDataWrapper;
import com.intellij.database.dialects.base.introspector.jdbc.wrappers.MetaDataUtil;
import com.intellij.database.remote.jdbc.RemoteResultSet;
import com.intellij.openapi.util.text.StringUtil;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.sql.SQLException;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TableKeyColumnIt
extends ClosableIt.ResultSetClosableIt<DatabaseMetaDataWrapper.TableKeyColumn> {
    private final IntSet myPoses;
    private final DatabaseMetaDataWrapper.Table myTable;

    public TableKeyColumnIt(@Nullable RemoteResultSet rs, @NotNull DatabaseMetaDataWrapper.Table table) throws SQLException {
        if (table == null) {
            TableKeyColumnIt.$$$reportNull$$$0(0);
        }
        super(rs);
        this.myPoses = new IntOpenHashSet();
        this.myTable = table;
    }

    @Override
    @NotNull
    protected DatabaseMetaDataWrapper.TableKeyColumn createStorage() {
        return new DatabaseMetaDataWrapper.TableKeyColumn(new DatabaseMetaDataWrapper.TableKey(this.myTable, ""));
    }

    @Override
    protected DatabaseMetaDataWrapper.TableKeyColumn calcValue() {
        DatabaseMetaDataWrapper.TableKeyColumn res = (DatabaseMetaDataWrapper.TableKeyColumn)this.getStorageToFill();
        try {
            String table = this.myRs.getString("TABLE_NAME", 3);
            if (StringUtil.isEmpty((String)table)) {
                return (DatabaseMetaDataWrapper.TableKeyColumn)this.skip();
            }
            String cat = this.myRs.getString("TABLE_CAT", 1);
            String schema = StringUtil.notNullize((String)this.myRs.getString("TABLE_SCHEM", 2), (String)this.myTable.schema.schema);
            if (!Objects.equals(schema, this.myTable.schema.schema) || !Objects.equals(table, this.myTable.name)) {
                return (DatabaseMetaDataWrapper.TableKeyColumn)this.skip();
            }
            res.name = this.myRs.getString("COLUMN_NAME", 4);
            res.position = this.myRs.getShort("KEY_SEQ", 5);
            while (this.myPoses.contains((int)res.position)) {
                res.position = (short)(res.position + 1);
            }
            this.myPoses.add((int)res.position);
            res.key.name = this.myRs.getString("PK_NAME", 6);
            res.name = this.myRs.getString("COLUMN_NAME", 4);
            res.key.primary = true;
        }
        catch (SQLException e) {
            this.onError(res, e);
            return (DatabaseMetaDataWrapper.TableKeyColumn)this.skip();
        }
        return res;
    }

    @Override
    public void onError(DatabaseMetaDataWrapper.TableKeyColumn cur, SQLException e) {
        String title = cur == null ? null : MetaDataUtil.qName(cur.key.table.schema.database, cur.key.table.schema.schema, cur.key.table.name);
        this.addError(title, e);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dialects/base/introspector/jdbc/wrappers/TableKeyColumnIt", "<init>"));
    }

    public static class Grouping
    extends ClosableIt.GroupingItImpl<DatabaseMetaDataWrapper.TableKey, DatabaseMetaDataWrapper.TableKeyColumn, DatabaseMetaDataWrapper.TableKeyColumn> {
        protected Grouping(@NotNull ClosableIt<DatabaseMetaDataWrapper.TableKeyColumn> delegate) {
            if (delegate == null) {
                Grouping.$$$reportNull$$$0(0);
            }
            super(delegate);
        }

        @Override
        @NotNull
        protected ClosableIt.GroupingItImpl.GroupIt<DatabaseMetaDataWrapper.TableKeyColumn> createGroupIt(ClosableIt<DatabaseMetaDataWrapper.TableKeyColumn> it) {
            final String keyName = ((DatabaseMetaDataWrapper.TableKeyColumn)it.current()).key.name;
            return new ClosableIt.GroupingItImpl.GroupIt<DatabaseMetaDataWrapper.TableKeyColumn>(it){

                @Override
                protected boolean isInGroup(DatabaseMetaDataWrapper.TableKeyColumn item) {
                    return Objects.equals(keyName, item.key.name);
                }
            };
        }

        @Override
        protected DatabaseMetaDataWrapper.TableKey getItem(ClosableIt<DatabaseMetaDataWrapper.TableKeyColumn> it) {
            return ((DatabaseMetaDataWrapper.TableKeyColumn)it.current()).key;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/intellij/database/dialects/base/introspector/jdbc/wrappers/TableKeyColumnIt$Grouping", "<init>"));
        }
    }
}

