/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mssql;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.connection.throwable.info.ErrorInfo;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dialects.BaseDatabaseErrorHandler;
import com.intellij.database.dialects.DatabaseFixFactory;
import com.intellij.database.dialects.mssql.MsUtils;
import com.intellij.database.dialects.mssql.TsqlErrorHandler;
import com.intellij.database.remote.jdbc.SQLExceptionWithProperties;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Function;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MsErrorHandler
extends TsqlErrorHandler {
    public MsErrorHandler(@NotNull Dbms dbms) {
        if (dbms == null) {
            MsErrorHandler.$$$reportNull$$$0(0);
        }
        super(dbms);
    }

    @Override
    @NotNull
    protected BaseDatabaseErrorHandler.OffsetInfoBuilder getOffsetInfoBuilder(@NotNull ErrorInfo errorInfo) {
        if (errorInfo == null) {
            MsErrorHandler.$$$reportNull$$$0(1);
        }
        BaseDatabaseErrorHandler.OffsetInfoBuilder builder = super.getOffsetInfoBuilder(errorInfo);
        Map<String, Serializable> properties2 = MsErrorHandler.getProperties(errorInfo.getOriginalThrowable());
        if (properties2 == null) {
            BaseDatabaseErrorHandler.OffsetInfoBuilder offsetInfoBuilder = builder;
            if (offsetInfoBuilder == null) {
                MsErrorHandler.$$$reportNull$$$0(2);
            }
            return offsetInfoBuilder;
        }
        Integer lineNumber = (Integer)SQLExceptionWithProperties.LINE_NUMBER.get(properties2);
        BaseDatabaseErrorHandler.OffsetInfoBuilder offsetInfoBuilder = lineNumber == null ? builder : builder.defaultLine(lineNumber);
        if (offsetInfoBuilder == null) {
            MsErrorHandler.$$$reportNull$$$0(3);
        }
        return offsetInfoBuilder;
    }

    @Override
    @NotNull
    protected ErrorInfo getErrorInfo(@Nullable LocalDataSource dataSource, @NotNull Throwable original, @NotNull Throwable cause) {
        if (original == null) {
            MsErrorHandler.$$$reportNull$$$0(4);
        }
        if (cause == null) {
            MsErrorHandler.$$$reportNull$$$0(5);
        }
        if (MsErrorHandler.getErrorCode(cause) == 40852) {
            return new MsSecureServerErrorInfo(dataSource, original, cause);
        }
        if (MsErrorHandler.isMsJbDriverErrorInfo(dataSource, original)) {
            if (cause instanceof SQLException) {
                return new MsJbDriverSQLErrorInfo(dataSource, original, cause);
            }
            return new MsJbDriverUnexpectedErrorInfo(dataSource, original, cause);
        }
        ErrorInfo errorInfo = super.getErrorInfo(dataSource, original, cause);
        if (errorInfo == null) {
            MsErrorHandler.$$$reportNull$$$0(6);
        }
        return errorInfo;
    }

    private static boolean isMsJbDriverErrorInfo(@Nullable LocalDataSource dataSource, @NotNull Throwable original) {
        if (original == null) {
            MsErrorHandler.$$$reportNull$$$0(7);
        }
        return dataSource != null && MsUtils.isJbMsDriver(dataSource.getDatabaseDriver()) && ExceptionUtil.getThrowableText((Throwable)original).contains("com.jetbrains.jdbc");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorInfo";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/mssql/MsErrorHandler";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cause";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/mssql/MsErrorHandler";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getOffsetInfoBuilder";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getOffsetInfoBuilder";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getErrorInfo";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isMsJbDriverErrorInfo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 6 -> new IllegalStateException(string);
        };
    }

    private static class MsSecureServerErrorInfo
    extends BaseDatabaseErrorHandler.DatabaseErrorInfo {
        MsSecureServerErrorInfo(@Nullable LocalDataSource dataSource, @NotNull Throwable original, @NotNull Throwable cause) {
            if (original == null) {
                MsSecureServerErrorInfo.$$$reportNull$$$0(0);
            }
            if (cause == null) {
                MsSecureServerErrorInfo.$$$reportNull$$$0(1);
            }
            super(dataSource, original, cause);
        }

        @Override
        protected void fillInfoData(@Nls @NotNull StringBuilder sb, @NotNull List<ErrorInfo.Fix> fixes) {
            if (sb == null) {
                MsSecureServerErrorInfo.$$$reportNull$$$0(2);
            }
            if (fixes == null) {
                MsSecureServerErrorInfo.$$$reportNull$$$0(3);
            }
            MsSecureServerErrorInfo.appendGenericMessage(this.myOriginal, sb);
            LocalDataSource dataSource = this.getDataSource();
            String url = dataSource == null ? null : dataSource.getUrl();
            String orig = "database.windows.net";
            String repl = "secure.database.windows.net";
            if (url != null && url.contains(orig)) {
                MsSecureServerErrorInfo.addFix(fixes, (Function<? super DatabaseFixFactory, ? extends ErrorInfo.Fix>)((Function)fac -> fac.setUrl(dataSource, DatabaseBundle.message("switch.to.secure.database.windows.net", new Object[0]), url.replace(orig, repl))));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "original";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cause";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sb";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fixes";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dialects/mssql/MsErrorHandler$MsSecureServerErrorInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fillInfoData";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MsJbDriverSQLErrorInfo
    extends BaseDatabaseErrorHandler.SQLErrorInfo {
        MsJbDriverSQLErrorInfo(@NotNull LocalDataSource dataSource, @NotNull Throwable original, Throwable cause) {
            if (original == null) {
                MsJbDriverSQLErrorInfo.$$$reportNull$$$0(0);
            }
            if (cause == null) {
                MsJbDriverSQLErrorInfo.$$$reportNull$$$0(1);
            }
            super(dataSource, original, cause);
        }

        @Override
        protected void logIfNeeded() {
            this.LOG.info(this.myOriginal);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "original";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "cause";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/dialects/mssql/MsErrorHandler$MsJbDriverSQLErrorInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MsJbDriverUnexpectedErrorInfo
    extends BaseDatabaseErrorHandler.DatabaseErrorInfo {
        MsJbDriverUnexpectedErrorInfo(@Nullable LocalDataSource dataSource, @NotNull Throwable original, @NotNull Throwable cause) {
            if (original == null) {
                MsJbDriverUnexpectedErrorInfo.$$$reportNull$$$0(0);
            }
            if (cause == null) {
                MsJbDriverUnexpectedErrorInfo.$$$reportNull$$$0(1);
            }
            super(dataSource, original, cause);
        }

        @Override
        protected void fillInfoData(@Nls @NotNull StringBuilder sb, @NotNull List<ErrorInfo.Fix> fixes) {
            if (sb == null) {
                MsJbDriverUnexpectedErrorInfo.$$$reportNull$$$0(2);
            }
            if (fixes == null) {
                MsJbDriverUnexpectedErrorInfo.$$$reportNull$$$0(3);
            }
            MsJbDriverUnexpectedErrorInfo.appendGenericMessage(this.myOriginal, sb);
        }

        @Override
        protected void logIfNeeded() {
            this.LOG.error(this.myOriginal);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "original";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cause";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sb";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fixes";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dialects/mssql/MsErrorHandler$MsJbDriverUnexpectedErrorInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fillInfoData";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

