/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mssql.generator.producers;

import com.intellij.database.dialects.base.generator.BaseProducer;
import com.intellij.database.dialects.base.generator.ScriptingContext;
import com.intellij.database.dialects.base.generator.producers.CreateTable;
import com.intellij.database.dialects.mssql.generator.MsScriptGeneratorHelperKt;
import com.intellij.database.dialects.mssql.generator.producers.MsTableProducersKt;
import com.intellij.database.dialects.mssql.model.MsDataSpace;
import com.intellij.database.dialects.mssql.model.MsFileGroup;
import com.intellij.database.dialects.mssql.model.MsPartitionOwner;
import com.intellij.database.dialects.mssql.model.MsSchema;
import com.intellij.database.dialects.mssql.model.MsTable;
import com.intellij.database.dialects.mssql.model.MsTableColumn;
import com.intellij.database.dialects.mssql.model.MsTablePartition;
import com.intellij.database.dialects.mssql.model.MsView;
import com.intellij.database.dialects.mssql.model.MsViewColumn;
import com.intellij.database.dialects.mssql.model.properties.MsLedgerKind;
import com.intellij.database.dialects.mssql.model.properties.MsTemporalTableKind;
import com.intellij.database.dialects.mssql.model.properties.MsTimeUnit;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.families.ModNamingIdentifyingFamily;
import com.intellij.database.model.families.PositioningNamingFamily;
import com.intellij.database.model.properties.CompositeText;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\b\u0010\u000e\u001a\u00020\tH\u0014J\b\u0010\u000f\u001a\u00020\tH\u0014J\b\u0010\u0010\u001a\u00020\tH\u0002J\b\u0010\u0011\u001a\u00020\tH\u0002J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\u0013H\u0002J\u0018\u0010\u0014\u001a\u00020\t*\u00060\u0015j\u0002`\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\b\u0010\u0019\u001a\u00020\rH\u0002\u00a8\u0006\u001a"}, d2={"Lcom/intellij/database/dialects/mssql/generator/producers/MsCreateTable;", "Lcom/intellij/database/dialects/base/generator/producers/CreateTable;", "Lcom/intellij/database/dialects/mssql/model/MsTable;", "context", "Lcom/intellij/database/dialects/base/generator/ScriptingContext;", "element", "<init>", "(Lcom/intellij/database/dialects/base/generator/ScriptingContext;Lcom/intellij/database/dialects/mssql/model/MsTable;)V", "produceComment", "", "exists", "", "comment", "", "generateAdditionalTableItems", "produceFooter", "produceTextImageOnClause", "produceFileStreamOnClause", "generateTableOptions", "", "appendLedgerViewClause", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "ledgerView", "Lcom/intellij/database/dialects/mssql/model/MsView;", "generateSystemVersioningOption", "intellij.database.dialects.mssql"})
@SourceDebugExtension(value={"SMAP\nMsTableProducers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MsTableProducers.kt\ncom/intellij/database/dialects/mssql/generator/producers/MsCreateTable\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ScriptingContext.kt\ncom/intellij/database/dialects/base/generator/ScriptingContext$NewCodingAdapter\n*L\n1#1,243:1\n1#2:244\n1#2:246\n1#2:273\n1#2:284\n250#3:245\n254#3:247\n241#3,14:248\n226#3,10:262\n250#3:272\n254#3:274\n241#3,8:275\n250#3:283\n254#3:285\n241#3,8:286\n*S KotlinDebug\n*F\n+ 1 MsTableProducers.kt\ncom/intellij/database/dialects/mssql/generator/producers/MsCreateTable\n*L\n29#1:246\n59#1:273\n67#1:284\n29#1:245\n29#1:247\n29#1:248,14\n45#1:262,10\n59#1:272\n59#1:274\n59#1:275,8\n67#1:283\n67#1:285\n67#1:286,8\n*E\n"})
public final class MsCreateTable
extends CreateTable<MsTable> {
    public MsCreateTable(@NotNull ScriptingContext context, @NotNull MsTable element) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super(context, (BasicTable)element);
    }

    @Override
    public void produceComment(boolean exists, @Nullable String comment) {
        MsScriptGeneratorHelperKt.msAlterComment(this, exists, comment);
    }

    @Override
    protected void generateAdditionalTableItems() {
        MsTableColumn startColumn = ((MsTable)this.getElement()).getPeriodStartColumn();
        MsTableColumn endColumn = ((MsTable)this.getElement()).getPeriodEndColumn();
        if (startColumn != null || endColumn != null) {
            this.sqlClause((Function1<? super ScriptingContext.NewCodingAdapter, Unit>)((Function1)arg_0 -> MsCreateTable.generateAdditionalTableItems$lambda$0(startColumn, endColumn, arg_0)));
        }
    }

    @Override
    protected void produceFooter() {
        MsTableProducersKt.produceOnDataSpaceClause(this, (MsPartitionOwner)this.getElement());
        this.produceTextImageOnClause();
        this.produceFileStreamOnClause();
        List<String> options = this.generateTableOptions();
        if (!((Collection)options).isEmpty()) {
            this.sqlClause((Function1<? super ScriptingContext.NewCodingAdapter, Unit>)((Function1)arg_0 -> MsCreateTable.produceFooter$lambda$2(options, arg_0)));
        }
    }

    private final void produceTextImageOnClause() {
        MsFileGroup msFileGroup = ((MsTable)this.getElement()).getLobDataSpace();
        if (msFileGroup == null) {
            return;
        }
        MsFileGroup lobDataSpace = msFileGroup;
        if (lobDataSpace.isDefaultGroup()) {
            return;
        }
        this.sqlClause((Function1<? super ScriptingContext.NewCodingAdapter, Unit>)((Function1)arg_0 -> MsCreateTable.produceTextImageOnClause$lambda$3(lobDataSpace, arg_0)));
    }

    private final void produceFileStreamOnClause() {
        MsDataSpace msDataSpace = ((MsTable)this.getElement()).getFileStreamDataSpace();
        if (msDataSpace == null) {
            return;
        }
        MsDataSpace fsDataSpace = msDataSpace;
        if (fsDataSpace instanceof MsFileGroup && ((MsFileGroup)fsDataSpace).isDefaultGroup()) {
            return;
        }
        this.sqlClause((Function1<? super ScriptingContext.NewCodingAdapter, Unit>)((Function1)arg_0 -> MsCreateTable.produceFileStreamOnClause$lambda$4(fsDataSpace, arg_0)));
    }

    private final List<String> generateTableOptions() {
        Object object;
        SmartList options = new SmartList();
        MsLedgerKind ledgerKind = ((MsTable)this.getElement()).getLedgerKind();
        if (ledgerKind != null && ledgerKind.isLedgerTable()) {
            Object ledgerView;
            CharSequence charSequence;
            if (ledgerKind == MsLedgerKind.UPDATABLE_LEDGER_TABLE) {
                ((Collection)options).add(this.generateSystemVersioningOption());
            }
            Collection collection = (Collection)options;
            StringBuilder $this$generateTableOptions_u24lambda_u246 = charSequence = new StringBuilder();
            boolean bl = false;
            $this$generateTableOptions_u24lambda_u246.append("ledger = on (");
            MsView msView = ((MsTable)this.getElement()).getLedgerView();
            if (msView != null) {
                object = msView;
                MsView it = object;
                boolean bl2 = false;
                v1 = !Intrinsics.areEqual((Object)it.getName(), (Object)(((MsTable)this.getElement()).getName() + "_Ledger")) ? object : null;
            } else {
                v1 = ledgerView = null;
            }
            if (ledgerView != null) {
                this.appendLedgerViewClause($this$generateTableOptions_u24lambda_u246, (MsView)ledgerView);
                $this$generateTableOptions_u24lambda_u246.append(", ");
            }
            switch (WhenMappings.$EnumSwitchMapping$0[ledgerKind.ordinal()]) {
                case 1: {
                    Object object2 = $this$generateTableOptions_u24lambda_u246.append("append_only = off");
                    break;
                }
                case 2: {
                    Object object2 = $this$generateTableOptions_u24lambda_u246.append("append_only = on");
                    break;
                }
                default: {
                    Object object2 = Unit.INSTANCE;
                }
            }
            $this$generateTableOptions_u24lambda_u246.append(")");
            charSequence = charSequence.toString();
            collection.add(charSequence);
        } else if (((MsTable)this.getElement()).getTemporalKind() == MsTemporalTableKind.SYSTEM_VERSIONED_TEMPORAL_TABLE) {
            ((Collection)options).add(this.generateSystemVersioningOption());
        }
        MsTableColumn dataRetentionFilterColumn = ((MsTable)this.getElement()).getDataRetentionFilterColumn();
        if (dataRetentionFilterColumn != null) {
            int period = ((MsTable)this.getElement()).getDataRetentionPeriod();
            MsTimeUnit msTimeUnit = ((MsTable)this.getElement()).getDataRetentionUnit();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)msTimeUnit), (String)"getDataRetentionUnit(...)");
            MsTimeUnit unit = msTimeUnit;
            Collection collection = (Collection)options;
            Object $this$generateTableOptions_u24lambda_u247 = object = new StringBuilder();
            boolean bl = false;
            ((StringBuilder)$this$generateTableOptions_u24lambda_u247).append("data_deletion = on (");
            StringBuilder stringBuilder = ((StringBuilder)$this$generateTableOptions_u24lambda_u247).append("filter_column = ");
            String string = BaseProducer.quote$default(this, dataRetentionFilterColumn, null, 2, null);
            if (string == null) {
                string = "???";
            }
            stringBuilder.append(string);
            ((StringBuilder)$this$generateTableOptions_u24lambda_u247).append(", ");
            ((StringBuilder)$this$generateTableOptions_u24lambda_u247).append("retention_period = ");
            if (unit != MsTimeUnit.INFINITE) {
                String string2;
                ((StringBuilder)$this$generateTableOptions_u24lambda_u247).append(period);
                ((StringBuilder)$this$generateTableOptions_u24lambda_u247).append(" ");
                if (period == 1) {
                    string2 = unit.getSql();
                } else {
                    String string3 = StringUtil.pluralize((String)unit.getSql());
                    string2 = string3;
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"pluralize(...)");
                }
                v8 = ((StringBuilder)$this$generateTableOptions_u24lambda_u247).append(string2);
            } else {
                v8 = ((StringBuilder)$this$generateTableOptions_u24lambda_u247).append(unit.getSql());
            }
            ((StringBuilder)$this$generateTableOptions_u24lambda_u247).append(")");
            object = ((StringBuilder)object).toString();
            collection.add(object);
        }
        ModNamingIdentifyingFamily<? extends MsTablePartition> modNamingIdentifyingFamily = ((MsTable)this.getElement()).getPartitions();
        Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily, (String)"getPartitions(...)");
        MsTableProducersKt.appendPartitionRangeOptions(CollectionsKt.toList((Iterable)modNamingIdentifyingFamily), (List)options);
        return (List)options;
    }

    private final void appendLedgerViewClause(StringBuilder $this$appendLedgerViewClause, MsView ledgerView) {
        MsViewColumn msViewColumn;
        MsViewColumn msViewColumn2;
        MsViewColumn msViewColumn3;
        MsViewColumn it;
        MsViewColumn msViewColumn4;
        String string;
        MsSchema msSchema = ledgerView.getParent();
        $this$appendLedgerViewClause.append("ledger_view = " + (msSchema != null && (string = BaseProducer.currentScopeName$default(this, msSchema, null, false, 3, null)) != null ? string : "???") + "." + BaseProducer.currentScopeName$default(this, ledgerView, null, false, 3, null));
        PositioningNamingFamily positioningNamingFamily = ledgerView.getColumns();
        Intrinsics.checkNotNullExpressionValue((Object)positioningNamingFamily, (String)"getColumns(...)");
        List columns = CollectionsKt.toList((Iterable)positioningNamingFamily);
        int count = columns.size();
        SmartList clauses = new SmartList();
        MsViewColumn msViewColumn5 = (MsViewColumn)CollectionsKt.getOrNull((List)columns, (int)(count - 4));
        if (msViewColumn5 != null) {
            it = msViewColumn4 = msViewColumn5;
            boolean bl = false;
            msViewColumn5 = !Intrinsics.areEqual((Object)it.getName(), (Object)"ledger_transaction_id") ? msViewColumn4 : null;
            if (msViewColumn5 != null) {
                it = msViewColumn5;
                boolean bl2 = false;
                ((Collection)clauses).add("\t\ttransaction_id_column_name = " + BaseProducer.quote$default(this, it, null, 2, null));
            }
        }
        if ((msViewColumn3 = (MsViewColumn)CollectionsKt.getOrNull((List)columns, (int)(count - 3))) != null) {
            it = msViewColumn4 = msViewColumn3;
            boolean bl = false;
            msViewColumn3 = !Intrinsics.areEqual((Object)it.getName(), (Object)"ledger_sequence_number") ? msViewColumn4 : null;
            if (msViewColumn3 != null) {
                it = msViewColumn3;
                boolean bl3 = false;
                ((Collection)clauses).add("\t\tsequence_number_column_name = " + BaseProducer.quote$default(this, it, null, 2, null));
            }
        }
        if ((msViewColumn2 = (MsViewColumn)CollectionsKt.getOrNull((List)columns, (int)(count - 2))) != null) {
            it = msViewColumn4 = msViewColumn2;
            boolean bl = false;
            msViewColumn2 = !Intrinsics.areEqual((Object)it.getName(), (Object)"ledger_operation_type") ? msViewColumn4 : null;
            if (msViewColumn2 != null) {
                it = msViewColumn2;
                boolean bl4 = false;
                ((Collection)clauses).add("\t\toperation_type_column_name = " + BaseProducer.quote$default(this, it, null, 2, null));
            }
        }
        if ((msViewColumn = (MsViewColumn)CollectionsKt.getOrNull((List)columns, (int)(count - 1))) != null) {
            it = msViewColumn4 = msViewColumn;
            boolean bl = false;
            msViewColumn = !Intrinsics.areEqual((Object)it.getName(), (Object)"ledger_operation_type_desc") ? msViewColumn4 : null;
            if (msViewColumn != null) {
                it = msViewColumn;
                boolean bl5 = false;
                ((Collection)clauses).add("\t\toperation_type_desc_column_name = " + BaseProducer.quote$default(this, it, null, 2, null));
            }
        }
        if (!((Collection)clauses).isEmpty()) {
            CollectionsKt.joinTo$default((Iterable)((Iterable)clauses), (Appendable)$this$appendLedgerViewClause, (CharSequence)",\n", (CharSequence)"(\n", (CharSequence)"\n\t)", (int)0, null, null, (int)112, null);
        }
    }

    private final String generateSystemVersioningOption() {
        MsTable ht;
        StringBuilder stringBuilder;
        StringBuilder $this$generateSystemVersioningOption_u24lambda_u2417 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$generateSystemVersioningOption_u24lambda_u2417.append("system_versioning = on");
        MsTable msTable = ((MsTable)this.getElement()).getHistoryTable();
        if (msTable != null) {
            MsTable msTable2;
            MsTable it = msTable2 = msTable;
            boolean bl2 = false;
            v1 = !it.isNameSurrogate() ? msTable2 : null;
        } else {
            v1 = ht = null;
        }
        if (ht != null) {
            $this$generateSystemVersioningOption_u24lambda_u2417.append(" (history_table = " + BaseProducer.currentScopeName$default(this, ht, null, true, 1, null) + ")");
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit generateAdditionalTableItems$lambda$0(MsTableColumn $startColumn, MsTableColumn $endColumn, ScriptingContext.NewCodingAdapter $this$sqlClause) {
        String string;
        void this_$iv$iv$iv;
        ScriptingContext.NewCodingAdapter this_$iv$iv;
        String string2;
        ScriptingContext.NewCodingAdapter this_$iv;
        Intrinsics.checkNotNullParameter((Object)$this$sqlClause, (String)"$this$sqlClause");
        ScriptingContext.NewCodingAdapter newCodingAdapter = $this$sqlClause.minus($this$sqlClause.unaryPlus("period for system_time"), "(");
        ScriptingContext.NewCodingAdapter newCodingAdapter2 = $this$sqlClause;
        BasicElement element$iv = $startColumn;
        boolean $i$f$scr = false;
        void var6_6 = this_$iv;
        BasicElement basicElement = element$iv;
        if (basicElement != null) {
            BasicElement it$iv = basicElement;
            boolean bl = false;
            string2 = ScriptingContext.NewCodingAdapter.quote$default(this_$iv, it$iv, null, 2, null);
        } else {
            string2 = null;
        }
        String quotedName$iv$iv = string2;
        boolean $i$f$name = false;
        void bl = this_$iv$iv;
        String text$iv$iv$iv = quotedName$iv$iv;
        boolean $i$f$orError = false;
        ScriptingContext.NewCodingAdapter newCodingAdapter3 = $this$sqlClause.minus($this$sqlClause.minus(newCodingAdapter, (Function0<? extends Object>)((Function0)new Function0<Unit>(text$iv$iv$iv, (ScriptingContext.NewCodingAdapter)this_$iv$iv$iv){
            final /* synthetic */ String $text;
            final /* synthetic */ ScriptingContext.NewCodingAdapter this$0;
            {
                this.$text = $text;
                this.this$0 = $receiver;
            }

            public final void invoke() {
                if (this.$text != null) {
                    ScriptingContext.NewCodingAdapter.appendSimple$default(this.this$0, this.$text, null, null, 6, null);
                } else {
                    CompositeText.Kind kind = null;
                    CharSequence charSequence = "???";
                    ScriptingContext.NewCodingAdapter newCodingAdapter = this.this$0;
                    boolean bl = false;
                    String string = "unknown name";
                    ScriptingContext.NewCodingAdapter.appendSimple$default(newCodingAdapter, charSequence, kind, string, 2, null);
                }
            }
        })), ",");
        this_$iv = $this$sqlClause;
        element$iv = $endColumn;
        $i$f$scr = false;
        this_$iv$iv = this_$iv;
        BasicElement basicElement2 = element$iv;
        if (basicElement2 != null) {
            BasicElement it$iv = basicElement2;
            boolean bl2 = false;
            string = ScriptingContext.NewCodingAdapter.quote$default(this_$iv, it$iv, null, 2, null);
        } else {
            string = null;
        }
        quotedName$iv$iv = string;
        $i$f$name = false;
        ScriptingContext.NewCodingAdapter bl2 = this_$iv$iv;
        text$iv$iv$iv = quotedName$iv$iv;
        $i$f$orError = false;
        $this$sqlClause.minus($this$sqlClause.plus(newCodingAdapter3, (Function0<? extends Object>)((Function0)new Function0<Unit>(text$iv$iv$iv, (ScriptingContext.NewCodingAdapter)this_$iv$iv$iv){
            final /* synthetic */ String $text;
            final /* synthetic */ ScriptingContext.NewCodingAdapter this$0;
            {
                this.$text = $text;
                this.this$0 = $receiver;
            }

            public final void invoke() {
                if (this.$text != null) {
                    ScriptingContext.NewCodingAdapter.appendSimple$default(this.this$0, this.$text, null, null, 6, null);
                } else {
                    CompositeText.Kind kind = null;
                    CharSequence charSequence = "???";
                    ScriptingContext.NewCodingAdapter newCodingAdapter = this.this$0;
                    boolean bl = false;
                    String string = "unknown name";
                    ScriptingContext.NewCodingAdapter.appendSimple$default(newCodingAdapter, charSequence, kind, string, 2, null);
                }
            }
        })), ")");
        return Unit.INSTANCE;
    }

    private static final Unit produceFooter$lambda$2(List $options, ScriptingContext.NewCodingAdapter $this$sqlClause) {
        Intrinsics.checkNotNullParameter((Object)$this$sqlClause, (String)"$this$sqlClause");
        $this$sqlClause.unaryPlus("with (");
        Iterator iterator = ((Iterable)$options).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int i2 = n++;
            String option = (String)iterator.next();
            if (i2 > 0) {
                $this$sqlClause.unaryMinus(",");
            }
            $this$sqlClause.newLine();
            ScriptingContext.NewCodingAdapter this_$iv = $this$sqlClause;
            boolean $i$f$indenting = false;
            boolean prev$iv = this_$iv.getOnNewLine();
            int length$iv = this_$iv.getBuilder().getLength();
            this_$iv.newLine();
            this_$iv.indent();
            boolean bl = false;
            $this$sqlClause.unaryPlus(option);
            this_$iv.unindent();
            if (length$iv != this_$iv.getBuilder().getLength()) continue;
            this_$iv.setOnNewLine(prev$iv);
        }
        $this$sqlClause.newLine();
        $this$sqlClause.unaryMinus(")");
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit produceTextImageOnClause$lambda$3(MsFileGroup $lobDataSpace, ScriptingContext.NewCodingAdapter $this$sqlClause) {
        void this_$iv$iv$iv;
        void this_$iv$iv;
        String string;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)$this$sqlClause, (String)"$this$sqlClause");
        ScriptingContext.NewCodingAdapter newCodingAdapter = $this$sqlClause.unaryPlus("textimage_on");
        ScriptingContext.NewCodingAdapter newCodingAdapter2 = $this$sqlClause;
        BasicElement element$iv = $lobDataSpace;
        boolean $i$f$scr = false;
        void var5_5 = this_$iv;
        BasicElement basicElement = element$iv;
        if (basicElement != null) {
            BasicElement it$iv = basicElement;
            boolean bl = false;
            string = ScriptingContext.NewCodingAdapter.quote$default((ScriptingContext.NewCodingAdapter)this_$iv, it$iv, null, 2, null);
        } else {
            string = null;
        }
        String quotedName$iv$iv = string;
        boolean $i$f$name = false;
        void bl = this_$iv$iv;
        String text$iv$iv$iv = quotedName$iv$iv;
        boolean $i$f$orError = false;
        $this$sqlClause.plus(newCodingAdapter, (Function0<? extends Object>)((Function0)new Function0<Unit>(text$iv$iv$iv, (ScriptingContext.NewCodingAdapter)this_$iv$iv$iv){
            final /* synthetic */ String $text;
            final /* synthetic */ ScriptingContext.NewCodingAdapter this$0;
            {
                this.$text = $text;
                this.this$0 = $receiver;
            }

            public final void invoke() {
                if (this.$text != null) {
                    ScriptingContext.NewCodingAdapter.appendSimple$default(this.this$0, this.$text, null, null, 6, null);
                } else {
                    CompositeText.Kind kind = null;
                    CharSequence charSequence = "???";
                    ScriptingContext.NewCodingAdapter newCodingAdapter = this.this$0;
                    boolean bl = false;
                    String string = "unknown name";
                    ScriptingContext.NewCodingAdapter.appendSimple$default(newCodingAdapter, charSequence, kind, string, 2, null);
                }
            }
        }));
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit produceFileStreamOnClause$lambda$4(MsDataSpace $fsDataSpace, ScriptingContext.NewCodingAdapter $this$sqlClause) {
        void this_$iv$iv$iv;
        void this_$iv$iv;
        String string;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)$this$sqlClause, (String)"$this$sqlClause");
        ScriptingContext.NewCodingAdapter newCodingAdapter = $this$sqlClause.unaryPlus("filestream_on");
        ScriptingContext.NewCodingAdapter newCodingAdapter2 = $this$sqlClause;
        BasicElement element$iv = $fsDataSpace;
        boolean $i$f$scr = false;
        void var5_5 = this_$iv;
        BasicElement basicElement = element$iv;
        if (basicElement != null) {
            BasicElement it$iv = basicElement;
            boolean bl = false;
            string = ScriptingContext.NewCodingAdapter.quote$default((ScriptingContext.NewCodingAdapter)this_$iv, it$iv, null, 2, null);
        } else {
            string = null;
        }
        String quotedName$iv$iv = string;
        boolean $i$f$name = false;
        void bl = this_$iv$iv;
        String text$iv$iv$iv = quotedName$iv$iv;
        boolean $i$f$orError = false;
        $this$sqlClause.plus(newCodingAdapter, (Function0<? extends Object>)((Function0)new Function0<Unit>(text$iv$iv$iv, (ScriptingContext.NewCodingAdapter)this_$iv$iv$iv){
            final /* synthetic */ String $text;
            final /* synthetic */ ScriptingContext.NewCodingAdapter this$0;
            {
                this.$text = $text;
                this.this$0 = $receiver;
            }

            public final void invoke() {
                if (this.$text != null) {
                    ScriptingContext.NewCodingAdapter.appendSimple$default(this.this$0, this.$text, null, null, 6, null);
                } else {
                    CompositeText.Kind kind = null;
                    CharSequence charSequence = "???";
                    ScriptingContext.NewCodingAdapter newCodingAdapter = this.this$0;
                    boolean bl = false;
                    String string = "unknown name";
                    ScriptingContext.NewCodingAdapter.appendSimple$default(newCodingAdapter, charSequence, kind, string, 2, null);
                }
            }
        }));
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MsLedgerKind.values().length];
            try {
                nArray[MsLedgerKind.UPDATABLE_LEDGER_TABLE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MsLedgerKind.APPEND_ONLY_LEDGER_TABLE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

