/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model;

import com.intellij.database.Dbms;
import com.intellij.database.model.DasExternal;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.meta.BasicMetaModel;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ModelRelationManager {
    private static final ExtensionPointName<ModelRelationProvider> EP = ExtensionPointName.create((String)"com.intellij.database.modelRelationProvider");

    @NotNull
    public static JBIterable<DasForeignKey> getForeignKeys(@Nullable Project project, @NotNull DasTable table, @NotNull DasTable target2) {
        if (table == null) {
            ModelRelationManager.$$$reportNull$$$0(0);
        }
        if (target2 == null) {
            ModelRelationManager.$$$reportNull$$$0(1);
        }
        JBIterable jBIterable = JBIterable.from((Iterable)EP.getExtensionList()).flatten(p2 -> p2.getForeignKeys(project, table, target2));
        if (jBIterable == null) {
            ModelRelationManager.$$$reportNull$$$0(2);
        }
        return jBIterable;
    }

    @NotNull
    public static JBIterable<DasForeignKey> getForeignKeys(@Nullable Project project, @Nullable DasTable table) {
        JBIterable jBIterable = table == null ? JBIterable.empty() : JBIterable.from((Iterable)EP.getExtensionList()).flatten(p2 -> p2.getForeignKeys(project, table, null));
        if (jBIterable == null) {
            ModelRelationManager.$$$reportNull$$$0(3);
        }
        return jBIterable;
    }

    @NotNull
    public static JBIterable<DasForeignKey> getExportedKeys(@Nullable Project project, @Nullable DasTable table) {
        if (table == null) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                ModelRelationManager.$$$reportNull$$$0(4);
            }
            return jBIterable;
        }
        ArrayList<ModelRelationProvider> toCompute = new ArrayList<ModelRelationProvider>();
        JBIterable result2 = JBIterable.empty();
        for (ModelRelationProvider provider : EP.getExtensionList()) {
            JBIterable<DasForeignKey> exported = provider.getExportedKeys(project, table);
            if (exported == null) {
                toCompute.add(provider);
                continue;
            }
            result2 = result2.append(exported);
        }
        JBIterable jBIterable = toCompute.isEmpty() ? result2 : result2.append(ModelRelationManager.computeExported(project, table, toCompute));
        if (jBIterable == null) {
            ModelRelationManager.$$$reportNull$$$0(5);
        }
        return jBIterable;
    }

    private static JBIterable<DasForeignKey> computeExported(@Nullable Project project, @NotNull DasTable table, @NotNull List<ModelRelationProvider> providers) {
        if (table == null) {
            ModelRelationManager.$$$reportNull$$$0(6);
        }
        if (providers == null) {
            ModelRelationManager.$$$reportNull$$$0(7);
        }
        Dbms dbms = DbImplUtilCore.getDbms(table);
        DasObject sc = DasUtil.getSchemaObject(table);
        DasTable searchRoot = sc == null ? table : (DasObject)ObjectUtils.notNull((Object)sc.getDasParent(), (Object)sc);
        BasicMetaModel<?> metaModel = DbImplUtilCore.getMetaModel(dbms);
        Set toExpand = metaModel.findMetaObjects(ObjectKind.FOREIGN_KEY).flatten(mo -> JBIterable.generate(mo.getParent(), o -> o.getParent())).map(o -> o.kind).toSet();
        JBIterable iterProviders = JBIterable.from(providers);
        return ((JBTreeTraverser)((JBTreeTraverser)DasUtil.dasTraverser().withRoot((Object)searchRoot)).expand(o -> toExpand.contains(o.getKind()))).filter(DasTable.class).transform(DbSqlUtilCore.checkCancelled(25)).flatten(src -> iterProviders.flatten(provider -> provider.getForeignKeys(project, (DasTable)src, table)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/ModelRelationManager";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/ModelRelationManager";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getForeignKeys";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getExportedKeys";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getForeignKeys";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "computeExported";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5 -> new IllegalStateException(string);
        };
    }

    public static interface ModelRelationProvider {
        public String getId();

        @NotNull
        public JBIterable<DasForeignKey> getForeignKeys(@Nullable Project var1, @NotNull DasTable var2, @Nullable DasTable var3);

        @Nullable(value="Compute from FK's")
        default public @Nullable(value="Compute from FK's") JBIterable<DasForeignKey> getExportedKeys(@Nullable Project project, @NotNull DasTable table) {
            if (table == null) {
                ModelRelationProvider.$$$reportNull$$$0(0);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/model/ModelRelationManager$ModelRelationProvider", "getExportedKeys"));
        }
    }

    public static abstract class ExtraRelation
    implements DasForeignKey,
    DasExternal {
        private final DasTable myTable;
        private final DasTable myRefTable;

        public ExtraRelation(@NotNull DasTable table, @Nullable DasTable refTable) {
            if (table == null) {
                ExtraRelation.$$$reportNull$$$0(0);
            }
            this.myTable = table;
            this.myRefTable = refTable;
        }

        @Override
        public boolean isQuoted() {
            return true;
        }

        @Override
        public String getRefTableName() {
            return DasUtil.getName(this.myRefTable);
        }

        @Override
        public String getRefTableSchema() {
            return DasUtil.getSchema(this.myRefTable);
        }

        @Override
        public String getRefTableCatalog() {
            return DasUtil.getCatalog(this.myRefTable);
        }

        @Override
        @Nullable
        public DasTable getRefTable() {
            return this.myRefTable;
        }

        @Override
        public DasForeignKey.RuleAction getDeleteRule() {
            return null;
        }

        @Override
        public DasForeignKey.RuleAction getUpdateRule() {
            return null;
        }

        @Override
        public DasForeignKey.Deferrability getDeferrability() {
            return null;
        }

        @Override
        @Nullable
        public DasTable getTable() {
            return this.myTable;
        }

        @Override
        @NotNull
        public ObjectKind getKind() {
            ObjectKind objectKind = ObjectKind.FOREIGN_KEY;
            if (objectKind == null) {
                ExtraRelation.$$$reportNull$$$0(1);
            }
            return objectKind;
        }

        @Override
        @NotNull
        public String getName() {
            String string = DasUtil.NO_NAME;
            if (string == null) {
                ExtraRelation.$$$reportNull$$$0(2);
            }
            return string;
        }

        public abstract String getProviderId();

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ExtraRelation)) {
                return false;
            }
            ExtraRelation relation = (ExtraRelation)o;
            return this.myTable.equals(relation.myTable) && Objects.equals(this.myRefTable, relation.myRefTable);
        }

        public int hashCode() {
            return Objects.hash(this.myTable, this.myRefTable);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "table";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/model/ModelRelationManager$ExtraRelation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/model/ModelRelationManager$ExtraRelation";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKind";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }

    public static final class DasForeignKeys
    implements ModelRelationProvider {
        public static final String ID = "DAS";

        @Override
        public String getId() {
            return ID;
        }

        @Override
        @NotNull
        public JBIterable<DasForeignKey> getForeignKeys(@Nullable Project project, @NotNull DasTable table, @Nullable DasTable target2) {
            if (table == null) {
                DasForeignKeys.$$$reportNull$$$0(0);
            }
            JBIterable res = DasUtil.getForeignKeys(table);
            JBIterable jBIterable = target2 == null ? res : res.filter(fk -> DasForeignKeys.isReferenceTo(fk, target2));
            if (jBIterable == null) {
                DasForeignKeys.$$$reportNull$$$0(1);
            }
            return jBIterable;
        }

        private static boolean isReferenceTo(@NotNull DasForeignKey fk, @NotNull DasTable target2) {
            if (fk == null) {
                DasForeignKeys.$$$reportNull$$$0(2);
            }
            if (target2 == null) {
                DasForeignKeys.$$$reportNull$$$0(3);
            }
            return target2.getName().equals(fk.getRefTableName()) && fk.getRefTable() == target2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "table";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/model/ModelRelationManager$DasForeignKeys";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fk";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/model/ModelRelationManager$DasForeignKeys";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getForeignKeys";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getForeignKeys";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "isReferenceTo";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

