/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.properties;

import org.jetbrains.annotations.Nullable;

public enum Level {
    L1(1),
    L2(2),
    L3(3);

    public final byte level;

    private Level(byte level) {
        this.level = level;
    }

    @Nullable
    public static Level of(byte level) {
        return switch (level) {
            case 1 -> L1;
            case 2 -> L2;
            case 3 -> L3;
            default -> null;
        };
    }

    @Nullable
    public String export() {
        return switch (this.level) {
            case 1 -> "1";
            case 2 -> "2";
            case 3 -> "3";
            default -> null;
        };
    }

    @Nullable
    public static Level of(@Nullable String str) {
        if (str == null || str.isEmpty()) {
            return null;
        }
        String s = str.trim();
        if (s.length() >= 2 && s.charAt(0) == 'L') {
            s = s.substring(1);
        }
        try {
            byte b = Byte.parseByte(s);
            return switch (b) {
                case 1 -> L1;
                case 2 -> L2;
                case 3 -> L3;
                default -> null;
            };
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    public String toString() {
        return "L" + Byte.toString(this.level);
    }
}

