/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections.dataflow.sql.inst;

import com.intellij.codeInspection.dataFlow.lang.DfaAnchor;
import com.intellij.codeInspection.dataFlow.lang.ir.EvalInstruction;
import com.intellij.codeInspection.dataFlow.memory.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.value.DfaTypeValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.sql.inspections.dataflow.SqlDfaColumn;
import com.intellij.sql.inspections.dataflow.SqlDfaUnionType;
import com.intellij.sql.inspections.dataflow.SqlDfaUtilKt;
import com.intellij.sql.inspections.dataflow.sql.anchor.SqlDfaAnchor;
import com.intellij.sql.inspections.dataflow.types.SqlDfTableType;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J1\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\u0011\"\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010\u0012J\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/sql/inspections/dataflow/sql/inst/SqlUnionInstruction;", "Lcom/intellij/codeInspection/dataFlow/lang/ir/EvalInstruction;", "anchor", "Lcom/intellij/sql/inspections/dataflow/sql/anchor/SqlDfaAnchor;", "unionType", "Lcom/intellij/sql/inspections/dataflow/SqlDfaUnionType;", "<init>", "(Lcom/intellij/sql/inspections/dataflow/sql/anchor/SqlDfaAnchor;Lcom/intellij/sql/inspections/dataflow/SqlDfaUnionType;)V", "getAnchor", "()Lcom/intellij/sql/inspections/dataflow/sql/anchor/SqlDfaAnchor;", "eval", "Lcom/intellij/codeInspection/dataFlow/value/DfaValue;", "factory", "Lcom/intellij/codeInspection/dataFlow/value/DfaValueFactory;", "state", "Lcom/intellij/codeInspection/dataFlow/memory/DfaMemoryState;", "arguments", "", "(Lcom/intellij/codeInspection/dataFlow/value/DfaValueFactory;Lcom/intellij/codeInspection/dataFlow/memory/DfaMemoryState;[Lcom/intellij/codeInspection/dataFlow/value/DfaValue;)Lcom/intellij/codeInspection/dataFlow/value/DfaValue;", "toString", "", "intellij.database.sql.core.impl"})
public final class SqlUnionInstruction
extends EvalInstruction {
    @NotNull
    private final SqlDfaAnchor anchor;
    @NotNull
    private final SqlDfaUnionType unionType;

    public SqlUnionInstruction(@NotNull SqlDfaAnchor anchor, @NotNull SqlDfaUnionType unionType) {
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        Intrinsics.checkNotNullParameter((Object)((Object)unionType), (String)"unionType");
        super((DfaAnchor)anchor, 2);
        this.anchor = anchor;
        this.unionType = unionType;
    }

    @NotNull
    public final SqlDfaAnchor getAnchor() {
        return this.anchor;
    }

    @NotNull
    public DfaValue eval(@NotNull DfaValueFactory factory, @NotNull DfaMemoryState state, DfaValue ... arguments) {
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        DfType dfType = state.getDfType(arguments[0]);
        SqlDfTableType sqlDfTableType = dfType instanceof SqlDfTableType ? (SqlDfTableType)dfType : null;
        if (sqlDfTableType == null) {
            DfaTypeValue dfaTypeValue = factory.getUnknown();
            Intrinsics.checkNotNullExpressionValue((Object)dfaTypeValue, (String)"getUnknown(...)");
            return (DfaValue)dfaTypeValue;
        }
        SqlDfTableType first2 = sqlDfTableType;
        DfType dfType2 = state.getDfType(arguments[1]);
        SqlDfTableType sqlDfTableType2 = dfType2 instanceof SqlDfTableType ? (SqlDfTableType)dfType2 : null;
        if (sqlDfTableType2 == null) {
            DfaTypeValue dfaTypeValue = factory.getUnknown();
            Intrinsics.checkNotNullExpressionValue((Object)dfaTypeValue, (String)"getUnknown(...)");
            return (DfaValue)dfaTypeValue;
        }
        SqlDfTableType second = sqlDfTableType2;
        List<SqlDfaColumn> firstColumns = first2.getColumns();
        List<SqlDfaColumn> secondColumns = second.getColumns();
        if (firstColumns.size() != secondColumns.size()) {
            DfaTypeValue dfaTypeValue = factory.getUnknown();
            Intrinsics.checkNotNullExpressionValue((Object)dfaTypeValue, (String)"getUnknown(...)");
            return (DfaValue)dfaTypeValue;
        }
        SqlDfTableType resultType = first2;
        int n = ((Collection)firstColumns).size();
        for (int i2 = 0; i2 < n; ++i2) {
            SqlDfaColumn firstColumn = firstColumns.get(i2);
            SqlDfaColumn secondColumn = secondColumns.get(i2);
            resultType = resultType.setNullability(firstColumn.getElement(), firstColumn.getNullability().unite(secondColumn.getNullability()));
        }
        return SqlDfaUtilKt.createTableValue(this.anchor.getElement(), null, factory, state, resultType);
    }

    @NotNull
    public String toString() {
        return switch (WhenMappings.$EnumSwitchMapping$0[this.unionType.ordinal()]) {
            case 1 -> "UNION_DISTINCT";
            case 2 -> "UNION_ALL";
            case 3 -> "EXCEPT";
            case 4 -> "INTERSECT";
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SqlDfaUnionType.values().length];
            try {
                nArray[SqlDfaUnionType.UNION_DISTINCT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SqlDfaUnionType.UNION_ALL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SqlDfaUnionType.EXCEPT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SqlDfaUnionType.INTERSECT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

