/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.edt;

import javax.swing.SwingUtilities;
import org.assertj.swing.dependency.jsr305.Nullable;
import org.assertj.swing.edt.GuiAction;
import org.assertj.swing.exception.ActionFailedException;

public abstract class GuiQuery<T>
extends GuiAction {
    private T result;

    @Override
    public final void run() {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw ActionFailedException.actionFailure("Query should be executed in the event dispatch thread");
        }
        try {
            this.result = this.executeInEDT();
        }
        catch (Throwable t) {
            this.catchedException(t);
        }
        finally {
            this.notifyExecutionCompleted();
        }
    }

    @Nullable
    protected abstract T executeInEDT() throws Throwable;

    @Nullable
    final T result() {
        return this.result;
    }

    final void clearResult() {
        this.result = null;
    }
}

