/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.interact.mouse;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.event.MouseEvent;
import org.jetbrains.letsPlot.commons.event.MouseEventSpec;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.registration.CompositeRegistration;
import org.jetbrains.letsPlot.commons.registration.Disposable;
import org.jetbrains.letsPlot.commons.registration.Registration;
import org.jetbrains.letsPlot.core.interact.InteractionContext;
import org.jetbrains.letsPlot.core.interact.InteractionTarget;
import org.jetbrains.letsPlot.core.interact.ui.UiControl;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u001b\u001a\u00020\u0006H\u0086\u0002J\t\u0010\u001c\u001a\u00020\fH\u0086\u0002J\t\u0010\u001d\u001a\u00020\fH\u0086\u0002J\t\u0010\u001e\u001a\u00020\fH\u0086\u0002J\b\u0010\u001f\u001a\u00020 H\u0016JV\u0010!\u001a\u00020 2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020 0#2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020 0#2\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020 0#2\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020 0#J\u0006\u0010'\u001a\u00020 R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\u00020\f8BX\u0082\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\u000f\u001a\u00020\f8BX\u0082\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0016\u0010\u0011\u001a\u00020\f8BX\u0082\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000eR\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006("}, d2={"Lorg/jetbrains/letsPlot/core/interact/mouse/MouseDragInteraction;", "Lorg/jetbrains/letsPlot/commons/registration/Disposable;", "ctx", "Lorg/jetbrains/letsPlot/core/interact/InteractionContext;", "(Lorg/jetbrains/letsPlot/core/interact/InteractionContext;)V", "_target", "Lorg/jetbrains/letsPlot/core/interact/InteractionTarget;", "aborted", "", "completed", "disposed", "dragDelta", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "getDragDelta", "()Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "dragFrom", "getDragFrom", "dragTo", "getDragTo", "reg", "Lorg/jetbrains/letsPlot/commons/registration/CompositeRegistration;", "started", "getStarted", "()Z", "target", "getTarget", "()Lorg/jetbrains/letsPlot/core/interact/InteractionTarget;", "component1", "component2", "component3", "component4", "dispose", "", "loop", "onStarted", "Lkotlin/Function1;", "onDragged", "onCompleted", "onAborted", "reset", "plot-base"})
@SourceDebugExtension(value={"SMAP\nMouseDragInteraction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MouseDragInteraction.kt\norg/jetbrains/letsPlot/core/interact/mouse/MouseDragInteraction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,123:1\n1#2:124\n*E\n"})
public final class MouseDragInteraction
implements Disposable {
    @NotNull
    private final InteractionContext ctx;
    private boolean completed;
    private boolean aborted;
    @Nullable
    private InteractionTarget _target;
    @NotNull
    private DoubleVector dragFrom;
    @NotNull
    private DoubleVector dragTo;
    @NotNull
    private DoubleVector dragDelta;
    private boolean disposed;
    @NotNull
    private final CompositeRegistration reg;

    public MouseDragInteraction(@NotNull InteractionContext ctx2) {
        Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
        this.ctx = ctx2;
        MouseEventSpec[] mouseEventSpecArray = new MouseEventSpec[]{MouseEventSpec.MOUSE_DRAGGED, MouseEventSpec.MOUSE_RELEASED};
        this.ctx.checkSupported(CollectionsKt.listOf((Object[])mouseEventSpecArray));
        this.dragFrom = DoubleVector.Companion.getZERO();
        this.dragTo = DoubleVector.Companion.getZERO();
        this.dragDelta = DoubleVector.Companion.getZERO();
        this.reg = new CompositeRegistration(new Registration[0]);
    }

    @NotNull
    public final InteractionTarget component1() {
        return this.getTarget();
    }

    @NotNull
    public final DoubleVector component2() {
        return this.getDragFrom();
    }

    @NotNull
    public final DoubleVector component3() {
        return this.getDragTo();
    }

    @NotNull
    public final DoubleVector component4() {
        return this.getDragDelta();
    }

    private final boolean getStarted() {
        return this._target != null;
    }

    @NotNull
    public final InteractionTarget getTarget() {
        InteractionTarget interactionTarget = this._target;
        if (interactionTarget == null) {
            throw new IllegalStateException("Mouse drag target wasn't acquired.");
        }
        return interactionTarget;
    }

    private final DoubleVector getDragFrom() {
        if (!this.getStarted()) {
            boolean bl = false;
            String string = "Mouse drag target wasn't acquired.";
            throw new IllegalArgumentException(string.toString());
        }
        return this.dragFrom;
    }

    private final DoubleVector getDragTo() {
        if (!this.getStarted()) {
            boolean bl = false;
            String string = "Mouse drag target wasn't acquired.";
            throw new IllegalArgumentException(string.toString());
        }
        return this.dragTo;
    }

    private final DoubleVector getDragDelta() {
        if (!this.getStarted()) {
            boolean bl = false;
            String string = "Mouse drag target wasn't acquired.";
            throw new IllegalArgumentException(string.toString());
        }
        return this.dragDelta;
    }

    public final void loop(@NotNull Function1<? super MouseDragInteraction, Unit> onStarted, @NotNull Function1<? super MouseDragInteraction, Unit> onDragged, @NotNull Function1<? super MouseDragInteraction, Unit> onCompleted, @NotNull Function1<? super MouseDragInteraction, Unit> onAborted) {
        Intrinsics.checkNotNullParameter(onStarted, (String)"onStarted");
        Intrinsics.checkNotNullParameter(onDragged, (String)"onDragged");
        Intrinsics.checkNotNullParameter(onCompleted, (String)"onCompleted");
        Intrinsics.checkNotNullParameter(onAborted, (String)"onAborted");
        if (!(!this.disposed)) {
            boolean $i$a$-check-MouseDragInteraction$loop$32 = false;
            String $i$a$-check-MouseDragInteraction$loop$32 = "Disposed.";
            throw new IllegalStateException($i$a$-check-MouseDragInteraction$loop$32.toString());
        }
        if (!(!this.getStarted())) {
            boolean bl = false;
            String string = "Mouse drag has already started.";
            throw new IllegalStateException(string.toString());
        }
        this.reg.add(this.ctx.getEventsManager().onMouseEvent(MouseEventSpec.MOUSE_RELEASED, (Function2<? super UiControl, ? super MouseEvent, Unit>)((Function2)new Function2<UiControl, MouseEvent, Unit>(this, onCompleted){
            final /* synthetic */ MouseDragInteraction this$0;
            final /* synthetic */ Function1<MouseDragInteraction, Unit> $onCompleted;
            {
                this.this$0 = $receiver;
                this.$onCompleted = $onCompleted;
                super(2);
            }

            public final void invoke(@Nullable UiControl uiControl, @NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (MouseDragInteraction.access$getStarted(this.this$0) && !MouseDragInteraction.access$getCompleted$p(this.this$0) && !MouseDragInteraction.access$getAborted$p(this.this$0)) {
                    DoubleVector absCoord = e.getLocation().toDoubleVector();
                    MouseDragInteraction.access$setCompleted$p(this.this$0, true);
                    MouseDragInteraction.access$setDragTo$p(this.this$0, absCoord);
                    this.$onCompleted.invoke((Object)this.this$0);
                }
            }
        })));
        this.reg.add(this.ctx.getEventsManager().onMouseEvent(MouseEventSpec.MOUSE_DRAGGED, (Function2<? super UiControl, ? super MouseEvent, Unit>)((Function2)new Function2<UiControl, MouseEvent, Unit>(this, onDragged, onStarted){
            final /* synthetic */ MouseDragInteraction this$0;
            final /* synthetic */ Function1<MouseDragInteraction, Unit> $onDragged;
            final /* synthetic */ Function1<MouseDragInteraction, Unit> $onStarted;
            {
                this.this$0 = $receiver;
                this.$onDragged = $onDragged;
                this.$onStarted = $onStarted;
                super(2);
            }

            public final void invoke(@Nullable UiControl uiControl, @NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (!MouseDragInteraction.access$getCompleted$p(this.this$0) && !MouseDragInteraction.access$getAborted$p(this.this$0)) {
                    DoubleVector plotCoord = e.getLocation().toDoubleVector();
                    if (!MouseDragInteraction.access$getStarted(this.this$0)) {
                        InteractionTarget interactionTarget = MouseDragInteraction.access$getCtx$p(this.this$0).findTarget(plotCoord);
                        if (interactionTarget != null) {
                            InteractionTarget interactionTarget2 = interactionTarget;
                            MouseDragInteraction mouseDragInteraction = this.this$0;
                            Function1<MouseDragInteraction, Unit> function1 = this.$onStarted;
                            InteractionTarget it = interactionTarget2;
                            boolean bl = false;
                            MouseDragInteraction.access$set_target$p(mouseDragInteraction, it);
                            MouseDragInteraction.access$setDragFrom$p(mouseDragInteraction, plotCoord);
                            MouseDragInteraction.access$setDragTo$p(mouseDragInteraction, plotCoord);
                            function1.invoke((Object)mouseDragInteraction);
                        }
                    } else {
                        MouseDragInteraction.access$setDragDelta$p(this.this$0, plotCoord.subtract(MouseDragInteraction.access$getDragTo(this.this$0)));
                        MouseDragInteraction.access$setDragTo$p(this.this$0, plotCoord);
                        this.$onDragged.invoke((Object)this.this$0);
                    }
                }
            }
        })));
    }

    public final void reset() {
        if (!(!this.disposed)) {
            boolean bl = false;
            String string = "Disposed.";
            throw new IllegalStateException(string.toString());
        }
        this._target = null;
        this.completed = false;
        this.aborted = false;
    }

    @Override
    public void dispose() {
        if (!this.disposed) {
            this.disposed = true;
            this._target = null;
            this.reg.dispose();
        }
    }

    public static final /* synthetic */ boolean access$getStarted(MouseDragInteraction $this) {
        return $this.getStarted();
    }

    public static final /* synthetic */ boolean access$getCompleted$p(MouseDragInteraction $this) {
        return $this.completed;
    }

    public static final /* synthetic */ boolean access$getAborted$p(MouseDragInteraction $this) {
        return $this.aborted;
    }

    public static final /* synthetic */ void access$setCompleted$p(MouseDragInteraction $this, boolean bl) {
        $this.completed = bl;
    }

    public static final /* synthetic */ void access$setDragTo$p(MouseDragInteraction $this, DoubleVector doubleVector) {
        $this.dragTo = doubleVector;
    }

    public static final /* synthetic */ InteractionContext access$getCtx$p(MouseDragInteraction $this) {
        return $this.ctx;
    }

    public static final /* synthetic */ void access$setDragDelta$p(MouseDragInteraction $this, DoubleVector doubleVector) {
        $this.dragDelta = doubleVector;
    }

    public static final /* synthetic */ DoubleVector access$getDragTo(MouseDragInteraction $this) {
        return $this.getDragTo();
    }

    public static final /* synthetic */ void access$set_target$p(MouseDragInteraction $this, InteractionTarget interactionTarget) {
        $this._target = interactionTarget;
    }

    public static final /* synthetic */ void access$setDragFrom$p(MouseDragInteraction $this, DoubleVector doubleVector) {
        $this.dragFrom = doubleVector;
    }
}

