/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.editor;

import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.editor.JupyterCellLinesLexer;
import com.intellij.jupyter.core.jupyter.editor.JupyterCellLinesProvider;
import com.intellij.jupyter.core.jupyter.lang.JupyterDialectProvider;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebook;
import com.intellij.lang.Language;
import com.intellij.notebooks.visualization.IntervalsGenerator;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.NotebookCellLinesLexer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.keyFMap.KeyFMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J4\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00072\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/jupyter/core/jupyter/editor/LexerIntervalsGenerator;", "Lcom/intellij/notebooks/visualization/IntervalsGenerator;", "lexer", "Lcom/intellij/jupyter/core/jupyter/editor/JupyterCellLinesLexer;", "<init>", "(Lcom/intellij/jupyter/core/jupyter/editor/JupyterCellLinesLexer;)V", "makeIntervals", "", "Lcom/intellij/notebooks/visualization/NotebookCellLines$Interval;", "document", "Lcom/intellij/openapi/editor/Document;", "event", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "updateMarkersBasedOnDocumentChange", "Lcom/intellij/notebooks/visualization/NotebookCellLinesLexer$Marker;", "markers", "defaultCodeLanguage", "Lcom/intellij/lang/Language;", "Companion", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nLexerIntervalsGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LexerIntervalsGenerator.kt\ncom/intellij/jupyter/core/jupyter/editor/LexerIntervalsGenerator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,112:1\n1#2:113\n388#3,7:114\n360#3,7:121\n1563#3:128\n1634#3,3:129\n*S KotlinDebug\n*F\n+ 1 LexerIntervalsGenerator.kt\ncom/intellij/jupyter/core/jupyter/editor/LexerIntervalsGenerator\n*L\n61#1:114,7\n64#1:121,7\n90#1:128\n90#1:129,3\n*E\n"})
public final class LexerIntervalsGenerator
implements IntervalsGenerator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JupyterCellLinesLexer lexer;
    @NotNull
    private static final String DELIMITER = "\n#%%";
    @NotNull
    private static final Key<Pair<List<NotebookCellLinesLexer.Marker>, Long>> key;

    public LexerIntervalsGenerator(@NotNull JupyterCellLinesLexer lexer) {
        Intrinsics.checkNotNullParameter((Object)lexer, (String)"lexer");
        this.lexer = lexer;
    }

    @NotNull
    public List<NotebookCellLines.Interval> makeIntervals(@NotNull Document document, @Nullable DocumentEvent event) {
        List list;
        Language language;
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        ThreadingAssertions.assertReadAccess();
        VirtualFile file = FileDocumentManager.getInstance().getFile(document);
        try {
            JupyterNotebook jupyterNotebook;
            VirtualFile virtualFile2 = file;
            if (virtualFile2 != null) {
                VirtualFile it = virtualFile2;
                boolean bl = false;
                jupyterNotebook = BackedNotebookVirtualFile.Companion.takeBackend(it).getNotebookOrNull();
            } else {
                jupyterNotebook = null;
            }
            JupyterNotebook jupyterNotebook2 = jupyterNotebook;
            language = JupyterCellLinesProvider.Util.INSTANCE.getDefaultCodeLanguage(jupyterNotebook2);
        }
        catch (IllegalArgumentException t) {
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                throw t;
            }
            Language language2 = JupyterDialectProvider.Companion.getDefaultDialect().getBaseLanguage();
            Intrinsics.checkNotNull((Object)language2);
            language = language2;
        }
        Language defaultCodeLanguage = language;
        Pair pair = LexerIntervalsGenerator.Companion.getMarkersCache(document);
        if (pair == null) {
            pair = TuplesKt.to(null, (Object)0L);
        }
        language = pair;
        List oldMarkers = (List)language.component1();
        long stamp = ((Number)language.component2()).longValue();
        if (oldMarkers != null && stamp == document.getModificationStamp()) {
            list = oldMarkers;
        } else if (oldMarkers != null && event != null && !event.isWholeTextReplaced()) {
            list = this.updateMarkersBasedOnDocumentChange(event, oldMarkers, document, defaultCodeLanguage);
        } else {
            CharSequence charSequence = document.getCharsSequence();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getCharsSequence(...)");
            list = SequencesKt.toList(this.lexer.markerSequence(charSequence, 0, 0, defaultCodeLanguage));
        }
        List newMarkers = list;
        LexerIntervalsGenerator.Companion.setMarkersCache(document, (Pair<? extends List<NotebookCellLinesLexer.Marker>, Long>)TuplesKt.to((Object)newMarkers, (Object)document.getModificationStamp()));
        KeyFMap data = (KeyFMap)this.lexer.getRawData().getSecond();
        return NotebookCellLinesLexer.Companion.defaultIntervals(document, newMarkers, data, data);
    }

    /*
     * WARNING - void declaration
     */
    private final List<NotebookCellLinesLexer.Marker> updateMarkersBasedOnDocumentChange(DocumentEvent event, List<NotebookCellLinesLexer.Marker> markers, Document document, Language defaultCodeLanguage) {
        void $this$mapTo$iv$iv;
        int n;
        NotebookCellLinesLexer.Marker marker;
        NotebookCellLinesLexer.Marker marker2;
        int n2;
        Object item$iv;
        int leftAffectedMarkerIndex;
        int documentShiftOffset;
        block11: {
            int n3;
            int offset;
            block10: {
                offset = event.getOffset();
                documentShiftOffset = event.getNewLength() - event.getOldLength();
                List<NotebookCellLinesLexer.Marker> $this$indexOfLast$iv = markers;
                boolean $i$f$indexOfLast = false;
                ListIterator<NotebookCellLinesLexer.Marker> iterator$iv = $this$indexOfLast$iv.listIterator($this$indexOfLast$iv.size());
                while (iterator$iv.hasPrevious()) {
                    NotebookCellLinesLexer.Marker it = iterator$iv.previous();
                    boolean bl = false;
                    if (!(it.getOffset() < offset)) continue;
                    n3 = iterator$iv.nextIndex();
                    break block10;
                }
                n3 = -1;
            }
            leftAffectedMarkerIndex = n3;
            List<NotebookCellLinesLexer.Marker> $this$indexOfFirst$iv = markers;
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator<NotebookCellLinesLexer.Marker> bl = $this$indexOfFirst$iv.iterator();
            while (bl.hasNext()) {
                NotebookCellLinesLexer.Marker it = item$iv = bl.next();
                boolean bl2 = false;
                if (it.getOffset() > offset + event.getOldLength() + 4) {
                    n2 = index$iv;
                    break block11;
                }
                ++index$iv;
            }
            n2 = -1;
        }
        int rightAffectedMarkerIndex = n2;
        List<NotebookCellLinesLexer.Marker> leftNotAffectedCells = leftAffectedMarkerIndex >= 0 ? markers.subList(0, leftAffectedMarkerIndex) : CollectionsKt.emptyList();
        List<NotebookCellLinesLexer.Marker> rightNotAffectedCells = rightAffectedMarkerIndex >= 0 ? markers.subList(rightAffectedMarkerIndex + 1, markers.size()) : CollectionsKt.emptyList();
        item$iv = leftAffectedMarkerIndex;
        int it = ((Number)item$iv).intValue();
        boolean bl = false;
        Object object = it >= 0 ? item$iv : null;
        if (object != null) {
            it = ((Number)object).intValue();
            boolean bl3 = false;
            marker2 = markers.get(leftAffectedMarkerIndex);
        } else {
            marker2 = null;
        }
        NotebookCellLinesLexer.Marker leftDirtyCell = marker2;
        Integer it2 = rightAffectedMarkerIndex;
        int it3 = ((Number)it2).intValue();
        boolean bl4 = false;
        Integer n4 = it3 >= 0 ? it2 : null;
        if (n4 != null) {
            it3 = ((Number)n4).intValue();
            boolean bl5 = false;
            marker = markers.get(rightAffectedMarkerIndex);
        } else {
            marker = null;
        }
        NotebookCellLinesLexer.Marker rightDirtyCell = marker;
        NotebookCellLinesLexer.Marker marker3 = leftDirtyCell;
        int startDirtyRegion = marker3 != null ? marker3.getOffset() : 0;
        NotebookCellLinesLexer.Marker marker4 = rightDirtyCell;
        if (marker4 != null) {
            int it4 = marker4.getEndOffset();
            boolean bl6 = false;
            n = it4 + documentShiftOffset;
        } else {
            n = document.getTextLength();
        }
        int endDirtyRegion = n;
        NotebookCellLinesLexer.Marker marker5 = leftDirtyCell;
        NotebookCellLinesLexer.Marker marker6 = leftDirtyCell;
        List newMiddleMarkers = SequencesKt.toList(this.lexer.markerSequence(document.getCharsSequence().subSequence(startDirtyRegion, endDirtyRegion), marker5 != null ? marker5.getOrdinal() : 0, marker6 != null ? marker6.getOffset() : 0, defaultCodeLanguage));
        int rightMarkersShiftOrdinal = newMiddleMarkers.size() - (markers.size() - leftNotAffectedCells.size() - rightNotAffectedCells.size());
        Iterable $this$map$iv = rightNotAffectedCells;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void marker7;
            NotebookCellLinesLexer.Marker marker8 = (NotebookCellLinesLexer.Marker)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl7 = false;
            collection.add(new NotebookCellLinesLexer.Marker(marker7.getOrdinal() + rightMarkersShiftOrdinal, marker7.getType(), marker7.getOffset() + documentShiftOffset, marker7.getLength(), marker7.getData()));
        }
        List shiftedRightNotAffectedCells = (List)destination$iv$iv;
        return CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)leftNotAffectedCells, (Iterable)newMiddleMarkers), (Iterable)shiftedRightNotAffectedCells);
    }

    static {
        Key key = Key.create((String)"MARKERS_CACHE");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        LexerIntervalsGenerator.key = key;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000RE\u0010\u0006\u001a9\u00120\u0012.\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0004\u0012\u00020\u000b \f*\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0004\u0012\u00020\u000b\u0018\u00010\b0\b0\u0007\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000RZ\u0010\u0010\u001a\u001b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0004\u0012\u00020\u000b\u0018\u00010\b\u00a2\u0006\u0002\b\u000f*\u00020\u00112\u001f\u0010\u000e\u001a\u001b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0004\u0012\u00020\u000b\u0018\u00010\b\u00a2\u0006\u0002\b\u000f8B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lcom/intellij/jupyter/core/jupyter/editor/LexerIntervalsGenerator$Companion;", "", "<init>", "()V", "DELIMITER", "", "key", "Lcom/intellij/openapi/util/Key;", "Lkotlin/Pair;", "", "Lcom/intellij/notebooks/visualization/NotebookCellLinesLexer$Marker;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "value", "Lorg/jetbrains/annotations/Nullable;", "markersCache", "Lcom/intellij/openapi/editor/Document;", "getMarkersCache", "(Lcom/intellij/openapi/editor/Document;)Lkotlin/Pair;", "setMarkersCache", "(Lcom/intellij/openapi/editor/Document;Lkotlin/Pair;)V", "intellij.jupyter.core"})
    public static final class Companion {
        private Companion() {
        }

        private final Pair<List<NotebookCellLinesLexer.Marker>, Long> getMarkersCache(Document $this$markersCache) {
            return (Pair)$this$markersCache.getUserData(key);
        }

        private final void setMarkersCache(Document $this$markersCache, Pair<? extends List<NotebookCellLinesLexer.Marker>, Long> value) {
            $this$markersCache.putUserData(key, value);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

