/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util.table;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.css.util.CssPsiUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.css.CssAtRule;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssElementDescriptorProvider;
import com.intellij.psi.css.CssMediaFeatureDescriptor;
import com.intellij.psi.css.CssMediaGroupAwareDescriptor;
import com.intellij.psi.css.CssPropertyDescriptor;
import com.intellij.psi.css.CssSimpleSelector;
import com.intellij.psi.css.CssStylesheet;
import com.intellij.psi.css.CssTerm;
import com.intellij.psi.css.descriptor.CssContextType;
import com.intellij.psi.css.descriptor.CssElementDescriptor;
import com.intellij.psi.css.descriptor.CssFunctionDescriptor;
import com.intellij.psi.css.descriptor.CssMediaGroup;
import com.intellij.psi.css.descriptor.CssMediaType;
import com.intellij.psi.css.descriptor.CssPseudoSelectorDescriptor;
import com.intellij.psi.css.descriptor.CssVersionDescriptorComparator;
import com.intellij.psi.css.descriptor.value.CssValueDescriptor;
import com.intellij.psi.css.descriptor.value.CssValueValidator;
import com.intellij.psi.css.descriptor.value.CssValueValidatorStub;
import com.intellij.psi.css.resolve.CssStyleReferenceStub;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Color;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CssDescriptorsUtil {
    public static final NotNullFunction<CssElementDescriptor, String> GET_DESCRIPTOR_ID_FUNCTION = CssElementDescriptor::getId;
    private static final Key<ParameterizedCachedValue<CssElementDescriptorProvider, PsiElement>> DESCRIPTOR_PROVIDER_KEY = Key.create((String)"css.descriptor.provider");
    private static final ParameterizedCachedValueProvider<CssElementDescriptorProvider, PsiElement> DESCRIPTOR_PROVIDER_CACHE_VALUE = param -> CachedValueProvider.Result.create((Object)CssDescriptorsUtil.innerFindDescriptorProvider(param), (Object[])new Object[]{param});

    private CssDescriptorsUtil() {
    }

    @Nullable
    public static CssElementDescriptorProvider findDescriptorProvider(@Nullable PsiElement context) {
        CssStylesheet stylesheet = (CssStylesheet)PsiTreeUtil.getNonStrictParentOfType((PsiElement)context, (Class[])new Class[]{CssStylesheet.class});
        if (stylesheet != null) {
            return (CssElementDescriptorProvider)CachedValuesManager.getManager((Project)stylesheet.getProject()).getParameterizedCachedValue((UserDataHolder)stylesheet, DESCRIPTOR_PROVIDER_KEY, DESCRIPTOR_PROVIDER_CACHE_VALUE, false, (Object)context);
        }
        return CssDescriptorsUtil.innerFindDescriptorProvider(context);
    }

    private static CssElementDescriptorProvider innerFindDescriptorProvider(@Nullable PsiElement context) {
        CssElementDescriptorProvider[] providers;
        LinkedList<CssElementDescriptorProvider> applicableProviders = new LinkedList<CssElementDescriptorProvider>();
        for (CssElementDescriptorProvider provider : providers = (CssElementDescriptorProvider[])CssElementDescriptorProvider.EP_NAME.getExtensions()) {
            if (!provider.isMyContext(context)) continue;
            applicableProviders.add(provider);
            if (!provider.shouldAskOtherProviders(context)) break;
        }
        if (applicableProviders.size() == 1) {
            return (CssElementDescriptorProvider)ContainerUtil.getFirstItem(applicableProviders);
        }
        return !applicableProviders.isEmpty() ? new CompositeCssElementDescriptorProvider(applicableProviders) : null;
    }

    public static String @NotNull [] getSimpleSelectors(@NotNull PsiElement context) {
        CssElementDescriptorProvider provider;
        if (context == null) {
            CssDescriptorsUtil.$$$reportNull$$$0(0);
        }
        String[] stringArray = (provider = CssDescriptorsUtil.findDescriptorProvider(context)) != null ? provider.getSimpleSelectors(context) : ArrayUtilRt.EMPTY_STRING_ARRAY;
        if (stringArray == null) {
            CssDescriptorsUtil.$$$reportNull$$$0(1);
        }
        return stringArray;
    }

    @NotNull
    public static Collection<? extends CssPropertyDescriptor> getAllPropertyDescriptors(@Nullable PsiElement context) {
        CssElementDescriptorProvider provider = CssDescriptorsUtil.findDescriptorProvider(context);
        Collection<Object> collection = provider != null ? provider.getAllPropertyDescriptors(context) : Collections.emptyList();
        if (collection == null) {
            CssDescriptorsUtil.$$$reportNull$$$0(2);
        }
        return collection;
    }

    @NotNull
    public static Collection<? extends CssPseudoSelectorDescriptor> getPseudoSelectorDescriptors(@NotNull String pseudoSelectorName, @Nullable PsiElement context) {
        CssElementDescriptorProvider provider;
        if (pseudoSelectorName == null) {
            CssDescriptorsUtil.$$$reportNull$$$0(3);
        }
        Collection<Object> collection = (provider = CssDescriptorsUtil.findDescriptorProvider(context)) != null ? provider.findPseudoSelectorDescriptors(pseudoSelectorName, context) : Collections.emptyList();
        if (collection == null) {
            CssDescriptorsUtil.$$$reportNull$$$0(4);
        }
        return collection;
    }

    @NotNull
    public static Collection<? extends CssFunctionDescriptor> getFunctionDescriptors(@NotNull String functionName, @Nullable PsiElement context) {
        CssElementDescriptorProvider provider;
        if (functionName == null) {
            CssDescriptorsUtil.$$$reportNull$$$0(5);
        }
        Collection<Object> collection = (provider = CssDescriptorsUtil.findDescriptorProvider(context)) != null ? provider.findFunctionDescriptors(functionName, context) : Collections.emptyList();
        if (collection == null) {
            CssDescriptorsUtil.$$$reportNull$$$0(6);
        }
        return collection;
    }

    @NotNull
    public static Collection<? extends CssPropertyDescriptor> getPropertyDescriptors(@NotNull String propertyName, @Nullable PsiElement context) {
        CssElementDescriptorProvider provider;
        if (propertyName == null) {
            CssDescriptorsUtil.$$$reportNull$$$0(7);
        }
        Collection<Object> collection = (provider = CssDescriptorsUtil.findDescriptorProvider(context)) != null ? provider.findPropertyDescriptors(propertyName, context) : Collections.emptyList();
        if (collection == null) {
            CssDescriptorsUtil.$$$reportNull$$$0(8);
        }
        return collection;
    }

    @Nullable
    public static CssPropertyDescriptor getPropertyAllDescriptor(@Nullable PsiElement context) {
        Collection<? extends CssPropertyDescriptor> allDescriptor = CssDescriptorsUtil.getPropertyDescriptors("all", context);
        if (allDescriptor.isEmpty() || !Objects.equals(allDescriptor.iterator().next().getInitialValue(), "see individual properties")) {
            return null;
        }
        return allDescriptor.iterator().next();
    }

    @NotNull
    public static Collection<? extends CssMediaFeatureDescriptor> getMediaFeatureDescriptors(@NotNull String featureName, @Nullable PsiElement context) {
        CssElementDescriptorProvider provider;
        if (featureName == null) {
            CssDescriptorsUtil.$$$reportNull$$$0(9);
        }
        Collection<Object> collection = (provider = CssDescriptorsUtil.findDescriptorProvider(context)) != null ? provider.findMediaFeatureDescriptors(featureName, context) : Collections.emptyList();
        if (collection == null) {
            CssDescriptorsUtil.$$$reportNull$$$0(10);
        }
        return collection;
    }

    @NotNull
    public static Collection<? extends CssMediaFeatureDescriptor> getAllMediaFeatureDescriptors(@Nullable PsiElement context) {
        CssElementDescriptorProvider provider = CssDescriptorsUtil.findDescriptorProvider(context);
        Collection<Object> collection = provider != null ? provider.getAllMediaFeatureDescriptors(context) : Collections.emptyList();
        if (collection == null) {
            CssDescriptorsUtil.$$$reportNull$$$0(11);
        }
        return collection;
    }

    @Deprecated
    @Nullable
    public static CssPropertyDescriptor getPropertyDescriptor(@NotNull String propertyName, @Nullable PsiElement context) {
        CssElementDescriptorProvider provider;
        if (propertyName == null) {
            CssDescriptorsUtil.$$$reportNull$$$0(12);
        }
        return (provider = CssDescriptorsUtil.findDescriptorProvider(context)) != null ? provider.getPropertyDescriptor(propertyName, context) : null;
    }

    public static boolean isPossibleSelector(@NotNull String selector, @NotNull PsiElement context) {
        CssElementDescriptorProvider provider;
        if (selector == null) {
            CssDescriptorsUtil.$$$reportNull$$$0(13);
        }
        if (context == null) {
            CssDescriptorsUtil.$$$reportNull$$$0(14);
        }
        return (provider = CssDescriptorsUtil.findDescriptorProvider(context)) == null || provider.isPossibleSelector(selector, context);
    }

    @NotNull
    public static Collection<LocalQuickFix> getQuickFixesForUnknownSimpleSelector(@NotNull String selectorName, @NotNull PsiElement context, boolean isOnTheFly) {
        CssElementDescriptorProvider[] providers;
        if (selectorName == null) {
            CssDescriptorsUtil.$$$reportNull$$$0(15);
        }
        if (context == null) {
            CssDescriptorsUtil.$$$reportNull$$$0(16);
        }
        HashSet<LocalQuickFix> result = new HashSet<LocalQuickFix>();
        for (CssElementDescriptorProvider provider : providers = (CssElementDescriptorProvider[])CssElementDescriptorProvider.EP_NAME.getExtensions()) {
            Collections.addAll(result, provider.getQuickFixesForUnknownSimpleSelector(selectorName, context, isOnTheFly));
        }
        HashSet<LocalQuickFix> hashSet = result;
        if (hashSet == null) {
            CssDescriptorsUtil.$$$reportNull$$$0(17);
        }
        return hashSet;
    }

    @NotNull
    public static Collection<LocalQuickFix> getQuickFixesForUnknownProperty(@NotNull String propertyName, @NotNull PsiElement context, boolean isOnTheFly) {
        CssElementDescriptorProvider[] providers;
        if (propertyName == null) {
            CssDescriptorsUtil.$$$reportNull$$$0(18);
        }
        if (context == null) {
            CssDescriptorsUtil.$$$reportNull$$$0(19);
        }
        HashSet<LocalQuickFix> result = new HashSet<LocalQuickFix>();
        for (CssElementDescriptorProvider provider : providers = (CssElementDescriptorProvider[])CssElementDescriptorProvider.EP_NAME.getExtensions()) {
            Collections.addAll(result, provider.getQuickFixesForUnknownProperty(propertyName, context, isOnTheFly));
        }
        HashSet<LocalQuickFix> hashSet = result;
        if (hashSet == null) {
            CssDescriptorsUtil.$$$reportNull$$$0(20);
        }
        return hashSet;
    }

    @NotNull
    public static Collection<? extends CssPseudoSelectorDescriptor> getAllPseudoSelectorDescriptors(@Nullable PsiElement context) {
        CssElementDescriptorProvider provider = CssDescriptorsUtil.findDescriptorProvider(context);
        Collection<Object> collection = provider != null ? provider.getAllPseudoSelectorDescriptors(context) : Collections.emptyList();
        if (collection == null) {
            CssDescriptorsUtil.$$$reportNull$$$0(21);
        }
        return collection;
    }

    @NotNull
    @NlsSafe
    public static String getCanonicalPropertyName(@NotNull CssDeclaration declaration) {
        String propertyName;
        CssPropertyDescriptor descriptor;
        if (declaration == null) {
            CssDescriptorsUtil.$$$reportNull$$$0(22);
        }
        String string = (descriptor = CssDescriptorsUtil.getPropertyDescriptor(propertyName = declaration.getPropertyName(), declaration)) != null ? descriptor.toCanonicalName(propertyName) : propertyName;
        if (string == null) {
            CssDescriptorsUtil.$$$reportNull$$$0(23);
        }
        return string;
    }

    @Nullable
    public static <T extends CssElementDescriptor> T getDescriptorFromLatestSpec(Collection<T> descriptors) {
        CssElementDescriptor result = null;
        for (CssElementDescriptor descriptor : descriptors) {
            if (result != null && descriptor.getCssVersion().value() < result.getCssVersion().value()) continue;
            result = descriptor;
        }
        return (T)result;
    }

    public static String @NotNull [] extractDescriptorsIdsAsArray(Collection<? extends CssElementDescriptor> descriptors) {
        String[] stringArray = (String[])ContainerUtil.map2Array(descriptors, String.class, GET_DESCRIPTOR_ID_FUNCTION);
        if (stringArray == null) {
            CssDescriptorsUtil.$$$reportNull$$$0(24);
        }
        return stringArray;
    }

    @NotNull
    public static <T extends CssMediaGroupAwareDescriptor> Collection<T> filterDescriptorsByMediaType(@NotNull Collection<T> descriptors, @Nullable PsiElement context) {
        Set<CssMediaType> allowedMediaTypes;
        if (descriptors == null) {
            CssDescriptorsUtil.$$$reportNull$$$0(25);
        }
        if ((allowedMediaTypes = CssPsiUtil.getAllowedMediaTypesInContext(context)).contains((Object)CssMediaType.ALL)) {
            Collection<T> collection = descriptors;
            if (collection == null) {
                CssDescriptorsUtil.$$$reportNull$$$0(26);
            }
            return collection;
        }
        boolean insidePageRule = false;
        CssAtRule atRule = (CssAtRule)PsiTreeUtil.getNonStrictParentOfType((PsiElement)context, (Class[])new Class[]{CssAtRule.class});
        while (atRule != null) {
            if (atRule.getType() == CssContextType.PAGE || atRule.getType() == CssContextType.PAGE_MARGIN) {
                insidePageRule = true;
                break;
            }
            atRule = (CssAtRule)PsiTreeUtil.getParentOfType((PsiElement)atRule, CssAtRule.class);
        }
        boolean finalInsidePageRule = insidePageRule;
        List list = ContainerUtil.filter(descriptors, t -> {
            for (CssMediaType mediaType : allowedMediaTypes) {
                CssMediaGroup[] propertyMediaGroups;
                for (CssMediaGroup propertyMediaGroup : propertyMediaGroups = t.getMediaGroups()) {
                    if (propertyMediaGroup != CssMediaGroup.ALL && (!finalInsidePageRule || propertyMediaGroup != CssMediaGroup.PAGED) && !ArrayUtil.contains((Object)((Object)propertyMediaGroup), (Object[])((Object[])mediaType.getSupportedGroups()))) continue;
                    return true;
                }
            }
            return false;
        });
        if (list == null) {
            CssDescriptorsUtil.$$$reportNull$$$0(27);
        }
        return list;
    }

    @NotNull
    public static <T extends CssElementDescriptor> Collection<T> filterDescriptorsByContext(@NotNull Collection<T> descriptors, @Nullable PsiElement context) {
        CssElementDescriptorProvider provider;
        CssContextType ruleType;
        if (descriptors == null) {
            CssDescriptorsUtil.$$$reportNull$$$0(28);
        }
        CssContextType cssContextType = ruleType = (provider = CssDescriptorsUtil.findDescriptorProvider(context)) != null ? provider.getCssContextType(context) : CssContextType.ANY;
        if (ruleType == CssContextType.ANY) {
            Collection<T> collection = descriptors;
            if (collection == null) {
                CssDescriptorsUtil.$$$reportNull$$$0(29);
            }
            return collection;
        }
        List list = ContainerUtil.filter(descriptors, input -> input.isAllowedInContextType(ruleType));
        if (list == null) {
            CssDescriptorsUtil.$$$reportNull$$$0(30);
        }
        return list;
    }

    public static Collection<CssPseudoSelectorDescriptor> filterPseudoSelectorDescriptorsByColonPrefix(Collection<? extends CssPseudoSelectorDescriptor> descriptors, int prefixLength) {
        return ContainerUtil.filter(descriptors, input -> input.getColonPrefixLength() == prefixLength);
    }

    @NotNull
    public static <T extends CssElementDescriptor> Collection<T> sortDescriptors(@NotNull Collection<T> descriptors) {
        if (descriptors == null) {
            CssDescriptorsUtil.$$$reportNull$$$0(31);
        }
        if (descriptors.size() <= 1) {
            Collection<T> collection = descriptors;
            if (collection == null) {
                CssDescriptorsUtil.$$$reportNull$$$0(32);
            }
            return collection;
        }
        List list = ContainerUtil.sorted(descriptors, (Comparator)new CssVersionDescriptorComparator());
        if (list == null) {
            CssDescriptorsUtil.$$$reportNull$$$0(33);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 4, 6, 8, 10, 11, 17, 20, 21, 23, 24, 26, 27, 29, 30, 32, 33 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 17: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 32: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/impl/util/table/CssDescriptorsUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pseudoSelectorName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionName";
                break;
            }
            case 7: 
            case 12: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "featureName";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selector";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectorName";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 25: 
            case 28: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/impl/util/table/CssDescriptorsUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSimpleSelectors";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllPropertyDescriptors";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPseudoSelectorDescriptors";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionDescriptors";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyDescriptors";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getMediaFeatureDescriptors";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllMediaFeatureDescriptors";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuickFixesForUnknownSimpleSelector";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuickFixesForUnknownProperty";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllPseudoSelectorDescriptors";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalPropertyName";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "extractDescriptorsIdsAsArray";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "filterDescriptorsByMediaType";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "filterDescriptorsByContext";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "sortDescriptors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSimpleSelectors";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 17: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 32: 
            case 33: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPseudoSelectorDescriptors";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionDescriptors";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyDescriptors";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getMediaFeatureDescriptors";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyDescriptor";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isPossibleSelector";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getQuickFixesForUnknownSimpleSelector";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getQuickFixesForUnknownProperty";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getCanonicalPropertyName";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "filterDescriptorsByMediaType";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "filterDescriptorsByContext";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "sortDescriptors";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 4, 6, 8, 10, 11, 17, 20, 21, 23, 24, 26, 27, 29, 30, 32, 33 -> new IllegalStateException(string);
        };
    }

    private static class CompositeCssElementDescriptorProvider
    extends CssElementDescriptorProvider {
        private final List<? extends CssElementDescriptorProvider> myProviders;

        CompositeCssElementDescriptorProvider(List<? extends CssElementDescriptorProvider> providers) {
            this.myProviders = providers;
        }

        @Override
        public boolean isMyContext(@Nullable PsiElement context) {
            for (CssElementDescriptorProvider cssElementDescriptorProvider : this.myProviders) {
                if (!cssElementDescriptorProvider.isMyContext(context)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean skipCssPropertyCheck(@NotNull CssDeclaration declaration) {
            if (declaration == null) {
                CompositeCssElementDescriptorProvider.$$$reportNull$$$0(0);
            }
            for (CssElementDescriptorProvider cssElementDescriptorProvider : this.myProviders) {
                if (!cssElementDescriptorProvider.skipCssPropertyCheck(declaration)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean skipUnknownAtRuleCheck(@NotNull CssAtRule atRule) {
            if (atRule == null) {
                CompositeCssElementDescriptorProvider.$$$reportNull$$$0(1);
            }
            for (CssElementDescriptorProvider cssElementDescriptorProvider : this.myProviders) {
                if (!cssElementDescriptorProvider.skipUnknownAtRuleCheck(atRule)) continue;
                return true;
            }
            return false;
        }

        @Override
        @NotNull
        public String restoreFullPropertyName(@NotNull String propertyName, @Nullable PsiElement context) {
            if (propertyName == null) {
                CompositeCssElementDescriptorProvider.$$$reportNull$$$0(2);
            }
            for (CssElementDescriptorProvider cssElementDescriptorProvider : this.myProviders) {
                String restored = cssElementDescriptorProvider.restoreFullPropertyName(propertyName, context);
                if (restored.equals(propertyName)) continue;
                String string = restored;
                if (string == null) {
                    CompositeCssElementDescriptorProvider.$$$reportNull$$$0(3);
                }
                return string;
            }
            String string = propertyName;
            if (string == null) {
                CompositeCssElementDescriptorProvider.$$$reportNull$$$0(4);
            }
            return string;
        }

        @Override
        @Nullable
        public CssPropertyDescriptor getPropertyDescriptor(@NotNull String propertyName, @Nullable PsiElement context) {
            if (propertyName == null) {
                CompositeCssElementDescriptorProvider.$$$reportNull$$$0(5);
            }
            for (CssElementDescriptorProvider cssElementDescriptorProvider : this.myProviders) {
                CssPropertyDescriptor descriptor = cssElementDescriptorProvider.getPropertyDescriptor(propertyName, context);
                if (descriptor == null) continue;
                return descriptor;
            }
            return null;
        }

        @Override
        @NotNull
        public Collection<? extends CssPseudoSelectorDescriptor> findPseudoSelectorDescriptors(@NotNull String name, @Nullable PsiElement context) {
            if (name == null) {
                CompositeCssElementDescriptorProvider.$$$reportNull$$$0(6);
            }
            HashSet<? extends CssPseudoSelectorDescriptor> result = new HashSet<CssPseudoSelectorDescriptor>();
            for (CssElementDescriptorProvider cssElementDescriptorProvider : this.myProviders) {
                result.addAll(cssElementDescriptorProvider.findPseudoSelectorDescriptors(name, context));
            }
            HashSet<? extends CssPseudoSelectorDescriptor> hashSet = result;
            if (hashSet == null) {
                CompositeCssElementDescriptorProvider.$$$reportNull$$$0(7);
            }
            return hashSet;
        }

        @Override
        @NotNull
        public Collection<? extends CssValueDescriptor> getNamedValueDescriptors(@NotNull String name, @Nullable CssValueDescriptor parent) {
            if (name == null) {
                CompositeCssElementDescriptorProvider.$$$reportNull$$$0(8);
            }
            HashSet<? extends CssValueDescriptor> result = new HashSet<CssValueDescriptor>();
            for (CssElementDescriptorProvider cssElementDescriptorProvider : this.myProviders) {
                result.addAll(cssElementDescriptorProvider.getNamedValueDescriptors(name, parent));
            }
            HashSet<? extends CssValueDescriptor> hashSet = result;
            if (hashSet == null) {
                CompositeCssElementDescriptorProvider.$$$reportNull$$$0(9);
            }
            return hashSet;
        }

        @Override
        @NotNull
        public Collection<? extends CssPropertyDescriptor> findPropertyDescriptors(@NotNull String propertyName, PsiElement context) {
            if (propertyName == null) {
                CompositeCssElementDescriptorProvider.$$$reportNull$$$0(10);
            }
            HashSet<? extends CssPropertyDescriptor> result = new HashSet<CssPropertyDescriptor>();
            for (CssElementDescriptorProvider cssElementDescriptorProvider : this.myProviders) {
                result.addAll(cssElementDescriptorProvider.findPropertyDescriptors(propertyName, context));
            }
            HashSet<? extends CssPropertyDescriptor> hashSet = result;
            if (hashSet == null) {
                CompositeCssElementDescriptorProvider.$$$reportNull$$$0(11);
            }
            return hashSet;
        }

        @Override
        @NotNull
        public Collection<? extends CssFunctionDescriptor> findFunctionDescriptors(@NotNull String functionName, @Nullable PsiElement context) {
            if (functionName == null) {
                CompositeCssElementDescriptorProvider.$$$reportNull$$$0(12);
            }
            HashSet<? extends CssFunctionDescriptor> result = new HashSet<CssFunctionDescriptor>();
            for (CssElementDescriptorProvider cssElementDescriptorProvider : this.myProviders) {
                result.addAll(cssElementDescriptorProvider.findFunctionDescriptors(functionName, context));
            }
            HashSet<? extends CssFunctionDescriptor> hashSet = result;
            if (hashSet == null) {
                CompositeCssElementDescriptorProvider.$$$reportNull$$$0(13);
            }
            return hashSet;
        }

        @Override
        @NotNull
        public Collection<? extends CssMediaFeatureDescriptor> findMediaFeatureDescriptors(@NotNull String mediaFeatureName, @Nullable PsiElement context) {
            if (mediaFeatureName == null) {
                CompositeCssElementDescriptorProvider.$$$reportNull$$$0(14);
            }
            HashSet<? extends CssMediaFeatureDescriptor> result = new HashSet<CssMediaFeatureDescriptor>();
            for (CssElementDescriptorProvider cssElementDescriptorProvider : this.myProviders) {
                result.addAll(cssElementDescriptorProvider.findMediaFeatureDescriptors(mediaFeatureName, context));
            }
            HashSet<? extends CssMediaFeatureDescriptor> hashSet = result;
            if (hashSet == null) {
                CompositeCssElementDescriptorProvider.$$$reportNull$$$0(15);
            }
            return hashSet;
        }

        @Override
        public boolean isPossibleSelector(@NotNull String selector, @NotNull PsiElement context) {
            if (selector == null) {
                CompositeCssElementDescriptorProvider.$$$reportNull$$$0(16);
            }
            if (context == null) {
                CompositeCssElementDescriptorProvider.$$$reportNull$$$0(17);
            }
            for (CssElementDescriptorProvider cssElementDescriptorProvider : this.myProviders) {
                if (!cssElementDescriptorProvider.isPossibleSelector(selector, context)) continue;
                return true;
            }
            return false;
        }

        @Override
        @NotNull
        public Collection<? extends CssPseudoSelectorDescriptor> getAllPseudoSelectorDescriptors(@Nullable PsiElement context) {
            HashSet<? extends CssPseudoSelectorDescriptor> result = new HashSet<CssPseudoSelectorDescriptor>();
            for (CssElementDescriptorProvider cssElementDescriptorProvider : this.myProviders) {
                result.addAll(cssElementDescriptorProvider.getAllPseudoSelectorDescriptors(context));
            }
            HashSet<? extends CssPseudoSelectorDescriptor> hashSet = result;
            if (hashSet == null) {
                CompositeCssElementDescriptorProvider.$$$reportNull$$$0(18);
            }
            return hashSet;
        }

        @Override
        @NotNull
        public Collection<? extends CssPropertyDescriptor> getAllPropertyDescriptors(@Nullable PsiElement context) {
            HashSet<? extends CssPropertyDescriptor> result = new HashSet<CssPropertyDescriptor>();
            for (CssElementDescriptorProvider cssElementDescriptorProvider : this.myProviders) {
                result.addAll(cssElementDescriptorProvider.getAllPropertyDescriptors(context));
            }
            HashSet<? extends CssPropertyDescriptor> hashSet = result;
            if (hashSet == null) {
                CompositeCssElementDescriptorProvider.$$$reportNull$$$0(19);
            }
            return hashSet;
        }

        @Override
        @NotNull
        public Collection<? extends CssMediaFeatureDescriptor> getAllMediaFeatureDescriptors(@Nullable PsiElement context) {
            HashSet<? extends CssMediaFeatureDescriptor> result = new HashSet<CssMediaFeatureDescriptor>();
            for (CssElementDescriptorProvider cssElementDescriptorProvider : this.myProviders) {
                result.addAll(cssElementDescriptorProvider.getAllMediaFeatureDescriptors(context));
            }
            HashSet<? extends CssMediaFeatureDescriptor> hashSet = result;
            if (hashSet == null) {
                CompositeCssElementDescriptorProvider.$$$reportNull$$$0(20);
            }
            return hashSet;
        }

        @Override
        public String @NotNull [] getSimpleSelectors(@NotNull PsiElement context) {
            if (context == null) {
                CompositeCssElementDescriptorProvider.$$$reportNull$$$0(21);
            }
            HashSet result = new HashSet();
            for (CssElementDescriptorProvider cssElementDescriptorProvider : this.myProviders) {
                Collections.addAll(result, cssElementDescriptorProvider.getSimpleSelectors(context));
            }
            String[] stringArray = ArrayUtilRt.toStringArray(result);
            if (stringArray == null) {
                CompositeCssElementDescriptorProvider.$$$reportNull$$$0(22);
            }
            return stringArray;
        }

        @Override
        public PsiElement @NotNull [] getDeclarationsForSimpleSelector(@NotNull CssSimpleSelector selector) {
            if (selector == null) {
                CompositeCssElementDescriptorProvider.$$$reportNull$$$0(23);
            }
            for (CssElementDescriptorProvider cssElementDescriptorProvider : this.myProviders) {
                PsiElement[] declarations = cssElementDescriptorProvider.getDeclarationsForSimpleSelector(selector);
                if (declarations.length == 0) continue;
                if (declarations == null) {
                    CompositeCssElementDescriptorProvider.$$$reportNull$$$0(24);
                }
                return declarations;
            }
            if (PsiElement.EMPTY_ARRAY == null) {
                CompositeCssElementDescriptorProvider.$$$reportNull$$$0(25);
            }
            return PsiElement.EMPTY_ARRAY;
        }

        @Override
        public boolean providesClassicCss() {
            for (CssElementDescriptorProvider cssElementDescriptorProvider : this.myProviders) {
                if (cssElementDescriptorProvider.providesClassicCss()) continue;
                return false;
            }
            return true;
        }

        @Override
        @Nullable
        public PsiElement getDocumentationElementForSelector(@NotNull String selectorName, @Nullable PsiElement context) {
            if (selectorName == null) {
                CompositeCssElementDescriptorProvider.$$$reportNull$$$0(26);
            }
            for (CssElementDescriptorProvider cssElementDescriptorProvider : this.myProviders) {
                PsiElement element = cssElementDescriptorProvider.getDocumentationElementForSelector(selectorName, context);
                if (element == null) continue;
                return element;
            }
            return null;
        }

        @Override
        @Nullable
        public String generateDocForSelector(@NotNull String selectorName, @Nullable PsiElement context) {
            if (selectorName == null) {
                CompositeCssElementDescriptorProvider.$$$reportNull$$$0(27);
            }
            for (CssElementDescriptorProvider cssElementDescriptorProvider : this.myProviders) {
                String doc = cssElementDescriptorProvider.generateDocForSelector(selectorName, context);
                if (doc == null) continue;
                return doc;
            }
            return null;
        }

        @Override
        @Nullable
        public Color getColorByValue(@NotNull String value) {
            if (value == null) {
                CompositeCssElementDescriptorProvider.$$$reportNull$$$0(28);
            }
            for (CssElementDescriptorProvider cssElementDescriptorProvider : this.myProviders) {
                Color color = cssElementDescriptorProvider.getColorByValue(value);
                if (color == null) continue;
                return color;
            }
            return null;
        }

        @Override
        public boolean isColorTerm(@NotNull CssTerm term) {
            if (term == null) {
                CompositeCssElementDescriptorProvider.$$$reportNull$$$0(29);
            }
            for (CssElementDescriptorProvider cssElementDescriptorProvider : this.myProviders) {
                if (!cssElementDescriptorProvider.isColorTerm(term)) continue;
                return true;
            }
            return false;
        }

        @Override
        public LocalQuickFix @NotNull [] getQuickFixesForUnknownProperty(@NotNull String propertyName, @NotNull PsiElement context, boolean isOnTheFly) {
            if (propertyName == null) {
                CompositeCssElementDescriptorProvider.$$$reportNull$$$0(30);
            }
            if (context == null) {
                CompositeCssElementDescriptorProvider.$$$reportNull$$$0(31);
            }
            HashSet quickFixes = new HashSet();
            for (CssElementDescriptorProvider cssElementDescriptorProvider : this.myProviders) {
                Collections.addAll(quickFixes, cssElementDescriptorProvider.getQuickFixesForUnknownProperty(propertyName, context, isOnTheFly));
            }
            LocalQuickFix[] localQuickFixArray = quickFixes.toArray(LocalQuickFix.EMPTY_ARRAY);
            if (localQuickFixArray == null) {
                CompositeCssElementDescriptorProvider.$$$reportNull$$$0(32);
            }
            return localQuickFixArray;
        }

        @Override
        public LocalQuickFix @NotNull [] getQuickFixesForUnknownSimpleSelector(@NotNull String selectorName, @NotNull PsiElement context, boolean isOnTheFly) {
            if (selectorName == null) {
                CompositeCssElementDescriptorProvider.$$$reportNull$$$0(33);
            }
            if (context == null) {
                CompositeCssElementDescriptorProvider.$$$reportNull$$$0(34);
            }
            HashSet quickFixes = new HashSet();
            for (CssElementDescriptorProvider cssElementDescriptorProvider : this.myProviders) {
                Collections.addAll(quickFixes, cssElementDescriptorProvider.getQuickFixesForUnknownSimpleSelector(selectorName, context, isOnTheFly));
            }
            LocalQuickFix[] localQuickFixArray = quickFixes.toArray(LocalQuickFix.EMPTY_ARRAY);
            if (localQuickFixArray == null) {
                CompositeCssElementDescriptorProvider.$$$reportNull$$$0(35);
            }
            return localQuickFixArray;
        }

        @Override
        public boolean isColorTermsSupported() {
            for (CssElementDescriptorProvider cssElementDescriptorProvider : this.myProviders) {
                if (cssElementDescriptorProvider.isColorTermsSupported()) continue;
                return false;
            }
            return true;
        }

        @Override
        public CssContextType getCssContextType(@Nullable PsiElement context) {
            for (CssElementDescriptorProvider cssElementDescriptorProvider : this.myProviders) {
                CssContextType ruleType = cssElementDescriptorProvider.getCssContextType(context);
                if (ruleType == CssContextType.ANY) continue;
                return ruleType;
            }
            return CssContextType.ANY;
        }

        @Override
        @NotNull
        public PsiReference getStyleReference(PsiElement element, int start, int end, boolean caseSensitive) {
            for (CssElementDescriptorProvider cssElementDescriptorProvider : this.myProviders) {
                PsiReference reference = cssElementDescriptorProvider.getStyleReference(element, start, end, caseSensitive);
                if (reference instanceof CssStyleReferenceStub) continue;
                PsiReference psiReference = reference;
                if (psiReference == null) {
                    CompositeCssElementDescriptorProvider.$$$reportNull$$$0(36);
                }
                return psiReference;
            }
            return new CssStyleReferenceStub(element, TextRange.create((int)start, (int)end));
        }

        @Override
        @NotNull
        public CssValueValidator getValueValidator() {
            for (CssElementDescriptorProvider cssElementDescriptorProvider : this.myProviders) {
                CssValueValidator validator = cssElementDescriptorProvider.getValueValidator();
                if (validator instanceof CssValueValidatorStub) continue;
                CssValueValidator cssValueValidator = validator;
                if (cssValueValidator == null) {
                    CompositeCssElementDescriptorProvider.$$$reportNull$$$0(37);
                }
                return cssValueValidator;
            }
            CssValueValidator cssValueValidator = super.getValueValidator();
            if (cssValueValidator == null) {
                CompositeCssElementDescriptorProvider.$$$reportNull$$$0(38);
            }
            return cssValueValidator;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4, 7, 9, 11, 13, 15, 18, 19, 20, 22, 24, 25, 32, 35, 36, 37, 38 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "declaration";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "atRule";
                    break;
                }
                case 2: 
                case 5: 
                case 10: 
                case 30: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "propertyName";
                    break;
                }
                case 3: 
                case 4: 
                case 7: 
                case 9: 
                case 11: 
                case 13: 
                case 15: 
                case 18: 
                case 19: 
                case 20: 
                case 22: 
                case 24: 
                case 25: 
                case 32: 
                case 35: 
                case 36: 
                case 37: 
                case 38: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/css/impl/util/table/CssDescriptorsUtil$CompositeCssElementDescriptorProvider";
                    break;
                }
                case 6: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "functionName";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mediaFeatureName";
                    break;
                }
                case 16: 
                case 23: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selector";
                    break;
                }
                case 17: 
                case 21: 
                case 31: 
                case 34: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 26: 
                case 27: 
                case 33: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selectorName";
                    break;
                }
                case 28: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 29: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "term";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/css/impl/util/table/CssDescriptorsUtil$CompositeCssElementDescriptorProvider";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "restoreFullPropertyName";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "findPseudoSelectorDescriptors";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNamedValueDescriptors";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "findPropertyDescriptors";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "findFunctionDescriptors";
                    break;
                }
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[1] = "findMediaFeatureDescriptors";
                    break;
                }
                case 18: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAllPseudoSelectorDescriptors";
                    break;
                }
                case 19: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAllPropertyDescriptors";
                    break;
                }
                case 20: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAllMediaFeatureDescriptors";
                    break;
                }
                case 22: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSimpleSelectors";
                    break;
                }
                case 24: 
                case 25: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDeclarationsForSimpleSelector";
                    break;
                }
                case 32: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getQuickFixesForUnknownProperty";
                    break;
                }
                case 35: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getQuickFixesForUnknownSimpleSelector";
                    break;
                }
                case 36: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStyleReference";
                    break;
                }
                case 37: 
                case 38: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValueValidator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "skipCssPropertyCheck";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "skipUnknownAtRuleCheck";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "restoreFullPropertyName";
                    break;
                }
                case 3: 
                case 4: 
                case 7: 
                case 9: 
                case 11: 
                case 13: 
                case 15: 
                case 18: 
                case 19: 
                case 20: 
                case 22: 
                case 24: 
                case 25: 
                case 32: 
                case 35: 
                case 36: 
                case 37: 
                case 38: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getPropertyDescriptor";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "findPseudoSelectorDescriptors";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "getNamedValueDescriptors";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "findPropertyDescriptors";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "findFunctionDescriptors";
                    break;
                }
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "findMediaFeatureDescriptors";
                    break;
                }
                case 16: 
                case 17: {
                    objectArray = objectArray;
                    objectArray[2] = "isPossibleSelector";
                    break;
                }
                case 21: {
                    objectArray = objectArray;
                    objectArray[2] = "getSimpleSelectors";
                    break;
                }
                case 23: {
                    objectArray = objectArray;
                    objectArray[2] = "getDeclarationsForSimpleSelector";
                    break;
                }
                case 26: {
                    objectArray = objectArray;
                    objectArray[2] = "getDocumentationElementForSelector";
                    break;
                }
                case 27: {
                    objectArray = objectArray;
                    objectArray[2] = "generateDocForSelector";
                    break;
                }
                case 28: {
                    objectArray = objectArray;
                    objectArray[2] = "getColorByValue";
                    break;
                }
                case 29: {
                    objectArray = objectArray;
                    objectArray[2] = "isColorTerm";
                    break;
                }
                case 30: 
                case 31: {
                    objectArray = objectArray;
                    objectArray[2] = "getQuickFixesForUnknownProperty";
                    break;
                }
                case 33: 
                case 34: {
                    objectArray = objectArray;
                    objectArray[2] = "getQuickFixesForUnknownSimpleSelector";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4, 7, 9, 11, 13, 15, 18, 19, 20, 22, 24, 25, 32, 35, 36, 37, 38 -> new IllegalStateException(string);
            };
        }
    }
}

