/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.reflect.KClassifier;
import kotlin.reflect.KType;
import kotlin.reflect.full.KClasses;
import kotlin.reflect.full.KTypes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.dataframe.DataColumn;
import org.jetbrains.kotlinx.dataframe.DataFrame;
import org.jetbrains.kotlinx.dataframe.DataRow;
import org.jetbrains.kotlinx.dataframe.api.ConcatKt;
import org.jetbrains.kotlinx.dataframe.api.TypeConversionsKt;
import org.jetbrains.kotlinx.dataframe.columns.ColumnGroup;
import org.jetbrains.kotlinx.dataframe.columns.FrameColumn;
import org.jetbrains.kotlinx.dataframe.columns.ValueColumn;
import org.jetbrains.kotlinx.dataframe.impl.DataCollector;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b \u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0015\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0018J\u001e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00000\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0004R(\u0010\u0006\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0007j\n\u0012\u0006\u0012\u0004\u0018\u00018\u0000`\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0019\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlinx/dataframe/impl/DataCollectorBase;", "T", "Lorg/jetbrains/kotlinx/dataframe/impl/DataCollector;", "initCapacity", "", "(I)V", "data", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "getData", "()Ljava/util/ArrayList;", "hasNulls", "", "getHasNulls", "()Z", "setHasNulls", "(Z)V", "values", "", "getValues", "()Ljava/util/List;", "add", "", "value", "(Ljava/lang/Object;)V", "createColumn", "Lorg/jetbrains/kotlinx/dataframe/DataColumn;", "name", "", "type", "Lkotlin/reflect/KType;", "core"})
@SourceDebugExtension(value={"SMAP\nColumnDataCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ColumnDataCollector.kt\norg/jetbrains/kotlinx/dataframe/impl/DataCollectorBase\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,76:1\n1549#2:77\n1620#2,3:78\n*S KotlinDebug\n*F\n+ 1 ColumnDataCollector.kt\norg/jetbrains/kotlinx/dataframe/impl/DataCollectorBase\n*L\n45#1:77\n45#1:78,3\n*E\n"})
public abstract class DataCollectorBase<T>
implements DataCollector<T> {
    private boolean hasNulls;
    @NotNull
    private final ArrayList<T> data;

    public DataCollectorBase(int initCapacity) {
        this.data = new ArrayList(initCapacity);
    }

    @Override
    public boolean getHasNulls() {
        return this.hasNulls;
    }

    public void setHasNulls(boolean bl) {
        this.hasNulls = bl;
    }

    @Override
    @NotNull
    public ArrayList<T> getData() {
        return this.data;
    }

    @NotNull
    public final List<T> getValues() {
        return this.getData();
    }

    @Override
    public void add(T value) {
        if (value == null) {
            this.setHasNulls(true);
        }
        ((ArrayList)this.getData()).add(value);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final DataColumn<T> createColumn(@NotNull String name, @NotNull KType type) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        KClassifier kClassifier = type.getClassifier();
        Intrinsics.checkNotNull((Object)kClassifier, (String)"null cannot be cast to non-null type kotlin.reflect.KClass<*>");
        KClass classifier = (KClass)kClassifier;
        if (KClasses.isSubclassOf((KClass)classifier, (KClass)Reflection.getOrCreateKotlinClass(DataFrame.class)) && !this.getHasNulls()) {
            List list = this.getData();
            Intrinsics.checkNotNull((Object)list, (String)"null cannot be cast to non-null type kotlin.collections.List<org.jetbrains.kotlinx.dataframe.DataFrame<*>{ org.jetbrains.kotlinx.dataframe.AliasesKt.AnyFrame }>");
            FrameColumn frameColumn = DataColumn.Companion.createFrameColumn$default(DataColumn.Companion, name, list, null, 4, null);
            Intrinsics.checkNotNull((Object)frameColumn, (String)"null cannot be cast to non-null type org.jetbrains.kotlinx.dataframe.DataColumn<T of org.jetbrains.kotlinx.dataframe.impl.DataCollectorBase>");
            return frameColumn;
        }
        if (KClasses.isSubclassOf((KClass)classifier, (KClass)Reflection.getOrCreateKotlinClass(DataRow.class)) && !this.getHasNulls()) {
            void $this$mapTo$iv$iv;
            List list = this.getData();
            Intrinsics.checkNotNull((Object)list, (String)"null cannot be cast to non-null type kotlin.collections.List<org.jetbrains.kotlinx.dataframe.DataRow<*>{ org.jetbrains.kotlinx.dataframe.AliasesKt.AnyRow }>");
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                DataRow dataRow = (DataRow)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(TypeConversionsKt.toDataFrame(it));
            }
            DataFrame mergedDf = ConcatKt.concat((List)destination$iv$iv);
            ColumnGroup columnGroup = DataColumn.Companion.createColumnGroup(name, mergedDf);
            Intrinsics.checkNotNull(columnGroup, (String)"null cannot be cast to non-null type org.jetbrains.kotlinx.dataframe.DataColumn<T of org.jetbrains.kotlinx.dataframe.impl.DataCollectorBase>");
            return (DataColumn)((Object)columnGroup);
        }
        ValueColumn valueColumn2 = DataColumn.Companion.createValueColumn$default(DataColumn.Companion, name, this.getData(), KTypes.withNullability((KType)type, (boolean)this.getHasNulls()), null, null, 24, null);
        Intrinsics.checkNotNull((Object)valueColumn2, (String)"null cannot be cast to non-null type org.jetbrains.kotlinx.dataframe.DataColumn<T of org.jetbrains.kotlinx.dataframe.impl.DataCollectorBase>");
        return valueColumn2;
    }
}

