/*
 * Decompiled with CFR 0.152.
 */
package org.jrubyparser.ast;

import java.util.List;
import org.jrubyparser.NodeVisitor;
import org.jrubyparser.SourcePosition;
import org.jrubyparser.ast.AssignableNode;
import org.jrubyparser.ast.ListNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;
import org.jrubyparser.util.NodePair;
import org.jrubyparser.util.StaticAnalyzerHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipleAsgnNode
extends AssignableNode {
    private ListNode pre;
    private Node rest;
    private ListNode post;

    public MultipleAsgnNode(SourcePosition position, ListNode pre, Node rest) {
        this(position, pre, rest, null);
    }

    public MultipleAsgnNode(SourcePosition position, ListNode pre, Node rest, ListNode post) {
        super(position);
        this.pre = (ListNode)this.adopt(pre);
        this.rest = this.adopt(rest);
        this.post = (ListNode)this.adopt(post);
        assert (pre != null || rest != null) : "pre or rest must exist in a multipleasgn19node";
    }

    @Override
    public boolean isSame(Node node) {
        if (!super.isSame(node)) {
            return false;
        }
        MultipleAsgnNode other = (MultipleAsgnNode)node;
        if (this.getPreCount() != other.getPreCount() || this.getPostCount() != other.getPostCount()) {
            return false;
        }
        if (this.getRest() == null && other.getRest() == null) {
            List<Node> kids = this.childNodes();
            List<Node> otherKids = other.childNodes();
            for (int i = 0; i < kids.size(); ++i) {
                if (kids.get(i).isSame(otherKids.get(i))) continue;
                return false;
            }
            return true;
        }
        if (this.getRest() == null || other.getRest() == null) {
            return false;
        }
        if (!this.getRest().isSame(other.getRest())) {
            return false;
        }
        List<Node> kids = this.childNodes();
        List<Node> otherKids = other.childNodes();
        for (int i = 0; i < kids.size(); ++i) {
            if (kids.get(i).isSame(otherKids.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.MULTIPLEASGNNODE;
    }

    @Override
    public Object accept(NodeVisitor iVisitor) {
        return iVisitor.visitMultipleAsgnNode(this);
    }

    public Node getRest() {
        return this.rest;
    }

    public ListNode getPre() {
        return this.pre;
    }

    public int getPreCount() {
        return this.pre == null ? 0 : this.pre.size();
    }

    public int getPostCount() {
        return this.post == null ? 0 : this.post.size();
    }

    public ListNode getPost() {
        return this.post;
    }

    public int getRequiredCount() {
        return this.getPreCount() + this.getPostCount();
    }

    public List<NodePair> calculateStaticAssignments() {
        return StaticAnalyzerHelper.calculateStaticAssignments(this, this.getValue());
    }

    @Override
    public SourcePosition getLeftHandSidePosition() {
        SourcePosition leftPosition = null;
        if (this.getPreCount() > 0) {
            leftPosition = this.getPre().getPosition();
        }
        if (leftPosition == null && this.getRest() != null) {
            leftPosition = this.getRest().getPosition();
        }
        if (this.getPostCount() > 0) {
            return leftPosition.union(this.getPost().getPosition());
        }
        if (this.getRest() != null && leftPosition != this.getRest().getPosition()) {
            return leftPosition.union(this.getRest().getPosition());
        }
        return leftPosition;
    }
}

