/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.ui;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.database.DatabaseDataKeysCore;
import com.intellij.database.Dbms;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.basic.BasicDataObject;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.meta.BasicMetaId;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.schemaEditor.ElementIdentity;
import com.intellij.database.schemaEditor.ElementMatcher;
import com.intellij.database.schemaEditor.ElementOwner;
import com.intellij.database.schemaEditor.model.DbEditorModelController;
import com.intellij.database.schemaEditor.model.state.DbModelState;
import com.intellij.database.schemaEditor.owner.ElementMatcherImpl;
import com.intellij.database.schemaEditor.ui.AutoSelectListener;
import com.intellij.database.schemaEditor.ui.DbEditor;
import com.intellij.database.schemaEditor.ui.DbEditorController;
import com.intellij.database.schemaEditor.ui.ManualPopupButton;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.util.SearchPath;
import com.intellij.database.view.DatabaseDialogsHelper;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlCodeFragment;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.ui.EditorTextField;
import com.intellij.util.textCompletion.TextCompletionUtil;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000z\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\u001e\u0010\u0003\u001a\u00020\u00012\u000e\u0010\u0004\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00052\u0006\u0010\u0006\u001a\u00020\u0002\u001a$\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u000e\u0010\u0004\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0005H\u0002\u001a\u001e\u0010\u000b\u001a\u00020\u00012\u000e\u0010\u0004\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00052\u0006\u0010\u0006\u001a\u00020\u0002\u001a.\u0010\f\u001a\u0004\u0018\u00010\r\"\b\b\u0000\u0010\u000e*\u00020\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u000e\u0010\u0011\u001a\n\u0012\u0004\u0012\u0002H\u000e\u0018\u00010\u0012H\u0002\u001a\u0017\u0010\u0013\u001a\t\u0018\u00010\u0014\u00a2\u0006\u0002\b\u00152\u0006\u0010\u0006\u001a\u00020\u0002H\u0002\u001a\u0016\u0010\u0016\u001a\u00020\u00022\u000e\u0010\u0004\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0005\u001a\u0016\u0010\u0017\u001a\u00020\u00022\u000e\u0010\u0004\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0005\u001a\u0016\u0010\u0018\u001a\u00020\u00022\u000e\u0010\u0004\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0005\u001a\u001e\u0010\u0019\u001a\u00020\u00012\u000e\u0010\u0004\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00052\u0006\u0010\u0006\u001a\u00020\u0002\u001a\u001e\u0010\u001a\u001a\u00020\u00142\u000e\u0010\u0004\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00052\u0006\u0010\u001b\u001a\u00020\u001c\u001a\u0010\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u0014H\u0002\u001a\u0010\u0010\u001f\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u0014H\u0002\u001a<\u0010 \u001a\n\u0012\u0004\u0012\u0002H\u000e\u0018\u00010\u0012\"\b\b\u0000\u0010\u000e*\u00020\r2\u0006\u0010!\u001a\u00020\"2\f\u0010#\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00122\f\u0010$\u001a\b\u0012\u0004\u0012\u0002H\u000e0%\u001a.\u0010&\u001a\u00020'2\u0006\u0010!\u001a\u00020\"2\n\u0010(\u001a\u0006\u0012\u0002\b\u00030\u00122\n\u0010#\u001a\u0006\u0012\u0002\b\u00030\u00122\u0006\u0010)\u001a\u00020'\u001a,\u0010*\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00122\u0006\u0010!\u001a\u00020\"2\n\u0010+\u001a\u0006\u0012\u0002\b\u00030\u00122\n\u0010#\u001a\u0006\u0012\u0002\b\u00030\u0012\u001a6\u0010,\u001a\u0004\u0018\u0001H-\"\n\b\u0000\u0010-\u0018\u0001*\u00020.*\u00020/2\f\u0010#\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00122\u0006\u00100\u001a\u000201H\u0086\b\u00a2\u0006\u0002\u00102\u001a\u0018\u00103\u001a\u00020'*\u00020/2\f\u0010#\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0012\u001a\u0018\u00103\u001a\u00020'*\u0002042\f\u0010#\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0012\u00a8\u00065"}, d2={"enableAutoPopup", "", "Lcom/intellij/ui/EditorTextField;", "initCompletion", "editor", "Lcom/intellij/database/schemaEditor/ui/DbEditor;", "field", "getSearchPath", "Lcom/intellij/database/util/SearchPath;", "dbDataSource", "Lcom/intellij/database/psi/DbDataSource;", "setCompletionContext", "findHierarchical", "Lcom/intellij/database/model/basic/BasicElement;", "T", "owner", "Lcom/intellij/database/schemaEditor/ElementOwner;", "identity", "Lcom/intellij/database/schemaEditor/ElementIdentity;", "getPsiFile", "Lcom/intellij/psi/PsiFile;", "Lorg/jetbrains/annotations/Nullable;", "createTypeEditorField", "createExpressionEditorField", "createBigSqlEditorField", "updateSqlEditorField", "createSqlFile", "text", "", "createFragmentEditorWithCompletion", "fragment", "createFragmentEditor", "skipTo", "matcher", "Lcom/intellij/database/schemaEditor/ElementMatcher;", "id", "clazz", "Ljava/lang/Class;", "isAncestor", "", "ancestorId", "strict", "getAncestorUnder", "underId", "resolveState", "S", "Lcom/intellij/database/schemaEditor/model/state/DbModelState;", "Lcom/intellij/database/schemaEditor/model/DbEditorModelController;", "modelKey", "Lcom/intellij/database/model/meta/BasicMetaId;", "(Lcom/intellij/database/schemaEditor/model/DbEditorModelController;Lcom/intellij/database/schemaEditor/ElementIdentity;Lcom/intellij/database/model/meta/BasicMetaId;)Lcom/intellij/database/schemaEditor/model/state/DbModelState;", "existsOriginally", "Lcom/intellij/database/schemaEditor/ui/DbEditorController;", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nDbEditorUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DbEditorUtils.kt\ncom/intellij/database/schemaEditor/ui/DbEditorUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,346:1\n1#2:347\n*E\n"})
public final class DbEditorUtilsKt {
    public static final void enableAutoPopup(@NotNull EditorTextField $this$enableAutoPopup) {
        Intrinsics.checkNotNullParameter((Object)$this$enableAutoPopup, (String)"<this>");
        $this$enableAutoPopup.addSettingsProvider(DbEditorUtilsKt::enableAutoPopup$lambda$0);
    }

    public static final void initCompletion(@NotNull DbEditor<?, ?> editor2, @NotNull EditorTextField field) {
        Intrinsics.checkNotNullParameter(editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        PsiFile psiFile = DbEditorUtilsKt.getPsiFile(field);
        if (psiFile == null) {
            return;
        }
        PsiFile psiFile2 = psiFile;
        DbDataSource dbDataSource = editor2.getController().getModelController().getDataSource(editor2.getIdentity());
        SearchPath searchPath = DbEditorUtilsKt.getSearchPath(dbDataSource, editor2);
        DatabaseDataKeysCore.DATA_SOURCE_KEY.set((UserDataHolder)psiFile2, (Object)dbDataSource);
        DatabaseDataKeysCore.SEARCH_PATH_KEY.set((UserDataHolder)psiFile2, (Object)searchPath);
    }

    /*
     * WARNING - void declaration
     */
    private static final SearchPath getSearchPath(DbDataSource dbDataSource, DbEditor<?, ?> editor2) {
        BasicNamespace basicNamespace;
        if (dbDataSource == null) {
            return null;
        }
        ElementMatcher elementMatcher = editor2.getController().getModelController().getMatcher();
        Intrinsics.checkNotNull((Object)elementMatcher, (String)"null cannot be cast to non-null type com.intellij.database.schemaEditor.owner.ElementMatcherImpl");
        ElementMatcherImpl matcher = (ElementMatcherImpl)elementMatcher;
        ElementIdentity<BasicNamespace> nspId = DbEditorUtilsKt.skipTo(matcher, editor2.getIdentity(), BasicNamespace.class);
        DbDataSource dbDataSource2 = dbDataSource;
        ElementIdentity<BasicNamespace> elementIdentity = nspId;
        if (elementIdentity != null) {
            void it;
            ElementIdentity<BasicNamespace> elementIdentity2 = elementIdentity;
            DbDataSource dbDataSource3 = dbDataSource2;
            boolean bl = false;
            basicNamespace = (BasicNamespace)matcher.findElement(it);
            dbDataSource2 = dbDataSource3;
        } else {
            basicNamespace = null;
        }
        return ObjectPaths.searchPathOf((DasObject)((DasObject)DbImplUtilCore.getSearchPathObjectForSwitch((DbDataSource)dbDataSource2, (DasObject)((DasObject)basicNamespace))));
    }

    public static final void setCompletionContext(@NotNull DbEditor<?, ?> editor2, @NotNull EditorTextField field) {
        Intrinsics.checkNotNullParameter(editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        PsiFile psiFile = DbEditorUtilsKt.getPsiFile(field);
        if (psiFile == null) {
            return;
        }
        PsiFile psiFile2 = psiFile;
        DatabaseDataKeysCore.CONTEXT_OBJECT_SUPPLIER_KEY.set((UserDataHolder)psiFile2, () -> DbEditorUtilsKt.setCompletionContext$lambda$2(editor2));
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final <T extends BasicElement> BasicElement findHierarchical(ElementOwner owner, ElementIdentity<T> identity) {
        BasicElement basicElement;
        BasicElement basicElement3 = identity;
        basicElement3 = basicElement3;
        if (basicElement2 == null) return null;
        BasicElement it = basicElement3;
        boolean bl = false;
        ElementOwner elementOwner = owner;
        if (elementOwner == null) return null;
        BasicElement basicElement3 = elementOwner.find((ElementIdentity)it);
        basicElement3 = basicElement3;
        if (basicElement4 == null) return null;
        it = basicElement3;
        boolean bl2 = false;
        if (it instanceof BasicDataObject) {
            ElementOwner elementOwner2 = owner;
            basicElement = DbEditorUtilsKt.findHierarchical(owner, elementOwner2 != null ? elementOwner2.getParent((ElementIdentity)identity) : null);
            return basicElement;
        } else {
            void var2_2;
            basicElement = var2_2;
        }
        return basicElement;
    }

    private static final PsiFile getPsiFile(EditorTextField field) {
        PsiFile psiFile;
        Project project = field.getProject();
        if (project != null) {
            Project it = project;
            boolean bl = false;
            psiFile = PsiDocumentManager.getInstance((Project)it).getPsiFile(field.getDocument());
        } else {
            psiFile = null;
        }
        return psiFile;
    }

    @NotNull
    public static final EditorTextField createTypeEditorField(@NotNull DbEditor<?, ?> editor2) {
        Intrinsics.checkNotNullParameter(editor2, (String)"editor");
        SqlCodeFragment sqlCodeFragment = SqlPsiFacade.getInstance((Project)editor2.getController().getProject()).createTypeElementFragment((Language)DbSqlUtilCore.getSqlDialect((Dbms)editor2.getDbms()), null, null, "");
        Intrinsics.checkNotNullExpressionValue((Object)sqlCodeFragment, (String)"createTypeElementFragment(...)");
        return DbEditorUtilsKt.createFragmentEditorWithCompletion((PsiFile)sqlCodeFragment);
    }

    @NotNull
    public static final EditorTextField createExpressionEditorField(@NotNull DbEditor<?, ?> editor2) {
        Intrinsics.checkNotNullParameter(editor2, (String)"editor");
        SqlCodeFragment sqlCodeFragment = SqlPsiFacade.getInstance((Project)editor2.getController().getProject()).createExpressionFragment((Language)DbSqlUtilCore.getSqlDialect((Dbms)editor2.getDbms()), null, null, "");
        Intrinsics.checkNotNullExpressionValue((Object)sqlCodeFragment, (String)"createExpressionFragment(...)");
        return DbEditorUtilsKt.createFragmentEditorWithCompletion((PsiFile)sqlCodeFragment);
    }

    @NotNull
    public static final EditorTextField createBigSqlEditorField(@NotNull DbEditor<?, ?> editor2) {
        Intrinsics.checkNotNullParameter(editor2, (String)"editor");
        EditorTextField editorTextField2 = DatabaseDialogsHelper.createEditorTextArea(DbEditorUtilsKt.createSqlFile(editor2, ""), false, false, false);
        Intrinsics.checkNotNullExpressionValue((Object)editorTextField2, (String)"createEditorTextArea(...)");
        return editorTextField2;
    }

    public static final void updateSqlEditorField(@NotNull DbEditor<?, ?> editor2, @NotNull EditorTextField field) {
        SqlLanguageDialect dialect;
        Intrinsics.checkNotNullParameter(editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        PsiFile psiFile = DbEditorUtilsKt.getPsiFile(field);
        Language language = psiFile != null ? psiFile.getLanguage() : null;
        SqlLanguageDialect sqlLanguageDialect = dialect = language instanceof SqlLanguageDialect ? (SqlLanguageDialect)language : null;
        if (dialect != null && Intrinsics.areEqual((Object)dialect, (Object)DbSqlUtilCore.getSqlDialect((Dbms)editor2.getDbms()))) {
            return;
        }
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)editor2.getController().getProject());
        String string = field.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        Document document = psiDocumentManager.getDocument(DbEditorUtilsKt.createSqlFile(editor2, string));
        Intrinsics.checkNotNull((Object)document);
        field.setDocument(document);
    }

    @NotNull
    public static final PsiFile createSqlFile(@NotNull DbEditor<?, ?> editor2, @NotNull String text) {
        Intrinsics.checkNotNullParameter(editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        PsiFile psiFile = PsiFileFactory.getInstance((Project)editor2.getController().getProject()).createFileFromText("a.sql", (Language)DbSqlUtilCore.getSqlDialect((Dbms)editor2.getDbms()), (CharSequence)text);
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"createFileFromText(...)");
        return psiFile;
    }

    private static final EditorTextField createFragmentEditorWithCompletion(PsiFile fragment) {
        EditorTextField field = DbEditorUtilsKt.createFragmentEditor(fragment);
        ManualPopupButton.INSTANCE.install(field, true);
        field.addSettingsProvider(DbEditorUtilsKt::createFragmentEditorWithCompletion$lambda$6);
        return field;
    }

    private static final EditorTextField createFragmentEditor(PsiFile fragment) {
        EditorTextField editorTextField2 = DatabaseDialogsHelper.createLanguageEditorField(fragment);
        Intrinsics.checkNotNullExpressionValue((Object)editorTextField2, (String)"createLanguageEditorField(...)");
        EditorTextField field = editorTextField2;
        AutoSelectListener.INSTANCE.install((JComponent)field);
        return field;
    }

    @Nullable
    public static final <T extends BasicElement> ElementIdentity<T> skipTo(@NotNull ElementMatcher matcher, @Nullable ElementIdentity<?> id, @NotNull Class<T> clazz) {
        Intrinsics.checkNotNullParameter((Object)matcher, (String)"matcher");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        ElementIdentity tmp = id;
        while (tmp != null) {
            ElementIdentity res2 = ElementIdentity.tryCast(tmp, clazz);
            if (res2 != null) {
                return res2;
            }
            tmp = matcher.getParent(tmp);
        }
        return null;
    }

    public static final boolean isAncestor(@NotNull ElementMatcher matcher, @NotNull ElementIdentity<?> ancestorId, @NotNull ElementIdentity<?> id, boolean strict) {
        Intrinsics.checkNotNullParameter((Object)matcher, (String)"matcher");
        Intrinsics.checkNotNullParameter(ancestorId, (String)"ancestorId");
        Intrinsics.checkNotNullParameter(id, (String)"id");
        if (Intrinsics.areEqual(id, ancestorId)) {
            return !strict;
        }
        return DbEditorUtilsKt.getAncestorUnder(matcher, ancestorId, id) != null;
    }

    @Nullable
    public static final ElementIdentity<?> getAncestorUnder(@NotNull ElementMatcher matcher, @NotNull ElementIdentity<?> underId, @NotNull ElementIdentity<?> id) {
        Intrinsics.checkNotNullParameter((Object)matcher, (String)"matcher");
        Intrinsics.checkNotNullParameter(underId, (String)"underId");
        Intrinsics.checkNotNullParameter(id, (String)"id");
        ElementIdentity tmp = id;
        while (tmp != null) {
            ElementIdentity next = matcher.getParent(tmp);
            if (Intrinsics.areEqual((Object)next, underId)) {
                return tmp;
            }
            tmp = next;
        }
        return null;
    }

    public static final /* synthetic */ <S extends DbModelState> S resolveState(DbEditorModelController $this$resolveState, ElementIdentity<?> id, BasicMetaId modelKey) {
        Intrinsics.checkNotNullParameter((Object)$this$resolveState, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)modelKey, (String)"modelKey");
        boolean $i$f$resolveState = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"S");
        return (S)$this$resolveState.resolveState(id, modelKey, DbModelState.class);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean existsOriginally(@NotNull DbEditorModelController $this$existsOriginally, @Nullable ElementIdentity<?> id) {
        Intrinsics.checkNotNullParameter((Object)$this$existsOriginally, (String)"<this>");
        if (id == null) return false;
        ElementOwner elementOwner = $this$existsOriginally.getMatcher().getOriginalOwner();
        if (elementOwner == null) return false;
        BasicElement basicElement = elementOwner.find(id);
        if (basicElement == null) return false;
        return true;
    }

    public static final boolean existsOriginally(@NotNull DbEditorController $this$existsOriginally, @Nullable ElementIdentity<?> id) {
        Intrinsics.checkNotNullParameter((Object)$this$existsOriginally, (String)"<this>");
        DbEditorModelController dbEditorModelController = $this$existsOriginally.getModelController();
        Intrinsics.checkNotNullExpressionValue((Object)dbEditorModelController, (String)"getModelController(...)");
        return DbEditorUtilsKt.existsOriginally(dbEditorModelController, id);
    }

    private static final void enableAutoPopup$lambda$0(EditorEx e) {
        e.putUserData(AutoPopupController.AUTO_POPUP_ON_FOCUS_GAINED, (Object)true);
    }

    private static final DasObject setCompletionContext$lambda$2(DbEditor $editor) {
        return (DasObject)DbEditorUtilsKt.findHierarchical($editor.getController().getModelController().getActualOwner(), $editor.getIdentity());
    }

    private static final void createFragmentEditorWithCompletion$lambda$6(EditorEx it) {
        TextCompletionUtil.installCompletionHint((EditorEx)it);
    }
}

