/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.trac;

import com.intellij.openapi.project.Project;
import com.intellij.tasks.TaskBundle;
import com.intellij.tasks.config.BaseRepositoryEditor;
import com.intellij.tasks.trac.TracRepository;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.Consumer;
import com.intellij.util.ui.FormBuilder;
import javax.swing.JComponent;
import javax.swing.JTextField;
import org.jetbrains.annotations.Nullable;

public class TracRepositoryEditor
extends BaseRepositoryEditor<TracRepository> {
    private JTextField myDefaultSearch;
    private JBLabel mySearchLabel;

    public TracRepositoryEditor(Project project, TracRepository repository, Consumer<? super TracRepository> changeListener) {
        super(project, repository, changeListener);
        this.myDefaultSearch.setText(repository.getDefaultSearch());
    }

    @Override
    public void apply() {
        ((TracRepository)this.myRepository).setDefaultSearch(this.myDefaultSearch.getText());
        super.apply();
    }

    @Override
    @Nullable
    protected JComponent createCustomPanel() {
        this.mySearchLabel = new JBLabel(TaskBundle.message((String)"label.search", (Object[])new Object[0]), 4);
        this.myDefaultSearch = new JTextField();
        this.installListener(this.myDefaultSearch);
        return FormBuilder.createFormBuilder().addLabeledComponent((JComponent)this.mySearchLabel, (JComponent)this.myDefaultSearch).getPanel();
    }

    @Override
    public void setAnchor(@Nullable JComponent anchor) {
        super.setAnchor(anchor);
        this.mySearchLabel.setAnchor(anchor);
    }
}

