/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript;

import com.intellij.extapi.psi.ASTWrapperPsiElement;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.BasicJavaScriptElementFactory;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavascriptASTFactory;
import com.intellij.lang.javascript.psi.impl.JSFileImpl;
import com.intellij.lang.javascript.psi.jsdoc.impl.JSDocCommentImpl;
import com.intellij.lang.javascript.types.PsiGenerator;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a8\u0006\u0013"}, d2={"Lcom/intellij/lang/javascript/BackendJavaScriptElementFactory;", "Lcom/intellij/lang/javascript/BasicJavaScriptElementFactory;", "<init>", "()V", "createFile", "Lcom/intellij/psi/PsiFile;", "viewProvider", "Lcom/intellij/psi/FileViewProvider;", "language", "Lcom/intellij/lang/Language;", "createElement", "Lcom/intellij/psi/PsiElement;", "node", "Lcom/intellij/lang/ASTNode;", "createComposite", "Lcom/intellij/psi/impl/source/tree/CompositeElement;", "type", "Lcom/intellij/psi/tree/IElementType;", "Companion", "intellij.javascript.psi.impl"})
public final class BackendJavaScriptElementFactory
implements BasicJavaScriptElementFactory {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private static final JavascriptASTFactory ourAstFactory = new JavascriptASTFactory();

    @NotNull
    public PsiFile createFile(@NotNull FileViewProvider viewProvider, @NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)viewProvider, (String)"viewProvider");
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        return new JSFileImpl(viewProvider, language);
    }

    @NotNull
    public PsiElement createElement(@NotNull ASTNode node) {
        Object element2;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        IElementType iElementType = node.getElementType();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getElementType(...)");
        IElementType type2 = iElementType;
        if (JSElementTypes.XML_LITERAL_EXPRESSION == type2) {
            PsiElement psiElement = node instanceof PsiElement ? (PsiElement)node : null;
            if (psiElement == null) {
                throw new AssertionError((Object)("Literal must be PsiElement but was: " + node + " (" + node.getClass() + ")"));
            }
            return psiElement;
        }
        if (type2 instanceof PsiGenerator && (element2 = ((PsiGenerator)type2).construct(node)) != null) {
            return element2;
        }
        if (type2 == JSTokenTypes.DOC_COMMENT) {
            return (PsiElement)new JSDocCommentImpl(node);
        }
        return (PsiElement)new ASTWrapperPsiElement(node);
    }

    @Nullable
    public CompositeElement createComposite(@NotNull IElementType type2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        if (type2 == JSElementTypes.XML_TEXT || type2 == JSElementTypes.XML_ATTRIBUTE_VALUE) {
            return ourAstFactory.createComposite(type2);
        }
        return null;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/lang/javascript/BackendJavaScriptElementFactory$Companion;", "", "<init>", "()V", "ourAstFactory", "Lcom/intellij/lang/javascript/JavascriptASTFactory;", "getOurAstFactory", "()Lcom/intellij/lang/javascript/JavascriptASTFactory;", "intellij.javascript.psi.impl"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JavascriptASTFactory getOurAstFactory() {
            return ourAstFactory;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

